"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const circularReplacer_1 = require("./circularReplacer");
describe('CircularReplacer', () => {
    it(`will stringify objects normally`, () => {
        const obj1 = {
            foo: 'foo',
            bar: 'bar',
            baz: 'baz',
        };
        const obj2 = {
            foo2: 'foo2',
            bar2: 'bar2',
            baz2: 'baz2',
        };
        const obj3 = {
            foo3: 'foo3',
            bar3: 'bar3',
            baz3: 'baz3',
        };
        const objToStringify = Object.assign(Object.assign({}, obj1), { obj2: Object.assign(Object.assign({}, obj2), { obj3 }), obj3 });
        const result = JSON.stringify(objToStringify, (0, circularReplacer_1.getTrueCircularReplacer)(), 2);
        const expectedResult = [
            `{`,
            `  "foo": "foo",`,
            `  "bar": "bar",`,
            `  "baz": "baz",`,
            `  "obj2": {`,
            `    "foo2": "foo2",`,
            `    "bar2": "bar2",`,
            `    "baz2": "baz2",`,
            `    "obj3": {`,
            `      "foo3": "foo3",`,
            `      "bar3": "bar3",`,
            `      "baz3": "baz3"`,
            `    }`,
            `  },`,
            `  "obj3": {`,
            `    "foo3": "foo3",`,
            `    "bar3": "bar3",`,
            `    "baz3": "baz3"`,
            `  }`,
            `}`,
        ];
        expect(result).toBe(expectedResult.join('\n'));
    });
    it(`will stringify objects normally with circular reference1`, () => {
        const obj1 = {
            foo: 'foo',
            bar: 'bar',
            baz: 'baz',
        };
        const obj2 = {
            foo2: 'foo2',
            bar2: 'bar2',
            baz2: 'baz2',
        };
        const obj3 = {
            foo3: 'foo3',
            bar3: 'bar3',
            baz3: 'baz3',
        };
        obj1.obj2 = obj2;
        obj2.obj1 = obj1;
        obj1.obj1 = obj1;
        const objToStringify = {
            obj1,
            obj3,
        };
        obj3.objToStringify = objToStringify;
        const result = JSON.stringify(objToStringify, (0, circularReplacer_1.getTrueCircularReplacer)(), 2);
        const expectedResult = [
            `{`,
            `  "obj1": {`,
            `    "foo": "foo",`,
            `    "bar": "bar",`,
            `    "baz": "baz",`,
            `    "obj2": {`,
            `      "foo2": "foo2",`,
            `      "bar2": "bar2",`,
            `      "baz2": "baz2"`,
            `    }`,
            `  },`,
            `  "obj3": {`,
            `    "foo3": "foo3",`,
            `    "bar3": "bar3",`,
            `    "baz3": "baz3"`,
            `  }`,
            `}`,
        ];
        expect(result).toBe(expectedResult.join('\n'));
    });
    it(`will stringify objects normally with circular reference2`, () => {
        const obj1 = {
            foo: 'foo',
            bar: 'bar',
            baz: 'baz',
        };
        const obj2 = {
            foo2: 'foo2',
            bar2: 'bar2',
            baz2: 'baz2',
        };
        const obj3 = {
            foo3: 'foo3',
            bar3: 'bar3',
            baz3: 'baz3',
        };
        obj1.obj2 = obj2;
        obj2.obj1 = obj1;
        obj1.obj1 = obj1;
        const objToStringify = Object.assign(Object.assign({}, obj1), { obj2: Object.assign(Object.assign({}, obj2), { obj3 }), obj3 });
        obj3.objToStringify = objToStringify;
        const result = JSON.stringify(objToStringify, (0, circularReplacer_1.getTrueCircularReplacer)(), 2);
        const expectedResult = [
            `{`,
            `  "foo": "foo",`,
            `  "bar": "bar",`,
            `  "baz": "baz",`,
            `  "obj2": {`,
            `    "foo2": "foo2",`,
            `    "bar2": "bar2",`,
            `    "baz2": "baz2",`,
            `    "obj1": {`,
            `      "foo": "foo",`,
            `      "bar": "bar",`,
            `      "baz": "baz",`,
            `      "obj2": {`,
            `        "foo2": "foo2",`,
            `        "bar2": "bar2",`,
            `        "baz2": "baz2"`,
            `      }`,
            `    },`,
            `    "obj3": {`,
            `      "foo3": "foo3",`,
            `      "bar3": "bar3",`,
            `      "baz3": "baz3"`,
            `    }`,
            `  },`,
            `  "obj1": {`,
            `    "foo": "foo",`,
            `    "bar": "bar",`,
            `    "baz": "baz",`,
            `    "obj2": {`,
            `      "foo2": "foo2",`,
            `      "bar2": "bar2",`,
            `      "baz2": "baz2"`,
            `    }`,
            `  },`,
            `  "obj3": {`,
            `    "foo3": "foo3",`,
            `    "bar3": "bar3",`,
            `    "baz3": "baz3"`,
            `  }`,
            `}`,
        ];
        expect(result).toBe(expectedResult.join('\n'));
    });
});
//# sourceMappingURL=data:application/json;base64,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