import { ColumnType } from '../Api';
import UITypes from '../UITypes';
import AbstractColumnHelper, { SerializerOrParserFnProps } from './column.interface';
export declare class ColumnHelperClass {
    defautlHelper: string;
    private registry;
    getColumn(params: SerializerOrParserFnProps['params'] | UITypes): AbstractColumnHelper | undefined;
    getColumnDefaultMeta(uidt: UITypes): Record<string, any>;
    /**
     * Parses a stored value back into its original form.
     * Converts a database-stored value into a display-friendly format.
     *
     * @example
     * // Example: Formatting percentage values
     * dbValue = 59; // Stored in DB
     * displayValue = "59%"; // Displayed to users
     *
     * @param value - The value to be parsed from storage format.
     * @param params - Additional parameters related to column parsing.
     * @returns The parsed value in a display-friendly format.
     */
    parseValue(value: any, params: SerializerOrParserFnProps['params']): any;
    /**
     * Serializes the given value based on column parameters.
     *
     * **WARNING:** This method **can throw errors**. Use a `try-catch` block when calling it.
     *
     * @param value - The value to be serialized.
     * @param params - Additional parameters related to column serialization.
     * @returns The serialized value.
     * @throws {Error} If serialization fails.
     */
    serializeValue(value: any, params: SerializerOrParserFnProps['params']): any;
    /**
     * Parses a plain cell value back into its original form.
     * Converts a plain cell value into a display-friendly format.
     *
     * @param value - The value to be parsed from storage format.
     * @param params - Additional parameters related to column parsing.
     * @returns The parsed value in a display-friendly format.
     */
    parsePlainCellValue(value: any, params: SerializerOrParserFnProps['params']): any;
    populateFillHandle(params: {
        column: ColumnType;
        highlightedData: any[];
        numberOfRows: number;
    }): any[];
    getClipboardConfig(params: SerializerOrParserFnProps['params']): {
        column: Partial<ColumnType>;
    };
}
export declare const ColumnHelper: ColumnHelperClass;
