"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColumnHelper = exports.ColumnHelperClass = void 0;
const is_1 = require("../is");
const UITypes_1 = __importDefault(require("../UITypes"));
const columns_1 = require("./columns");
const SingleSelect_1 = require("./columns/SingleSelect");
const clipboard_config_1 = require("./utils/clipboard-config");
class ColumnHelperClass {
    constructor() {
        this.defautlHelper = 'defautlHelper';
        this.registry = {
            [this.defautlHelper]: columns_1.DefaultColumnHelper,
            [UITypes_1.default.SingleLineText]: columns_1.SingleLineTextHelper,
            [UITypes_1.default.LongText]: columns_1.LongTextHelper,
            [UITypes_1.default.Number]: columns_1.NumberHelper,
            [UITypes_1.default.Decimal]: columns_1.DecimalHelper,
            [UITypes_1.default.Currency]: columns_1.CurrencyHelper,
            [UITypes_1.default.Duration]: columns_1.DurationHelper,
            [UITypes_1.default.Percent]: columns_1.PercentHelper,
            [UITypes_1.default.Checkbox]: columns_1.CheckboxHelper,
            [UITypes_1.default.Rating]: columns_1.RatingHelper,
            [UITypes_1.default.PhoneNumber]: columns_1.PhoneNumberHelper,
            [UITypes_1.default.Email]: columns_1.EmailHelper,
            [UITypes_1.default.URL]: columns_1.UrlHelper,
            [UITypes_1.default.JSON]: columns_1.JsonHelper,
            [UITypes_1.default.GeoData]: columns_1.GeoDataHelper,
            [UITypes_1.default.Barcode]: columns_1.BarcodeHelper,
            [UITypes_1.default.QrCode]: columns_1.QrCodeHelper,
            [UITypes_1.default.Formula]: columns_1.FormulaHelper,
            [UITypes_1.default.Date]: columns_1.DateHelper,
            [UITypes_1.default.DateTime]: columns_1.DateTimeHelper,
            [UITypes_1.default.Time]: columns_1.TimeHelper,
            [UITypes_1.default.Year]: columns_1.YearHelper,
            [UITypes_1.default.CreatedTime]: columns_1.CreatedTimeHelper,
            [UITypes_1.default.LastModifiedTime]: columns_1.LastModifiedTimeHelper,
            [UITypes_1.default.SingleSelect]: SingleSelect_1.SingleSelectHelper,
            [UITypes_1.default.MultiSelect]: columns_1.MultiSelectHelper,
            [UITypes_1.default.User]: columns_1.UserHelper,
            [UITypes_1.default.Attachment]: columns_1.AttachmentHelper,
            [UITypes_1.default.CreatedBy]: columns_1.UserHelper,
            [UITypes_1.default.LastModifiedBy]: columns_1.UserHelper,
            [UITypes_1.default.Lookup]: columns_1.LookupHelper,
            [UITypes_1.default.Rollup]: columns_1.RollupHelper,
            [UITypes_1.default.Links]: columns_1.LinksHelper,
            [UITypes_1.default.LinkToAnotherRecord]: columns_1.LTARHelper,
            [UITypes_1.default.Button]: columns_1.ButtonHelper,
        };
    }
    // Method to retrieve the specific column class and instantiate it
    getColumn(params) {
        let ColumnClass;
        if ((0, is_1.ncIsString)(params)) {
            ColumnClass = this.registry[params] || this.registry[this.defautlHelper];
        }
        else {
            if (!params.col || !this.registry[params.col.uidt]) {
                ColumnClass = this.registry[this.defautlHelper];
            }
            else {
                ColumnClass = this.registry[params.col.uidt];
            }
        }
        // Instantiate the class with the column data
        return new ColumnClass();
    }
    getColumnDefaultMeta(uidt) {
        const columnInstance = this.getColumn(uidt);
        if (columnInstance) {
            return columnInstance.columnDefaultMeta || {};
        }
        return {};
    }
    /**
     * Parses a stored value back into its original form.
     * Converts a database-stored value into a display-friendly format.
     *
     * @example
     * // Example: Formatting percentage values
     * dbValue = 59; // Stored in DB
     * displayValue = "59%"; // Displayed to users
     *
     * @param value - The value to be parsed from storage format.
     * @param params - Additional parameters related to column parsing.
     * @returns The parsed value in a display-friendly format.
     */
    parseValue(value, params) {
        const columnInstance = this.getColumn(params);
        if (columnInstance) {
            return columnInstance.parseValue(value, params);
        }
    }
    /**
     * Serializes the given value based on column parameters.
     *
     * **WARNING:** This method **can throw errors**. Use a `try-catch` block when calling it.
     *
     * @param value - The value to be serialized.
     * @param params - Additional parameters related to column serialization.
     * @returns The serialized value.
     * @throws {Error} If serialization fails.
     */
    serializeValue(value, params) {
        const columnInstance = this.getColumn(params);
        if (columnInstance) {
            return columnInstance.serializeValue(value, params);
        }
    }
    /**
     * Parses a plain cell value back into its original form.
     * Converts a plain cell value into a display-friendly format.
     *
     * @param value - The value to be parsed from storage format.
     * @param params - Additional parameters related to column parsing.
     * @returns The parsed value in a display-friendly format.
     */
    parsePlainCellValue(value, params) {
        const columnInstance = this.getColumn(params);
        if (columnInstance) {
            return columnInstance.parsePlainCellValue(value, params);
        }
        return value;
    }
    populateFillHandle(params) {
        const columnInstance = this.getColumn({
            col: params.column,
        });
        if (columnInstance) {
            return columnInstance.populateFillHandle(params);
        }
        return undefined;
    }
    getClipboardConfig(params) {
        const columnInstance = this.getColumn(params);
        if (columnInstance) {
            return columnInstance.getClipboardConfig(params);
        }
        return (0, clipboard_config_1.getClipboardConfigForColumn)({ col: params.col });
    }
}
exports.ColumnHelperClass = ColumnHelperClass;
exports.ColumnHelper = new ColumnHelperClass();
//# sourceMappingURL=data:application/json;base64,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