"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const clipboard_config_1 = require("./utils/clipboard-config");
const fill_handler_1 = require("./utils/fill-handler");
class AbstractColumnHelper {
    constructor() {
        this.columnDefaultMeta = {};
    }
    equalityComparison(a, b, _param) {
        return a == b;
    }
    populateFillHandle(params) {
        return (0, fill_handler_1.populateFillHandleStrictCopy)(params);
    }
    getClipboardConfig(params) {
        return (0, clipboard_config_1.getClipboardConfigForColumn)({ col: params.col });
    }
}
exports.default = AbstractColumnHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29sdW1uLmludGVyZmFjZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbi5pbnRlcmZhY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFDQSwrREFBdUU7QUFDdkUsdURBQW9FO0FBRXBFLE1BQThCLG9CQUFvQjtJQUFsRDtRQUNTLHNCQUFpQixHQUF5QixFQUFFLENBQUM7SUFvRXRELENBQUM7SUFuQlEsa0JBQWtCLENBQ3ZCLENBQU0sRUFDTixDQUFNLEVBQ04sTUFBMkM7UUFFM0MsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ2hCLENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxNQUl6QjtRQUNDLE9BQU8sSUFBQSwyQ0FBNEIsRUFBQyxNQUFNLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRU0sa0JBQWtCLENBQUMsTUFBMkM7UUFDbkUsT0FBTyxJQUFBLDhDQUEyQixFQUFDLEVBQUUsR0FBRyxFQUFFLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO0lBQzFELENBQUM7Q0FDRjtBQXJFRCx1Q0FxRUMifQ==