"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttachmentHelper = void 0;
const error_1 = require("../../../lib/error");
const helperFunctions_1 = require("../../../lib/helperFunctions");
const is_1 = require("../../../lib/is");
const __1 = require("..");
const column_interface_1 = __importDefault(require("../column.interface"));
class AttachmentHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        if (!value || params.serializeSearchQuery)
            return null;
        let parsedVal = [];
        try {
            parsedVal = (0, helperFunctions_1.parseProp)(value);
            if ((0, is_1.ncIsObject)(parsedVal) && !(0, is_1.ncIsEmptyObject)(parsedVal)) {
                parsedVal = [parsedVal];
            }
            else if (!(0, is_1.ncIsArray)(parsedVal)) {
                parsedVal = [];
            }
        }
        catch (_a) {
            if (params.isMultipleCellPaste) {
                return null;
            }
            throw new error_1.SilentTypeConversionError();
        }
        if (parsedVal.some((v) => !((v === null || v === void 0 ? void 0 : v.url) || (v === null || v === void 0 ? void 0 : v.data) || (v === null || v === void 0 ? void 0 : v.path)))) {
            return null;
        }
        return parsedVal;
    }
    parseValue(value) {
        return (0, __1.parseDefault)(value);
    }
    parsePlainCellValue(value) {
        var _a;
        if ((0, is_1.ncIsArray)(value)) {
            return value.map((v) => `${v.title}`).join(', ');
        }
        return (_a = value === null || value === void 0 ? void 0 : value.toString()) !== null && _a !== void 0 ? _a : '';
    }
}
exports.AttachmentHelper = AttachmentHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXR0YWNobWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvQXR0YWNobWVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx1Q0FBd0Q7QUFDeEQsMkRBQWtEO0FBQ2xELGlDQUFrRTtBQUNsRSwwQkFBa0M7QUFDbEMsMkVBRTZCO0FBRTdCLE1BQWEsZ0JBQWlCLFNBQVEsMEJBQW9CO0lBQTFEOztRQUNFLHNCQUFpQixHQUFHLEVBQUUsQ0FBQztJQXdDekIsQ0FBQztJQXRDQyxjQUFjLENBQUMsS0FBVSxFQUFFLE1BQTJDO1FBQ3BFLElBQUksQ0FBQyxLQUFLLElBQUksTUFBTSxDQUFDLG9CQUFvQjtZQUFFLE9BQU8sSUFBSSxDQUFDO1FBRXZELElBQUksU0FBUyxHQUFHLEVBQUUsQ0FBQztRQUVuQixJQUFJLENBQUM7WUFDSCxTQUFTLEdBQUcsSUFBQSwyQkFBUyxFQUFDLEtBQUssQ0FBQyxDQUFDO1lBRTdCLElBQUksSUFBQSxlQUFVLEVBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFBLG9CQUFlLEVBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQztnQkFDekQsU0FBUyxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUM7WUFDMUIsQ0FBQztpQkFBTSxJQUFJLENBQUMsSUFBQSxjQUFTLEVBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQztnQkFDakMsU0FBUyxHQUFHLEVBQUUsQ0FBQztZQUNqQixDQUFDO1FBQ0gsQ0FBQztRQUFDLFdBQU0sQ0FBQztZQUNQLElBQUksTUFBTSxDQUFDLG1CQUFtQixFQUFFLENBQUM7Z0JBQy9CLE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztZQUVELE1BQU0sSUFBSSxpQ0FBeUIsRUFBRSxDQUFDO1FBQ3hDLENBQUM7UUFFRCxJQUFJLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFNLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFBLENBQUMsYUFBRCxDQUFDLHVCQUFELENBQUMsQ0FBRSxHQUFHLE1BQUksQ0FBQyxhQUFELENBQUMsdUJBQUQsQ0FBQyxDQUFFLElBQUksQ0FBQSxLQUFJLENBQUMsYUFBRCxDQUFDLHVCQUFELENBQUMsQ0FBRSxJQUFJLENBQUEsQ0FBQyxDQUFDLEVBQUUsQ0FBQztZQUNoRSxPQUFPLElBQUksQ0FBQztRQUNkLENBQUM7UUFFRCxPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDO0lBRUQsVUFBVSxDQUFDLEtBQVU7UUFDbkIsT0FBTyxJQUFBLGdCQUFZLEVBQUMsS0FBSyxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUVELG1CQUFtQixDQUFDLEtBQVU7O1FBQzVCLElBQUksSUFBQSxjQUFTLEVBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUNyQixPQUFPLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ25ELENBQUM7UUFDRCxPQUFPLE1BQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFFBQVEsRUFBRSxtQ0FBSSxFQUFFLENBQUM7SUFDakMsQ0FBQztDQUNGO0FBekNELDRDQXlDQyJ9