"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ButtonHelper = void 0;
const is_1 = require("../../../lib/is");
const __1 = require("..");
const column_interface_1 = __importDefault(require("../column.interface"));
const error_1 = require("../../../lib/error");
const Api_1 = require("../../../lib/Api");
class ButtonHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(_value, params) {
        if (params.serializeSearchQuery)
            return null;
        if (params.isMultipleCellPaste) {
            return undefined;
        }
        else {
            throw new error_1.ComputedTypePasteError();
        }
    }
    parseValue(value, _params) {
        if (!(0, is_1.ncIsObject)(value))
            return null;
        value = value;
        if (value.type === Api_1.ButtonActionsType.Url)
            return value.url;
        return (0, __1.parseDefault)(value);
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = this.parseValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.ButtonHelper = ButtonHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQnV0dG9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvY29sdW1ucy9CdXR0b24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsaUNBQXNDO0FBQ3RDLDBCQUFrQztBQUNsQywyRUFFNkI7QUFDN0IsdUNBQXFEO0FBQ3JELG1DQUE4QztBQUU5QyxNQUFhLFlBQWEsU0FBUSwwQkFBb0I7SUFBdEQ7O1FBQ0Usc0JBQWlCLEdBQUcsRUFBRSxDQUFDO0lBa0N6QixDQUFDO0lBaENDLGNBQWMsQ0FDWixNQUFXLEVBQ1gsTUFBMkM7UUFFM0MsSUFBSSxNQUFNLENBQUMsb0JBQW9CO1lBQUUsT0FBTyxJQUFJLENBQUM7UUFFN0MsSUFBSSxNQUFNLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztZQUMvQixPQUFPLFNBQVMsQ0FBQztRQUNuQixDQUFDO2FBQU0sQ0FBQztZQUNOLE1BQU0sSUFBSSw4QkFBc0IsRUFBRSxDQUFDO1FBQ3JDLENBQUM7SUFDSCxDQUFDO0lBRUQsVUFBVSxDQUNSLEtBQVUsRUFDVixPQUE0QztRQUU1QyxJQUFJLENBQUMsSUFBQSxlQUFVLEVBQUMsS0FBSyxDQUFDO1lBQUUsT0FBTyxJQUFJLENBQUM7UUFFcEMsS0FBSyxHQUFHLEtBQTRCLENBQUM7UUFFckMsSUFBSSxLQUFLLENBQUMsSUFBSSxLQUFLLHVCQUFpQixDQUFDLEdBQUc7WUFBRSxPQUFPLEtBQUssQ0FBQyxHQUFHLENBQUM7UUFFM0QsT0FBTyxJQUFBLGdCQUFZLEVBQUMsS0FBSyxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUVELG1CQUFtQixDQUNqQixLQUFVLEVBQ1YsTUFBMkM7O1FBRTNDLE9BQU8sTUFBQSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsbUNBQUksRUFBRSxDQUFDO0lBQzlDLENBQUM7Q0FDRjtBQW5DRCxvQ0FtQ0MifQ==