"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurrencyHelper = void 0;
const error_1 = require("../../../lib/error");
const __1 = require("..");
const column_interface_1 = __importDefault(require("../column.interface"));
const fill_handler_1 = require("../utils/fill-handler");
const is_1 = require("../../../lib/is");
class CurrencyHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            currency_locale: 'en-US',
            currency_code: 'USD',
            precision: __1.precisionFormats[2],
        };
    }
    serializeValue(value, params) {
        value = (0, __1.serializeCurrencyValue)(value, params);
        if (value === null) {
            if (params.isMultipleCellPaste || params.serializeSearchQuery) {
                return null;
            }
            else {
                throw new error_1.SilentTypeConversionError();
            }
        }
        return value;
    }
    parseValue(value, params) {
        // Return empty string for null/undefined values to prevent "null" text when pasting
        if (value === null || value === undefined) {
            return '';
        }
        return (0, __1.parseCurrencyValue)(value, params.col);
    }
    parsePlainCellValue(value, params) {
        var _a;
        if (params.isAggregation && (0, is_1.ncIsNaN)(value)) {
            value = 0;
        }
        return `${(_a = this.parseValue(value, params)) !== null && _a !== void 0 ? _a : ''}`;
    }
    // using string number fill handler
    populateFillHandle(params) {
        return (0, fill_handler_1.populateFillHandleStringNumber)(params);
    }
}
exports.CurrencyHelper = CurrencyHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ3VycmVuY3kuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9zcmMvbGliL2NvbHVtbkhlbHBlci9jb2x1bW5zL0N1cnJlbmN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHVDQUF3RDtBQUN4RCwwQkFJWTtBQUNaLDJFQUU2QjtBQUM3Qix3REFBdUU7QUFFdkUsaUNBQW1DO0FBRW5DLE1BQWEsY0FBZSxTQUFRLDBCQUFvQjtJQUF4RDs7UUFDRSxzQkFBaUIsR0FBRztZQUNsQixlQUFlLEVBQUUsT0FBTztZQUN4QixhQUFhLEVBQUUsS0FBSztZQUNwQixTQUFTLEVBQUUsb0JBQWdCLENBQUMsQ0FBQyxDQUFDO1NBQy9CLENBQUM7SUFpREosQ0FBQztJQS9DQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDO1FBRTNDLEtBQUssR0FBRyxJQUFBLDBCQUFzQixFQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsQ0FBQztRQUU5QyxJQUFJLEtBQUssS0FBSyxJQUFJLEVBQUUsQ0FBQztZQUNuQixJQUFJLE1BQU0sQ0FBQyxtQkFBbUIsSUFBSSxNQUFNLENBQUMsb0JBQW9CLEVBQUUsQ0FBQztnQkFDOUQsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sTUFBTSxJQUFJLGlDQUF5QixFQUFFLENBQUM7WUFDeEMsQ0FBQztRQUNILENBQUM7UUFFRCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCxVQUFVLENBQ1IsS0FBVSxFQUNWLE1BQTJDO1FBRTNDLG9GQUFvRjtRQUNwRixJQUFJLEtBQUssS0FBSyxJQUFJLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQzFDLE9BQU8sRUFBRSxDQUFDO1FBQ1osQ0FBQztRQUNELE9BQU8sSUFBQSxzQkFBa0IsRUFBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQy9DLENBQUM7SUFFRCxtQkFBbUIsQ0FDakIsS0FBVSxFQUNWLE1BQTJDOztRQUUzQyxJQUFJLE1BQU0sQ0FBQyxhQUFhLElBQUksSUFBQSxZQUFPLEVBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUMzQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1FBQ1osQ0FBQztRQUVELE9BQU8sR0FBRyxNQUFBLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxtQ0FBSSxFQUFFLEVBQUUsQ0FBQztJQUNuRCxDQUFDO0lBRUQsbUNBQW1DO0lBQzFCLGtCQUFrQixDQUFDLE1BSTNCO1FBQ0MsT0FBTyxJQUFBLDZDQUE4QixFQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ2hELENBQUM7Q0FDRjtBQXRERCx3Q0FzREMifQ==