"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DateHelper = void 0;
const dayjs_1 = __importDefault(require("dayjs"));
const dateTimeHelper_1 = require("../../../lib/dateTimeHelper");
const __1 = require("..");
const column_interface_1 = __importDefault(require("../column.interface"));
const error_1 = require("../../../lib/error");
const helperFunctions_1 = require("../../../lib/helperFunctions");
const is_1 = require("../../../lib/is");
const fill_handler_1 = require("../utils/fill-handler");
class DateHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            date_format: dateTimeHelper_1.dateFormats[0],
        };
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery)
            return null;
        value = (0, __1.serializeDateOrDateTimeValue)(value, params);
        if (value === null) {
            if (params.isMultipleCellPaste) {
                return null;
            }
            else {
                throw new error_1.SilentTypeConversionError();
            }
        }
        return value;
    }
    parseValue(value, params) {
        return (0, __1.parseDateValue)(value, params.col, params.isSystemCol);
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = (0, __1.parseDateValue)(value, params.col, params.isSystemCol)) !== null && _a !== void 0 ? _a : '';
    }
    populateFillHandle(params) {
        var _a;
        const { column, highlightedData, numberOfRows } = params;
        if (highlightedData.length < 2) {
            return (0, fill_handler_1.populateFillHandleStrictCopy)(params);
        }
        // data is in form like 'YYYY-MM-DD' depends on meta dateformat
        const meta = (0, helperFunctions_1.parseProp)(column.meta);
        const metaDateFormat = (_a = meta.date_format) !== null && _a !== void 0 ? _a : 'YYYY-MM-DD';
        const dateFormat = metaDateFormat + ' HH:mm:ss';
        let lastData;
        let modifier = undefined;
        let scale = 'D';
        const setModifierForScaleIfRound = (currentData, lastData, diffScale) => {
            const currentModifier = currentData.diff(lastData, diffScale, true);
            if ((0, __1.isNumberRound)(currentModifier)) {
                scale = __1.DATE_DIFF_TO_SCALE_LABEL_MAP[diffScale];
                modifier = currentModifier;
            }
        };
        // map to dayjs
        const dayJsHighlightedData = [];
        for (const date of highlightedData) {
            if ((0, is_1.ncIsNullOrUndefined)(date) ||
                date === '' ||
                typeof date !== 'string') {
                return (0, fill_handler_1.populateFillHandleStrictCopy)(params);
            }
            const currentData = (0, dayjs_1.default)(date + ' 00:00:00', dateFormat);
            // unlikely on normal case
            if (!currentData.isValid()) {
                return (0, fill_handler_1.populateFillHandleStrictCopy)(params);
            }
            if (!lastData) {
                lastData = currentData;
            }
            else {
                if ((0, is_1.ncIsUndefined)(modifier)) {
                    const modifierInDays = currentData.diff(lastData, 'day');
                    if (modifierInDays > 354) {
                        setModifierForScaleIfRound(currentData, lastData, 'year');
                    }
                    else if (modifierInDays > 28) {
                        setModifierForScaleIfRound(currentData, lastData, 'month');
                    }
                    else {
                        modifier = modifierInDays;
                        scale = 'D';
                    }
                }
                else {
                    const currentModifier = currentData.diff(lastData, __1.DATE_SCALE_LABEL_TO_DIFF_MAP[scale]);
                    if (currentModifier !== modifier) {
                        return (0, fill_handler_1.populateFillHandleStrictCopy)(params);
                    }
                }
                lastData = currentData;
            }
            dayJsHighlightedData.push(lastData);
        }
        if (modifier === 0) {
            return (0, fill_handler_1.populateFillHandleStrictCopy)(params);
        }
        const numberToGenerate = numberOfRows - highlightedData.length;
        return Array.from({ length: numberToGenerate }).map(() => {
            const currentData = lastData.add(modifier, __1.DATE_SCALE_LABEL_TO_DIFF_MAP[scale]);
            lastData = currentData;
            return currentData.format(metaDateFormat);
        });
    }
}
exports.DateHelper = DateHelper;
//# sourceMappingURL=data:application/json;base64,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