"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Date_1 = require("./Date");
describe('Date', () => {
    describe('populateFillHandle', () => {
        it('will populate with strict copy because some is empty', () => {
            const highlightedData = ['2025-01-01', '', '2025-01-02', '2025-01-03'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new Date_1.DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 8,
            });
            expect(result).toEqual(highlightedData);
        });
        it('will populate with strict copy because the modifier is not same', () => {
            const highlightedData = ['2025-01-01', '2025-01-03', '2025-01-04'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new Date_1.DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(highlightedData);
        });
        it('will populate with strict copy because the modifier is 0', () => {
            const highlightedData = ['2025-01-01', '2025-01-01', '2025-01-01'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new Date_1.DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(highlightedData);
        });
        it('will populate with incremental 1 day', () => {
            const highlightedData = ['2025-01-01', '2025-01-02', '2025-01-03'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new Date_1.DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['2025-01-04', '2025-01-05', '2025-01-06']);
        });
        it('will populate with incremental 2 days', () => {
            const highlightedData = ['2025-01-25', '2025-01-27', '2025-01-29'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new Date_1.DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['2025-01-31', '2025-02-02', '2025-02-04']);
        });
        it('will populate with incremental 1 month', () => {
            const highlightedData = ['2025-01-02', '2025-02-02', '2025-03-02'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new Date_1.DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['2025-04-02', '2025-05-02', '2025-06-02']);
        });
        it('will populate with decrement 2 days with MM/DD/YYYY format', () => {
            const highlightedData = ['02/04/2025', '02/02/2025', '01/31/2025'];
            const column = { meta: { date_format: 'MM/DD/YYYY' } };
            const result = new Date_1.DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['01/29/2025', '01/27/2025', '01/25/2025']);
        });
        it('will populate with decrement 2 days', () => {
            const highlightedData = ['2025-02-04', '2025-02-02', '2025-01-31'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new Date_1.DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['2025-01-29', '2025-01-27', '2025-01-25']);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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