"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailHelper = void 0;
const helperFunctions_1 = require("../../../lib/helperFunctions");
const utils_1 = require("../utils");
const SingleLineText_1 = require("./SingleLineText");
class EmailHelper extends SingleLineText_1.SingleLineTextHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        value = (0, utils_1.serializeStringValue)(value);
        if (!params.serializeSearchQuery && (0, helperFunctions_1.parseProp)(params.col.meta).validate) {
            return (0, utils_1.serializeEmail)(value);
        }
        return value;
    }
}
exports.EmailHelper = EmailHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRW1haWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9zcmMvbGliL2NvbHVtbkhlbHBlci9jb2x1bW5zL0VtYWlsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDJEQUFrRDtBQUVsRCxvQ0FBZ0U7QUFDaEUscURBQXdEO0FBRXhELE1BQWEsV0FBWSxTQUFRLHFDQUFvQjtJQUFyRDs7UUFDRSxzQkFBaUIsR0FBRyxFQUFFLENBQUM7SUFZekIsQ0FBQztJQVhDLGNBQWMsQ0FDWixLQUFVLEVBQ1YsTUFBMkM7UUFFM0MsS0FBSyxHQUFHLElBQUEsNEJBQW9CLEVBQUMsS0FBSyxDQUFDLENBQUM7UUFFcEMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxvQkFBb0IsSUFBSSxJQUFBLDJCQUFTLEVBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUN4RSxPQUFPLElBQUEsc0JBQWMsRUFBQyxLQUFLLENBQUMsQ0FBQztRQUMvQixDQUFDO1FBQ0QsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDO0NBQ0Y7QUFiRCxrQ0FhQyJ9