"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeoDataHelper = void 0;
const error_1 = require("../../../lib/error");
const geoDataUtils_1 = require("../../../lib/geoDataUtils");
const is_1 = require("../../../lib/is");
const column_interface_1 = __importDefault(require("../column.interface"));
class GeoDataHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        value = this.parseValue(value);
        if (!params.serializeSearchQuery && value === null) {
            throw new error_1.SilentTypeConversionError();
        }
        return value;
    }
    parseValue(value) {
        if (!(0, is_1.ncIsString)(value))
            return null;
        const geoValue = value
            .replace(',', ';')
            .split(';')
            .map((k) => k.trim());
        if (geoValue.length === 2) {
            if (!(0, is_1.ncIsNaN)(geoValue[0]) && !(0, is_1.ncIsNaN)(geoValue[1])) {
                return geoValue
                    .map((k) => (0, geoDataUtils_1.convertGeoNumberToString)(Number(k)))
                    .join(';');
            }
        }
        return null;
    }
    parsePlainCellValue(value) {
        var _a;
        return (_a = this.parseValue(value)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.GeoDataHelper = GeoDataHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiR2VvRGF0YS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvR2VvRGF0YS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx1Q0FBd0Q7QUFDeEQscURBQThEO0FBQzlELGlDQUErQztBQUMvQywyRUFFNkI7QUFFN0IsTUFBYSxhQUFjLFNBQVEsMEJBQW9CO0lBQXZEOztRQUNFLHNCQUFpQixHQUFHLEVBQUUsQ0FBQztJQXFDekIsQ0FBQztJQW5DQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDO1FBRTNDLEtBQUssR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRS9CLElBQUksQ0FBQyxNQUFNLENBQUMsb0JBQW9CLElBQUksS0FBSyxLQUFLLElBQUksRUFBRSxDQUFDO1lBQ25ELE1BQU0sSUFBSSxpQ0FBeUIsRUFBRSxDQUFDO1FBQ3hDLENBQUM7UUFFRCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCxVQUFVLENBQUMsS0FBVTtRQUNuQixJQUFJLENBQUMsSUFBQSxlQUFVLEVBQUMsS0FBSyxDQUFDO1lBQUUsT0FBTyxJQUFJLENBQUM7UUFFcEMsTUFBTSxRQUFRLEdBQUcsS0FBSzthQUNuQixPQUFPLENBQUMsR0FBRyxFQUFFLEdBQUcsQ0FBQzthQUNqQixLQUFLLENBQUMsR0FBRyxDQUFDO2FBQ1YsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztRQUV4QixJQUFJLFFBQVEsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFLENBQUM7WUFDMUIsSUFBSSxDQUFDLElBQUEsWUFBTyxFQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBQSxZQUFPLEVBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztnQkFDbkQsT0FBTyxRQUFRO3FCQUNaLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsSUFBQSx1Q0FBd0IsRUFBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztxQkFDL0MsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ2YsQ0FBQztRQUNILENBQUM7UUFFRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRCxtQkFBbUIsQ0FBQyxLQUFVOztRQUM1QixPQUFPLE1BQUEsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsbUNBQUksRUFBRSxDQUFDO0lBQ3RDLENBQUM7Q0FDRjtBQXRDRCxzQ0FzQ0MifQ==