"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonHelper = void 0;
const column_interface_1 = __importDefault(require("../../../lib/columnHelper/column.interface"));
const error_1 = require("../../../lib/error");
const utils_1 = require("../utils");
const is_1 = require("../../../lib/is");
class JsonHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery) {
            return (0, is_1.ncIsString)(value) ? value : null;
        }
        value = (0, utils_1.serializeJsonValue)(value);
        if (value === null) {
            throw new error_1.SilentTypeConversionError();
        }
        return value;
    }
    parseValue(value) {
        return (0, utils_1.parseJsonValue)(value);
    }
    parsePlainCellValue(value) {
        return (0, utils_1.parseJsonValue)(value);
    }
    equalityComparison(a, b, _param) {
        const aStr = typeof a === 'object'
            ? JSON.stringify(a)
            : typeof a === 'string'
                ? a
                : a.toString();
        const bStr = typeof b === 'object'
            ? JSON.stringify(b)
            : typeof b === 'string'
                ? b
                : b.toString();
        return aStr === bStr;
    }
}
exports.JsonHelper = JsonHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSnNvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvSnNvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSwyRkFFNkM7QUFDN0MsdUNBQXdEO0FBQ3hELG9DQUE4RDtBQUM5RCxpQ0FBc0M7QUFFdEMsTUFBYSxVQUFXLFNBQVEsMEJBQW9CO0lBQXBEOztRQUNFLHNCQUFpQixHQUFHLEVBQUUsQ0FBQztJQThDekIsQ0FBQztJQTVDQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDO1FBRTNDLElBQUksTUFBTSxDQUFDLG9CQUFvQixFQUFFLENBQUM7WUFDaEMsT0FBTyxJQUFBLGVBQVUsRUFBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDMUMsQ0FBQztRQUVELEtBQUssR0FBRyxJQUFBLDBCQUFrQixFQUFDLEtBQUssQ0FBQyxDQUFDO1FBRWxDLElBQUksS0FBSyxLQUFLLElBQUksRUFBRSxDQUFDO1lBQ25CLE1BQU0sSUFBSSxpQ0FBeUIsRUFBRSxDQUFDO1FBQ3hDLENBQUM7UUFFRCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCxVQUFVLENBQUMsS0FBVTtRQUNuQixPQUFPLElBQUEsc0JBQWMsRUFBQyxLQUFLLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQsbUJBQW1CLENBQUMsS0FBVTtRQUM1QixPQUFPLElBQUEsc0JBQWMsRUFBQyxLQUFLLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRVEsa0JBQWtCLENBQ3pCLENBQU0sRUFDTixDQUFNLEVBQ04sTUFBMkM7UUFFM0MsTUFBTSxJQUFJLEdBQ1IsT0FBTyxDQUFDLEtBQUssUUFBUTtZQUNuQixDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7WUFDbkIsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLFFBQVE7Z0JBQ3ZCLENBQUMsQ0FBQyxDQUFDO2dCQUNILENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDbkIsTUFBTSxJQUFJLEdBQ1IsT0FBTyxDQUFDLEtBQUssUUFBUTtZQUNuQixDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7WUFDbkIsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLFFBQVE7Z0JBQ3ZCLENBQUMsQ0FBQyxDQUFDO2dCQUNILENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDbkIsT0FBTyxJQUFJLEtBQUssSUFBSSxDQUFDO0lBQ3ZCLENBQUM7Q0FDRjtBQS9DRCxnQ0ErQ0MifQ==