"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BelongsToHelper = void 0;
const is_1 = require("../../../../lib/is");
const column_interface_1 = __importDefault(require("../../column.interface"));
const error_1 = require("../../../../lib/error");
const Lookup_1 = require("../Lookup");
class BelongsToHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        var _a;
        let parsedVal = value;
        try {
            parsedVal = typeof value === 'string' ? JSON.parse(value) : value;
        }
        catch (_b) { }
        if (!(0, is_1.ncHasProperties)(parsedVal, ['fk_related_model_id', 'value']) ||
            !(0, is_1.ncIsObject)(parsedVal === null || parsedVal === void 0 ? void 0 : parsedVal.value) ||
            (parsedVal === null || parsedVal === void 0 ? void 0 : parsedVal.fk_related_model_id) !==
                ((_a = params.col.colOptions) === null || _a === void 0 ? void 0 : _a.fk_related_model_id)) {
            throw new error_1.SilentTypeConversionError();
        }
        return parsedVal;
    }
    parseValue(value, params) {
        return JSON.stringify({
            fk_related_model_id: params.col.colOptions
                .fk_related_model_id,
            value: value || null,
        });
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = new Lookup_1.LookupHelper().parsePlainCellValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.BelongsToHelper = BelongsToHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQmVsb25nc1RvLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvY29sdW1ucy9MVEFSL0JlbG9uZ3NUby50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxpQ0FBdUQ7QUFDdkQsOEVBRWdDO0FBRWhDLHVDQUF3RDtBQUN4RCxzQ0FBeUM7QUFFekMsTUFBYSxlQUFnQixTQUFRLDBCQUFvQjtJQUF6RDs7UUFDRSxzQkFBaUIsR0FBRyxFQUFFLENBQUM7SUFzQ3pCLENBQUM7SUFwQ0MsY0FBYyxDQUNaLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsSUFBSSxTQUFTLEdBQUcsS0FBSyxDQUFDO1FBRXRCLElBQUksQ0FBQztZQUNILFNBQVMsR0FBRyxPQUFPLEtBQUssS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQztRQUNwRSxDQUFDO1FBQUMsV0FBTSxDQUFDLENBQUEsQ0FBQztRQUVWLElBQ0UsQ0FBQyxJQUFBLG9CQUFlLEVBQUMsU0FBUyxFQUFFLENBQUMscUJBQXFCLEVBQUUsT0FBTyxDQUFDLENBQUM7WUFDN0QsQ0FBQyxJQUFBLGVBQVUsRUFBQyxTQUFTLGFBQVQsU0FBUyx1QkFBVCxTQUFTLENBQUUsS0FBSyxDQUFDO1lBQzdCLENBQUMsU0FBaUMsYUFBakMsU0FBUyx1QkFBVCxTQUFTLENBQTBCLG1CQUFtQjtpQkFDckQsTUFBQyxNQUFNLENBQUMsR0FBRyxDQUFDLFVBQXNDLDBDQUFFLG1CQUFtQixDQUFBLEVBQ3pFLENBQUM7WUFDRCxNQUFNLElBQUksaUNBQXlCLEVBQUUsQ0FBQztRQUN4QyxDQUFDO1FBRUQsT0FBTyxTQUFTLENBQUM7SUFDbkIsQ0FBQztJQUVELFVBQVUsQ0FBQyxLQUFVLEVBQUUsTUFBMkM7UUFDaEUsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO1lBQ3BCLG1CQUFtQixFQUFHLE1BQU0sQ0FBQyxHQUFHLENBQUMsVUFBc0M7aUJBQ3BFLG1CQUFtQjtZQUN0QixLQUFLLEVBQUUsS0FBSyxJQUFJLElBQUk7U0FDckIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELG1CQUFtQixDQUNqQixLQUFVLEVBQ1YsTUFBMkM7O1FBRTNDLE9BQU8sTUFBQSxJQUFJLHFCQUFZLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLG1DQUFJLEVBQUUsQ0FBQztJQUNyRSxDQUFDO0NBQ0Y7QUF2Q0QsMENBdUNDIn0=