"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HasManyHelper = void 0;
const error_1 = require("../../../../lib/error");
const column_interface_1 = __importDefault(require("../../column.interface"));
const Lookup_1 = require("../Lookup");
class HasManyHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(_value, _params) {
        throw new error_1.SilentTypeConversionError();
    }
    parseValue(value, _params) {
        return value !== null && value !== void 0 ? value : '';
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = new Lookup_1.LookupHelper().parsePlainCellValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.HasManyHelper = HasManyHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSGFzTWFueS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvTFRBUi9IYXNNYW55LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHVDQUF3RDtBQUN4RCw4RUFFZ0M7QUFDaEMsc0NBQXlDO0FBRXpDLE1BQWEsYUFBYyxTQUFRLDBCQUFvQjtJQUF2RDs7UUFDRSxzQkFBaUIsR0FBRyxFQUFFLENBQUM7SUFnQnpCLENBQUM7SUFkQyxjQUFjLENBQUMsTUFBVyxFQUFFLE9BQTRDO1FBQ3RFLE1BQU0sSUFBSSxpQ0FBeUIsRUFBRSxDQUFDO0lBQ3hDLENBQUM7SUFFRCxVQUFVLENBQUMsS0FBVSxFQUFFLE9BQTRDO1FBQ2pFLE9BQU8sS0FBSyxhQUFMLEtBQUssY0FBTCxLQUFLLEdBQUksRUFBRSxDQUFDO0lBQ3JCLENBQUM7SUFFRCxtQkFBbUIsQ0FDakIsS0FBVSxFQUNWLE1BQTJDOztRQUUzQyxPQUFPLE1BQUEsSUFBSSxxQkFBWSxFQUFFLENBQUMsbUJBQW1CLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxtQ0FBSSxFQUFFLENBQUM7SUFDckUsQ0FBQztDQUNGO0FBakJELHNDQWlCQyJ9