"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManyToManyHelper = void 0;
const error_1 = require("../../../../lib/error");
const column_interface_1 = __importDefault(require("../../column.interface"));
const is_1 = require("../../../../lib/is");
const utils_1 = require("../../utils");
const Lookup_1 = require("../Lookup");
class ManyToManyHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        var _a;
        if (!(0, utils_1.isMm)(params.col))
            throw new error_1.SilentTypeConversionError();
        let parsedVal = value;
        try {
            parsedVal = typeof value === 'string' ? JSON.parse(value) : value;
        }
        catch (_b) { }
        if (!(0, is_1.ncHasProperties)(parsedVal, [
            'rowId',
            'columnId',
            'fk_related_model_id',
            'value',
        ]) ||
            (parsedVal === null || parsedVal === void 0 ? void 0 : parsedVal.fk_related_model_id) !==
                ((_a = params.col.colOptions) === null || _a === void 0 ? void 0 : _a.fk_related_model_id)) {
            throw new error_1.SilentTypeConversionError();
        }
        return parsedVal;
    }
    parseValue(value, params) {
        return JSON.stringify({
            rowId: params.rowId,
            columnId: params.col.id,
            fk_related_model_id: params.col.colOptions
                .fk_related_model_id,
            value,
        });
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = new Lookup_1.LookupHelper().parsePlainCellValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.ManyToManyHelper = ManyToManyHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTWFueVRvTWFueS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvTFRBUi9NYW55VG9NYW55LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHVDQUF3RDtBQUN4RCw4RUFFZ0M7QUFFaEMsaUNBQTJDO0FBQzNDLHVDQUFtQztBQUNuQyxzQ0FBeUM7QUFFekMsTUFBYSxnQkFBaUIsU0FBUSwwQkFBb0I7SUFBMUQ7O1FBQ0Usc0JBQWlCLEdBQUcsRUFBRSxDQUFDO0lBMkN6QixDQUFDO0lBekNDLGNBQWMsQ0FBQyxLQUFVLEVBQUUsTUFBMkM7O1FBQ3BFLElBQUksQ0FBQyxJQUFBLFlBQUksRUFBQyxNQUFNLENBQUMsR0FBRyxDQUFDO1lBQUUsTUFBTSxJQUFJLGlDQUF5QixFQUFFLENBQUM7UUFFN0QsSUFBSSxTQUFTLEdBQUcsS0FBSyxDQUFDO1FBRXRCLElBQUksQ0FBQztZQUNILFNBQVMsR0FBRyxPQUFPLEtBQUssS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQztRQUNwRSxDQUFDO1FBQUMsV0FBTSxDQUFDLENBQUEsQ0FBQztRQUVWLElBQ0UsQ0FBQyxJQUFBLG9CQUFlLEVBQUMsU0FBUyxFQUFFO1lBQzFCLE9BQU87WUFDUCxVQUFVO1lBQ1YscUJBQXFCO1lBQ3JCLE9BQU87U0FDUixDQUFDO1lBQ0YsQ0FBQyxTQUFpQyxhQUFqQyxTQUFTLHVCQUFULFNBQVMsQ0FBMEIsbUJBQW1CO2lCQUNyRCxNQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsVUFBc0MsMENBQUUsbUJBQW1CLENBQUEsRUFDekUsQ0FBQztZQUNELE1BQU0sSUFBSSxpQ0FBeUIsRUFBRSxDQUFDO1FBQ3hDLENBQUM7UUFFRCxPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDO0lBRUQsVUFBVSxDQUFDLEtBQVUsRUFBRSxNQUEyQztRQUNoRSxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDcEIsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFFBQVEsRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLEVBQUU7WUFDdkIsbUJBQW1CLEVBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyxVQUFzQztpQkFDcEUsbUJBQW1CO1lBQ3RCLEtBQUs7U0FDTixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsbUJBQW1CLENBQ2pCLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsT0FBTyxNQUFBLElBQUkscUJBQVksRUFBRSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsbUNBQUksRUFBRSxDQUFDO0lBQ3JFLENBQUM7Q0FDRjtBQTVDRCw0Q0E0Q0MifQ==