"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinksHelper = void 0;
const error_1 = require("../../../lib/error");
const column_interface_1 = __importDefault(require("../column.interface"));
const utils_1 = require("../utils");
const is_1 = require("../../../lib/is");
class LinksHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        var _a;
        if (params.serializeSearchQuery)
            return null;
        if (!(0, utils_1.isMm)(params.col))
            throw new error_1.SilentTypeConversionError();
        let parsedVal = value;
        try {
            parsedVal = typeof value === 'string' ? JSON.parse(value) : value;
        }
        catch (_b) { }
        if (!(parsedVal &&
            (0, is_1.ncIsObject)(parsedVal) &&
            ['rowId', 'columnId', 'fk_related_model_id', 'value'].every((key) => parsedVal.hasOwnProperty(key))) ||
            (parsedVal === null || parsedVal === void 0 ? void 0 : parsedVal.fk_related_model_id) !==
                ((_a = params.col.colOptions) === null || _a === void 0 ? void 0 : _a.fk_related_model_id)) {
            throw new error_1.SilentTypeConversionError();
        }
        return parsedVal;
    }
    parseValue(value, params) {
        if ((0, utils_1.isMm)(params.col)) {
            return JSON.stringify({
                rowId: params.rowId,
                columnId: params.col.id,
                fk_related_model_id: params.col.colOptions
                    .fk_related_model_id,
                value: !(0, is_1.ncIsNaN)(value) ? +value : 0,
            });
        }
        else if ((0, utils_1.isBt)(params.col) || (0, utils_1.isOo)(params.col)) {
            // fk_related_model_id is used to prevent paste operation in different fk_related_model_id cell
            return JSON.stringify({
                fk_related_model_id: params.col.colOptions
                    .fk_related_model_id,
                value: value || null,
            });
        }
        return value !== null && value !== void 0 ? value : '';
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = (0, utils_1.parseLinksValue)(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.LinksHelper = LinksHelper;
//# sourceMappingURL=data:application/json;base64,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