"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LookupHelper = void 0;
const column_interface_1 = __importDefault(require("../column.interface"));
const is_1 = require("../../../lib/is");
const column_helper_1 = require("../column-helper");
const error_1 = require("../../../lib/error");
const metaHelpers_1 = require("../../../lib/helpers/metaHelpers");
const rfdc_1 = __importDefault(require("rfdc"));
const clone = (0, rfdc_1.default)();
class LookupHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery) {
            return this.parseValue(value, params);
        }
        if (params.isMultipleCellPaste) {
            return undefined;
        }
        else {
            throw new error_1.ComputedTypePasteError();
        }
    }
    parseValue(value, params) {
        var _a, _b;
        if (!value)
            return null;
        const { col, meta, metas } = params;
        const baseId = meta === null || meta === void 0 ? void 0 : meta.base_id;
        const colOptions = col.colOptions;
        const relationColumnOptions = colOptions.fk_relation_column_id
            ? (_b = (_a = meta === null || meta === void 0 ? void 0 : meta.columns) === null || _a === void 0 ? void 0 : _a.find((c) => c.id === colOptions.fk_relation_column_id)) === null || _b === void 0 ? void 0 : _b.colOptions
            : null;
        const relatedBaseId = (relationColumnOptions === null || relationColumnOptions === void 0 ? void 0 : relationColumnOptions.fk_related_base_id) || baseId;
        const relatedTableMeta = (relationColumnOptions === null || relationColumnOptions === void 0 ? void 0 : relationColumnOptions.fk_related_model_id) &&
            (0, metaHelpers_1.getMetaWithCompositeKey)(metas, relatedBaseId, relationColumnOptions.fk_related_model_id);
        let childColumn = relatedTableMeta === null || relatedTableMeta === void 0 ? void 0 : relatedTableMeta.columns.find((c) => c.id === colOptions.fk_lookup_column_id);
        if (!childColumn)
            return value;
        childColumn = clone(childColumn);
        if ((0, is_1.ncIsArray)(value)) {
            return value
                .map((v) => {
                return column_helper_1.ColumnHelper.parseValue(v, Object.assign(Object.assign({}, params), { col: childColumn }));
            })
                .join(', ');
        }
        return column_helper_1.ColumnHelper.parseValue(value, Object.assign(Object.assign({}, params), { col: childColumn }));
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = this.parseValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.LookupHelper = LookupHelper;
//# sourceMappingURL=data:application/json;base64,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