"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NumberHelper = void 0;
const error_1 = require("../../../lib/error");
const __1 = require("..");
const column_interface_1 = __importDefault(require("../column.interface"));
const helperFunctions_1 = require("../../../lib/helperFunctions");
const fill_handler_1 = require("../utils/fill-handler");
const is_1 = require("../../../lib/is");
class NumberHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            isLocaleString: false,
        };
    }
    serializeValue(value, params) {
        value = (0, __1.serializeIntValue)(value);
        if (value === null) {
            if (params.isMultipleCellPaste || params.serializeSearchQuery) {
                return null;
            }
            else {
                throw new error_1.SilentTypeConversionError();
            }
        }
        return (0, helperFunctions_1.toSafeInteger)(value);
    }
    parseValue(value, params) {
        // Return empty string for null/undefined values to prevent "null" text when pasting
        if (value === null || value === undefined) {
            return '';
        }
        return (0, __1.parseIntValue)(value, params.col);
    }
    parsePlainCellValue(value, params) {
        var _a;
        if (params.isAggregation && (0, is_1.ncIsNaN)(value)) {
            value = 0;
        }
        return `${(_a = (0, __1.parseIntValue)(value, params.col)) !== null && _a !== void 0 ? _a : ''}`;
    }
    // using string number fill handler
    populateFillHandle(params) {
        return (0, fill_handler_1.populateFillHandleStringNumber)(params);
    }
}
exports.NumberHelper = NumberHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTnVtYmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvY29sdW1ucy9OdW1iZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsdUNBQXdEO0FBQ3hELDBCQUFzRDtBQUN0RCwyRUFFNkI7QUFDN0IsMkRBQXNEO0FBRXRELHdEQUF1RTtBQUN2RSxpQ0FBbUM7QUFFbkMsTUFBYSxZQUFhLFNBQVEsMEJBQW9CO0lBQXREOztRQUNFLHNCQUFpQixHQUFHO1lBQ2xCLGNBQWMsRUFBRSxLQUFLO1NBQ3RCLENBQUM7SUFpREosQ0FBQztJQS9DQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDO1FBRTNDLEtBQUssR0FBRyxJQUFBLHFCQUFpQixFQUFDLEtBQUssQ0FBQyxDQUFDO1FBRWpDLElBQUksS0FBSyxLQUFLLElBQUksRUFBRSxDQUFDO1lBQ25CLElBQUksTUFBTSxDQUFDLG1CQUFtQixJQUFJLE1BQU0sQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO2dCQUM5RCxPQUFPLElBQUksQ0FBQztZQUNkLENBQUM7aUJBQU0sQ0FBQztnQkFDTixNQUFNLElBQUksaUNBQXlCLEVBQUUsQ0FBQztZQUN4QyxDQUFDO1FBQ0gsQ0FBQztRQUVELE9BQU8sSUFBQSwrQkFBYSxFQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzlCLENBQUM7SUFFRCxVQUFVLENBQ1IsS0FBVSxFQUNWLE1BQTJDO1FBRTNDLG9GQUFvRjtRQUNwRixJQUFJLEtBQUssS0FBSyxJQUFJLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQzFDLE9BQU8sRUFBRSxDQUFDO1FBQ1osQ0FBQztRQUNELE9BQU8sSUFBQSxpQkFBYSxFQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVELG1CQUFtQixDQUNqQixLQUFVLEVBQ1YsTUFBMkM7O1FBRTNDLElBQUksTUFBTSxDQUFDLGFBQWEsSUFBSSxJQUFBLFlBQU8sRUFBQyxLQUFLLENBQUMsRUFBRSxDQUFDO1lBQzNDLEtBQUssR0FBRyxDQUFDLENBQUM7UUFDWixDQUFDO1FBRUQsT0FBTyxHQUFHLE1BQUEsSUFBQSxpQkFBYSxFQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLG1DQUFJLEVBQUUsRUFBRSxDQUFDO0lBQ3JELENBQUM7SUFFRCxtQ0FBbUM7SUFDMUIsa0JBQWtCLENBQUMsTUFJM0I7UUFDQyxPQUFPLElBQUEsNkNBQThCLEVBQUMsTUFBTSxDQUFDLENBQUM7SUFDaEQsQ0FBQztDQUNGO0FBcERELG9DQW9EQyJ9