"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PercentHelper = void 0;
const error_1 = require("../../../lib/error");
const __1 = require("..");
const column_interface_1 = __importDefault(require("../column.interface"));
const fill_handler_1 = require("../utils/fill-handler");
const is_1 = require("../../../lib/is");
class PercentHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            precision: __1.precisionFormats[2],
            is_progress: false,
        };
    }
    serializeValue(value, params) {
        value = (0, __1.serializeDecimalValue)(value, undefined, params);
        if (value === null) {
            if (params.isMultipleCellPaste || params.serializeSearchQuery) {
                return null;
            }
            else {
                throw new error_1.SilentTypeConversionError();
            }
        }
        return value;
    }
    parseValue(value, params) {
        return (0, __1.parsePercentValue)(value, params.col);
    }
    parsePlainCellValue(value, params) {
        var _a;
        if (params.isAggregation && (0, is_1.ncIsNaN)(value)) {
            value = 0;
        }
        return `${(_a = (0, __1.parsePercentValue)(value, params.col)) !== null && _a !== void 0 ? _a : ''}`;
    }
    // using string number fill handler
    populateFillHandle(params) {
        return (0, fill_handler_1.populateFillHandleStringNumber)(params);
    }
}
exports.PercentHelper = PercentHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUGVyY2VudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvUGVyY2VudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx1Q0FBd0Q7QUFDeEQsMEJBQWdGO0FBQ2hGLDJFQUU2QjtBQUU3Qix3REFBdUU7QUFDdkUsaUNBQW1DO0FBRW5DLE1BQWEsYUFBYyxTQUFRLDBCQUFvQjtJQUF2RDs7UUFDRSxzQkFBaUIsR0FBRztZQUNsQixTQUFTLEVBQUUsb0JBQWdCLENBQUMsQ0FBQyxDQUFDO1lBQzlCLFdBQVcsRUFBRSxLQUFLO1NBQ25CLENBQUM7SUE2Q0osQ0FBQztJQTNDQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDO1FBRTNDLEtBQUssR0FBRyxJQUFBLHlCQUFxQixFQUFDLEtBQUssRUFBRSxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFFeEQsSUFBSSxLQUFLLEtBQUssSUFBSSxFQUFFLENBQUM7WUFDbkIsSUFBSSxNQUFNLENBQUMsbUJBQW1CLElBQUksTUFBTSxDQUFDLG9CQUFvQixFQUFFLENBQUM7Z0JBQzlELE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE1BQU0sSUFBSSxpQ0FBeUIsRUFBRSxDQUFDO1lBQ3hDLENBQUM7UUFDSCxDQUFDO1FBRUQsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDO0lBRUQsVUFBVSxDQUNSLEtBQVUsRUFDVixNQUEyQztRQUUzQyxPQUFPLElBQUEscUJBQWlCLEVBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQsbUJBQW1CLENBQ2pCLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsSUFBSSxNQUFNLENBQUMsYUFBYSxJQUFJLElBQUEsWUFBTyxFQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7WUFDM0MsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNaLENBQUM7UUFFRCxPQUFPLEdBQUcsTUFBQSxJQUFBLHFCQUFpQixFQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLG1DQUFJLEVBQUUsRUFBRSxDQUFDO0lBQ3pELENBQUM7SUFFRCxtQ0FBbUM7SUFDMUIsa0JBQWtCLENBQUMsTUFJM0I7UUFDQyxPQUFPLElBQUEsNkNBQThCLEVBQUMsTUFBTSxDQUFDLENBQUM7SUFDaEQsQ0FBQztDQUNGO0FBakRELHNDQWlEQyJ9