"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RatingHelper = void 0;
const error_1 = require("../../../lib/error");
const helperFunctions_1 = require("../../../lib/helperFunctions");
const __1 = require("..");
const column_interface_1 = __importDefault(require("../column.interface"));
const is_1 = require("../../../lib/is");
class RatingHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            iconIdx: 0,
            icon: {
                full: 'mdi-star',
                empty: 'mdi-star-outline',
            },
            color: '#fcb401',
            max: 5,
        };
        // simply copy highlighted rows
        // since rating doesn't need increment
        // override populateFillHandle
    }
    serializeValue(value, params) {
        var _a;
        const res = (0, __1.serializeIntValue)(value !== null && value !== void 0 ? value : 0);
        if (res === null) {
            if (params.isMultipleCellPaste || params.serializeSearchQuery) {
                return null;
            }
            else {
                throw new error_1.SilentTypeConversionError();
            }
        }
        if (res) {
            if (params.serializeSearchQuery) {
                return res;
            }
            return Math.min(res, ((_a = (0, helperFunctions_1.parseProp)(params.col.meta)) === null || _a === void 0 ? void 0 : _a.max) || this.columnDefaultMeta.max);
        }
        return res;
    }
    parseValue(value) {
        return (0, __1.parseIntValue)(value);
    }
    parsePlainCellValue(value, params) {
        var _a;
        if (params.isAggregation && (0, is_1.ncIsNaN)(value)) {
            value = 0;
        }
        return `${(_a = (0, __1.parseIntValue)(value, params.col)) !== null && _a !== void 0 ? _a : ''}`;
    }
}
exports.RatingHelper = RatingHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUmF0aW5nLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvY29sdW1ucy9SYXRpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsdUNBQXdEO0FBQ3hELDJEQUFrRDtBQUNsRCwwQkFBc0Q7QUFDdEQsMkVBRTZCO0FBQzdCLGlDQUFtQztBQUVuQyxNQUFhLFlBQWEsU0FBUSwwQkFBb0I7SUFBdEQ7O1FBQ0Usc0JBQWlCLEdBQUc7WUFDbEIsT0FBTyxFQUFFLENBQUM7WUFDVixJQUFJLEVBQUU7Z0JBQ0osSUFBSSxFQUFFLFVBQVU7Z0JBQ2hCLEtBQUssRUFBRSxrQkFBa0I7YUFDMUI7WUFDRCxLQUFLLEVBQUUsU0FBUztZQUNoQixHQUFHLEVBQUUsQ0FBQztTQUNQLENBQUM7UUE2Q0YsK0JBQStCO1FBQy9CLHNDQUFzQztRQUN0Qyw4QkFBOEI7SUFDaEMsQ0FBQztJQTlDQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDOztRQUUzQyxNQUFNLEdBQUcsR0FBRyxJQUFBLHFCQUFpQixFQUFDLEtBQUssYUFBTCxLQUFLLGNBQUwsS0FBSyxHQUFJLENBQUMsQ0FBQyxDQUFDO1FBRTFDLElBQUksR0FBRyxLQUFLLElBQUksRUFBRSxDQUFDO1lBQ2pCLElBQUksTUFBTSxDQUFDLG1CQUFtQixJQUFJLE1BQU0sQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO2dCQUM5RCxPQUFPLElBQUksQ0FBQztZQUNkLENBQUM7aUJBQU0sQ0FBQztnQkFDTixNQUFNLElBQUksaUNBQXlCLEVBQUUsQ0FBQztZQUN4QyxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksR0FBRyxFQUFFLENBQUM7WUFDUixJQUFJLE1BQU0sQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO2dCQUNoQyxPQUFPLEdBQUcsQ0FBQztZQUNiLENBQUM7WUFFRCxPQUFPLElBQUksQ0FBQyxHQUFHLENBQ2IsR0FBRyxFQUNILENBQUEsTUFBQSxJQUFBLDJCQUFTLEVBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsMENBQUUsR0FBRyxLQUFJLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxHQUFHLENBQzlELENBQUM7UUFDSixDQUFDO1FBRUQsT0FBTyxHQUFHLENBQUM7SUFDYixDQUFDO0lBRUQsVUFBVSxDQUFDLEtBQVU7UUFDbkIsT0FBTyxJQUFBLGlCQUFhLEVBQUMsS0FBSyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVELG1CQUFtQixDQUNqQixLQUFVLEVBQ1YsTUFBMkM7O1FBRTNDLElBQUksTUFBTSxDQUFDLGFBQWEsSUFBSSxJQUFBLFlBQU8sRUFBQyxLQUFLLENBQUMsRUFBRSxDQUFDO1lBQzNDLEtBQUssR0FBRyxDQUFDLENBQUM7UUFDWixDQUFDO1FBRUQsT0FBTyxHQUFHLE1BQUEsSUFBQSxpQkFBYSxFQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLG1DQUFJLEVBQUUsRUFBRSxDQUFDO0lBQ3JELENBQUM7Q0FLRjtBQXpERCxvQ0F5REMifQ==