"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.rollupAllFunctions = exports.RollupHelper = void 0;
const column_interface_1 = __importDefault(require("../column.interface"));
const column_helper_1 = require("../column-helper");
const metaHelpers_1 = require("../../../lib/helpers/metaHelpers");
const helperFunctions_1 = require("../../../lib/helperFunctions");
const UITypes_1 = __importDefault(require("../../../lib/UITypes"));
const error_1 = require("../../../lib/error");
const utils_1 = require("../utils");
const is_1 = require("../../../lib/is");
const rfdc_1 = __importDefault(require("rfdc"));
const clone = (0, rfdc_1.default)();
class RollupHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            precision: utils_1.precisionFormats[0],
            isLocaleString: false,
        };
    }
    serializeValue(_value, params) {
        if (params.isMultipleCellPaste || params.serializeSearchQuery) {
            return undefined;
        }
        else {
            throw new error_1.ComputedTypePasteError();
        }
    }
    parseValue(value, params) {
        var _a, _b, _c;
        if (!(0, is_1.isValidValue)(value))
            return null;
        const { col, meta, metas } = params;
        const baseId = meta === null || meta === void 0 ? void 0 : meta.base_id;
        const colOptions = col.colOptions;
        const relationColumnOptions = colOptions.fk_relation_column_id
            ? (_b = (_a = meta === null || meta === void 0 ? void 0 : meta.columns) === null || _a === void 0 ? void 0 : _a.find((c) => c.id === colOptions.fk_relation_column_id)) === null || _b === void 0 ? void 0 : _b.colOptions
            : null;
        const relatedTableMeta = (relationColumnOptions === null || relationColumnOptions === void 0 ? void 0 : relationColumnOptions.fk_related_model_id) &&
            (0, metaHelpers_1.getMetaWithCompositeKey)(metas, baseId, relationColumnOptions.fk_related_model_id);
        let childColumn = relatedTableMeta === null || relatedTableMeta === void 0 ? void 0 : relatedTableMeta.columns.find((c) => c.id === colOptions.fk_rollup_column_id);
        if (!childColumn)
            return value;
        childColumn = clone(childColumn);
        const renderAsTextFun = (0, helperFunctions_1.getRenderAsTextFunForUiType)(((_c = childColumn.uidt) !== null && _c !== void 0 ? _c : UITypes_1.default.SingleLineText));
        childColumn.meta = Object.assign(Object.assign({}, (0, helperFunctions_1.parseProp)(childColumn === null || childColumn === void 0 ? void 0 : childColumn.meta)), (0, helperFunctions_1.parseProp)(col === null || col === void 0 ? void 0 : col.meta));
        if (renderAsTextFun.includes(colOptions.rollup_function)) {
            childColumn.uidt = UITypes_1.default.Decimal;
        }
        return column_helper_1.ColumnHelper.parseValue(value, Object.assign(Object.assign({}, params), { col: childColumn }));
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = this.parseValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.RollupHelper = RollupHelper;
exports.rollupAllFunctions = [
    { text: 'datatype.Count', value: 'count' },
    { text: 'general.min', value: 'min' },
    { text: 'general.max', value: 'max' },
    { text: 'general.avg', value: 'avg' },
    { text: 'general.sum', value: 'sum' },
    { text: 'general.countDistinct', value: 'countDistinct' },
    { text: 'general.sumDistinct', value: 'sumDistinct' },
    { text: 'general.avgDistinct', value: 'avgDistinct' },
];
//# sourceMappingURL=data:application/json;base64,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