"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingleLineTextHelper = void 0;
const column_interface_1 = __importDefault(require("../column.interface"));
const utils_1 = require("../utils");
const fill_handler_1 = require("../utils/fill-handler");
class SingleLineTextHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, _params) {
        return (0, utils_1.serializeStringValue)(value);
    }
    parseValue(value, _params) {
        if (value === null || value === undefined) {
            return '';
        }
        return value.toString();
    }
    parsePlainCellValue(value, _params) {
        var _a;
        return (_a = value === null || value === void 0 ? void 0 : value.toString()) !== null && _a !== void 0 ? _a : '';
    }
    // using string number fill handler
    populateFillHandle(params) {
        return (0, fill_handler_1.populateFillHandleStringNumber)(params);
    }
}
exports.SingleLineTextHelper = SingleLineTextHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU2luZ2xlTGluZVRleHQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9zcmMvbGliL2NvbHVtbkhlbHBlci9jb2x1bW5zL1NpbmdsZUxpbmVUZXh0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUNBLDJFQUU2QjtBQUM3QixvQ0FBZ0Q7QUFDaEQsd0RBQXVFO0FBRXZFLE1BQWEsb0JBQXFCLFNBQVEsMEJBQW9CO0lBQTlEOztRQUNFLHNCQUFpQixHQUFHLEVBQUUsQ0FBQztJQStCekIsQ0FBQztJQTdCQyxjQUFjLENBQ1osS0FBVSxFQUNWLE9BQTRDO1FBRTVDLE9BQU8sSUFBQSw0QkFBb0IsRUFBQyxLQUFLLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQsVUFBVSxDQUFDLEtBQVUsRUFBRSxPQUE0QztRQUNqRSxJQUFJLEtBQUssS0FBSyxJQUFJLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQzFDLE9BQU8sRUFBRSxDQUFDO1FBQ1osQ0FBQztRQUNELE9BQU8sS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQzFCLENBQUM7SUFFRCxtQkFBbUIsQ0FDakIsS0FBVSxFQUNWLE9BQTRDOztRQUU1QyxPQUFPLE1BQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFFBQVEsRUFBRSxtQ0FBSSxFQUFFLENBQUM7SUFDakMsQ0FBQztJQUVELG1DQUFtQztJQUMxQixrQkFBa0IsQ0FBQyxNQUkzQjtRQUNDLE9BQU8sSUFBQSw2Q0FBOEIsRUFBQyxNQUFNLENBQUMsQ0FBQztJQUNoRCxDQUFDO0NBQ0Y7QUFoQ0Qsb0RBZ0NDIn0=