"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingleSelectHelper = void 0;
const is_1 = require("../../../lib/is");
const column_interface_1 = __importDefault(require("../column.interface"));
const utils_1 = require("../utils");
class SingleSelectHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery) {
            return (0, utils_1.serializeStringValue)(value);
        }
        return (0, utils_1.serializeSelectValue)(value, params.col);
    }
    parseValue(value) {
        var _a, _b;
        if (!value)
            return null;
        if ((0, is_1.ncIsArray)(value) && value.length) {
            return (_a = value[0]) === null || _a === void 0 ? void 0 : _a.toString().trim();
        }
        return (_b = value === null || value === void 0 ? void 0 : value.toString().trim()) !== null && _b !== void 0 ? _b : null;
    }
    parsePlainCellValue(value) {
        var _a;
        return (_a = this.parseValue(value)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.SingleSelectHelper = SingleSelectHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU2luZ2xlU2VsZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvY29sdW1ucy9TaW5nbGVTZWxlY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsaUNBQXFDO0FBQ3JDLDJFQUU2QjtBQUM3QixvQ0FBc0U7QUFFdEUsTUFBYSxrQkFBbUIsU0FBUSwwQkFBb0I7SUFBNUQ7O1FBQ0Usc0JBQWlCLEdBQUcsRUFBRSxDQUFDO0lBMEJ6QixDQUFDO0lBeEJDLGNBQWMsQ0FDWixLQUFVLEVBQ1YsTUFBMkM7UUFFM0MsSUFBSSxNQUFNLENBQUMsb0JBQW9CLEVBQUUsQ0FBQztZQUNoQyxPQUFPLElBQUEsNEJBQW9CLEVBQUMsS0FBSyxDQUFDLENBQUM7UUFDckMsQ0FBQztRQUVELE9BQU8sSUFBQSw0QkFBb0IsRUFBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRCxVQUFVLENBQUMsS0FBVTs7UUFDbkIsSUFBSSxDQUFDLEtBQUs7WUFBRSxPQUFPLElBQUksQ0FBQztRQUV4QixJQUFJLElBQUEsY0FBUyxFQUFDLEtBQUssQ0FBQyxJQUFJLEtBQUssQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUNyQyxPQUFPLE1BQUEsS0FBSyxDQUFDLENBQUMsQ0FBQywwQ0FBRSxRQUFRLEdBQUcsSUFBSSxFQUFFLENBQUM7UUFDckMsQ0FBQztRQUVELE9BQU8sTUFBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsUUFBUSxHQUFHLElBQUksRUFBRSxtQ0FBSSxJQUFJLENBQUM7SUFDMUMsQ0FBQztJQUVELG1CQUFtQixDQUFDLEtBQVU7O1FBQzVCLE9BQU8sTUFBQSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxtQ0FBSSxFQUFFLENBQUM7SUFDdEMsQ0FBQztDQUNGO0FBM0JELGdEQTJCQyJ9