"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeHelper = void 0;
const dayjs_1 = __importDefault(require("dayjs"));
const dateTimeHelper_1 = require("../../../lib/dateTimeHelper");
const error_1 = require("../../../lib/error");
const column_interface_1 = __importDefault(require("../column.interface"));
const utils_1 = require("../utils");
class TimeHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            is12hrFormat: false,
        };
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery) {
            return this.parseValue(value, params);
        }
        value = (0, utils_1.serializeTimeValue)(value, params);
        if (value === null) {
            if (params.isMultipleCellPaste || params.serializeSearchQuery) {
                return null;
            }
            else {
                throw new error_1.SilentTypeConversionError();
            }
        }
        return value;
    }
    parseValue(value, params) {
        return (0, utils_1.parseTimeValue)(value, params);
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = (0, utils_1.parseTimeValue)(value, params)) !== null && _a !== void 0 ? _a : '';
    }
    equalityComparison(a, b, param) {
        const aDayjs = typeof a === 'string' ? (0, dayjs_1.default)((0, utils_1.serializeTimeValue)(a, param)) : (0, dayjs_1.default)(a);
        const bDayjs = typeof b === 'string' ? (0, dayjs_1.default)((0, utils_1.serializeTimeValue)(b, param)) : (0, dayjs_1.default)(b);
        return (aDayjs.format((0, dateTimeHelper_1.constructTimeFormat)(param.col)) ===
            bDayjs.format((0, dateTimeHelper_1.constructTimeFormat)(param.col)));
    }
}
exports.TimeHelper = TimeHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiVGltZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvVGltZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxrREFBMEI7QUFDMUIseURBQTJEO0FBQzNELHVDQUF3RDtBQUN4RCwyRUFFNkI7QUFDN0Isb0NBQThEO0FBRTlELE1BQWEsVUFBVyxTQUFRLDBCQUFvQjtJQUFwRDs7UUFDUyxzQkFBaUIsR0FBRztZQUN6QixZQUFZLEVBQUUsS0FBSztTQUNwQixDQUFDO0lBb0RKLENBQUM7SUFsREMsY0FBYyxDQUNaLEtBQVUsRUFDVixNQUEyQztRQUUzQyxJQUFJLE1BQU0sQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO1lBQ2hDLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFDeEMsQ0FBQztRQUVELEtBQUssR0FBRyxJQUFBLDBCQUFrQixFQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsQ0FBQztRQUUxQyxJQUFJLEtBQUssS0FBSyxJQUFJLEVBQUUsQ0FBQztZQUNuQixJQUFJLE1BQU0sQ0FBQyxtQkFBbUIsSUFBSSxNQUFNLENBQUMsb0JBQW9CLEVBQUUsQ0FBQztnQkFDOUQsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sTUFBTSxJQUFJLGlDQUF5QixFQUFFLENBQUM7WUFDeEMsQ0FBQztRQUNILENBQUM7UUFFRCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCxVQUFVLENBQ1IsS0FBVSxFQUNWLE1BQTJDO1FBRTNDLE9BQU8sSUFBQSxzQkFBYyxFQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQsbUJBQW1CLENBQ2pCLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsT0FBTyxNQUFBLElBQUEsc0JBQWMsRUFBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLG1DQUFJLEVBQUUsQ0FBQztJQUM3QyxDQUFDO0lBRVEsa0JBQWtCLENBQ3pCLENBQU0sRUFDTixDQUFNLEVBQ04sS0FBMEM7UUFFMUMsTUFBTSxNQUFNLEdBQ1YsT0FBTyxDQUFDLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxJQUFBLGVBQUssRUFBQyxJQUFBLDBCQUFrQixFQUFDLENBQUMsRUFBRSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFBLGVBQUssRUFBQyxDQUFDLENBQUMsQ0FBQztRQUN6RSxNQUFNLE1BQU0sR0FDVixPQUFPLENBQUMsS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLElBQUEsZUFBSyxFQUFDLElBQUEsMEJBQWtCLEVBQUMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUEsZUFBSyxFQUFDLENBQUMsQ0FBQyxDQUFDO1FBRXpFLE9BQU8sQ0FDTCxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUEsb0NBQW1CLEVBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQzdDLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBQSxvQ0FBbUIsRUFBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FDOUMsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQXZERCxnQ0F1REMifQ==