"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserHelper = void 0;
const error_1 = require("../../../lib/error");
const helperFunctions_1 = require("../../../lib/helperFunctions");
const is_1 = require("../../../lib/is");
const column_interface_1 = __importDefault(require("../column.interface"));
const utils_1 = require("../utils");
class UserHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            is_multi: false,
            notify: false,
        };
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery) {
            return (0, utils_1.serializeStringValue)(value);
        }
        try {
            value = typeof value === 'string' ? JSON.parse(value) : value;
        }
        catch (_a) { }
        if (value === null) {
            if (params.isMultipleCellPaste) {
                return null;
            }
            else {
                throw new error_1.SilentTypeConversionError();
            }
        }
        const is_multi = (0, helperFunctions_1.parseProp)(params.col.meta).is_multi;
        if ((0, is_1.ncIsArray)(value) || (0, is_1.ncIsObject)(value)) {
            if ((0, is_1.ncIsObject)(value)) {
                value = [value];
            }
            value = value.reduce((acc, user) => {
                if (user.email) {
                    acc.push(user);
                }
                return acc;
            }, []);
            if (!value.length)
                return null;
            if (!is_multi) {
                return value[0];
            }
            return value;
        }
        if (!(0, is_1.ncIsString)(value))
            return null;
        if (is_multi) {
            return value
                .split(',')
                .map((val) => (0, utils_1.serializeEmail)(val))
                .filter(Boolean)
                .join(', ');
        }
        return (0, utils_1.serializeEmail)(value);
    }
    parseValue(value) {
        return (0, utils_1.parseUserValue)(value, true);
    }
    parsePlainCellValue(value) {
        var _a;
        return (_a = (0, utils_1.parseUserValue)(value)) !== null && _a !== void 0 ? _a : '';
    }
}
exports.UserHelper = UserHelper;
//# sourceMappingURL=data:application/json;base64,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