"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.YearHelper = void 0;
const error_1 = require("../../../lib/error");
const column_interface_1 = __importDefault(require("../column.interface"));
const utils_1 = require("../utils");
const fill_handler_1 = require("../utils/fill-handler");
class YearHelper extends column_interface_1.default {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery) {
            return this.parseValue(value);
        }
        value = (0, utils_1.serializeYearValue)(value);
        if (value === null) {
            if (params.isMultipleCellPaste) {
                return null;
            }
            else {
                throw new error_1.SilentTypeConversionError();
            }
        }
        return value;
    }
    parseValue(value) {
        return (0, utils_1.parseYearValue)(value);
    }
    parsePlainCellValue(value) {
        var _a;
        return `${(_a = (0, utils_1.parseYearValue)(value)) !== null && _a !== void 0 ? _a : ''}`;
    }
    // using string number fill handler
    populateFillHandle(params) {
        return (0, fill_handler_1.populateFillHandleStringNumber)(params);
    }
}
exports.YearHelper = YearHelper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiWWVhci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvWWVhci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx1Q0FBd0Q7QUFDeEQsMkVBRTZCO0FBQzdCLG9DQUE4RDtBQUU5RCx3REFBdUU7QUFFdkUsTUFBYSxVQUFXLFNBQVEsMEJBQW9CO0lBQXBEOztRQUNFLHNCQUFpQixHQUFHLEVBQUUsQ0FBQztJQXVDekIsQ0FBQztJQXJDQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDO1FBRTNDLElBQUksTUFBTSxDQUFDLG9CQUFvQixFQUFFLENBQUM7WUFDaEMsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2hDLENBQUM7UUFFRCxLQUFLLEdBQUcsSUFBQSwwQkFBa0IsRUFBQyxLQUFLLENBQUMsQ0FBQztRQUVsQyxJQUFJLEtBQUssS0FBSyxJQUFJLEVBQUUsQ0FBQztZQUNuQixJQUFJLE1BQU0sQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO2dCQUMvQixPQUFPLElBQUksQ0FBQztZQUNkLENBQUM7aUJBQU0sQ0FBQztnQkFDTixNQUFNLElBQUksaUNBQXlCLEVBQUUsQ0FBQztZQUN4QyxDQUFDO1FBQ0gsQ0FBQztRQUVELE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUVELFVBQVUsQ0FBQyxLQUFVO1FBQ25CLE9BQU8sSUFBQSxzQkFBYyxFQUFDLEtBQUssQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRCxtQkFBbUIsQ0FBQyxLQUFVOztRQUM1QixPQUFPLEdBQUcsTUFBQSxJQUFBLHNCQUFjLEVBQUMsS0FBSyxDQUFDLG1DQUFJLEVBQUUsRUFBRSxDQUFDO0lBQzFDLENBQUM7SUFFRCxtQ0FBbUM7SUFDMUIsa0JBQWtCLENBQUMsTUFJM0I7UUFDQyxPQUFPLElBQUEsNkNBQThCLEVBQUMsTUFBTSxDQUFDLENBQUM7SUFDaEQsQ0FBQztDQUNGO0FBeENELGdDQXdDQyJ9