"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNumericFieldType = exports.renderValue = exports.isPrimaryKey = exports.isPrimary = exports.isManualSaved = exports.isAutoSaved = exports.isAI = exports.isScriptButton = exports.isAiButton = exports.isButton = exports.isMultiUser = exports.isUser = exports.isGeometry = exports.isSpecificDBType = exports.isPercent = exports.isGeoData = exports.isDuration = exports.isDecimal = exports.isPhoneNumber = exports.isCurrency = exports.isRating = exports.isAttachment = exports.isEmail = exports.isURL = exports.isMultiSelect = exports.isSet = exports.isSingleSelect = exports.isEnum = exports.isJSON = exports.isReadonlyUser = exports.isReadonlyDateTime = exports.isDateTime = exports.isTime = exports.isYear = exports.isDate = exports.isFloat = exports.isInt = exports.isRichText = exports.isTextArea = exports.isString = exports.isBoolean = exports.dataTypeLow = void 0;
const dayjs_1 = __importDefault(require("dayjs"));
const Api_1 = require("../../../lib/Api");
const globals_1 = require("../../../lib/globals");
const helperFunctions_1 = require("../../../lib/helperFunctions");
const UITypes_1 = __importStar(require("../../../lib/UITypes"));
const dataTypeLow = (column) => { var _a; return (_a = column.dt) === null || _a === void 0 ? void 0 : _a.toLowerCase(); };
exports.dataTypeLow = dataTypeLow;
const isBoolean = (column, abstractType) => column.uidt === UITypes_1.default.Checkbox || abstractType === 'boolean';
exports.isBoolean = isBoolean;
const isString = (column, abstractType) => column.uidt === UITypes_1.default.SingleLineText || abstractType === 'string';
exports.isString = isString;
const isTextArea = (column) => column.uidt === UITypes_1.default.LongText;
exports.isTextArea = isTextArea;
const isRichText = (column) => column.uidt === UITypes_1.default.LongText && !!(0, helperFunctions_1.parseProp)(column === null || column === void 0 ? void 0 : column.meta).richMode;
exports.isRichText = isRichText;
const isInt = (_column, abstractType) => abstractType === 'integer';
exports.isInt = isInt;
const isFloat = (column, abstractType) => abstractType === 'float' || column.uidt === UITypes_1.default.Number;
exports.isFloat = isFloat;
const isDate = (column, abstractType) => abstractType === 'date' || column.uidt === UITypes_1.default.Date;
exports.isDate = isDate;
const isYear = (column, abstractType) => abstractType === 'year' || column.uidt === UITypes_1.default.Year;
exports.isYear = isYear;
const isTime = (column, abstractType) => abstractType === 'time' || column.uidt === UITypes_1.default.Time;
exports.isTime = isTime;
const isDateTime = (column, abstractType) => abstractType === 'datetime' || column.uidt === UITypes_1.default.DateTime;
exports.isDateTime = isDateTime;
const isReadonlyDateTime = (column, _abstractType) => column.uidt === UITypes_1.default.CreatedTime ||
    column.uidt === UITypes_1.default.LastModifiedTime;
exports.isReadonlyDateTime = isReadonlyDateTime;
const isReadonlyUser = (column, _abstractType) => column.uidt === UITypes_1.default.CreatedBy || column.uidt === UITypes_1.default.LastModifiedBy;
exports.isReadonlyUser = isReadonlyUser;
const isJSON = (column) => column.uidt === UITypes_1.default.JSON;
exports.isJSON = isJSON;
const isEnum = (column) => column.uidt === UITypes_1.default.SingleSelect;
exports.isEnum = isEnum;
const isSingleSelect = (column) => column.uidt === UITypes_1.default.SingleSelect;
exports.isSingleSelect = isSingleSelect;
const isSet = (column) => column.uidt === UITypes_1.default.MultiSelect;
exports.isSet = isSet;
const isMultiSelect = (column) => column.uidt === UITypes_1.default.MultiSelect;
exports.isMultiSelect = isMultiSelect;
const isURL = (column) => column.uidt === UITypes_1.default.URL;
exports.isURL = isURL;
const isEmail = (column) => column.uidt === UITypes_1.default.Email;
exports.isEmail = isEmail;
const isAttachment = (column) => column.uidt === UITypes_1.default.Attachment;
exports.isAttachment = isAttachment;
const isRating = (column) => column.uidt === UITypes_1.default.Rating;
exports.isRating = isRating;
const isCurrency = (column) => column.uidt === UITypes_1.default.Currency;
exports.isCurrency = isCurrency;
const isPhoneNumber = (column) => column.uidt === UITypes_1.default.PhoneNumber;
exports.isPhoneNumber = isPhoneNumber;
const isDecimal = (column) => column.uidt === UITypes_1.default.Decimal;
exports.isDecimal = isDecimal;
const isDuration = (column) => column.uidt === UITypes_1.default.Duration;
exports.isDuration = isDuration;
const isGeoData = (column) => column.uidt === UITypes_1.default.GeoData;
exports.isGeoData = isGeoData;
const isPercent = (column) => column.uidt === UITypes_1.default.Percent;
exports.isPercent = isPercent;
const isSpecificDBType = (column) => column.uidt === UITypes_1.default.SpecificDBType;
exports.isSpecificDBType = isSpecificDBType;
const isGeometry = (column) => column.uidt === UITypes_1.default.Geometry;
exports.isGeometry = isGeometry;
const isUser = (column) => column.uidt === UITypes_1.default.User;
exports.isUser = isUser;
const isMultiUser = (column) => (0, exports.isUser)(column) && !!(0, helperFunctions_1.parseProp)(column.meta).is_multi;
exports.isMultiUser = isMultiUser;
const isButton = (column) => column.uidt === UITypes_1.default.Button;
exports.isButton = isButton;
const isAiButton = (column) => {
    var _a;
    return column.uidt === UITypes_1.default.Button &&
        ((_a = column === null || column === void 0 ? void 0 : column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === Api_1.ButtonActionsType.Ai;
};
exports.isAiButton = isAiButton;
const isScriptButton = (column) => {
    var _a;
    return column.uidt === UITypes_1.default.Button &&
        ((_a = column === null || column === void 0 ? void 0 : column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === Api_1.ButtonActionsType.Script;
};
exports.isScriptButton = isScriptButton;
const isAI = (column) => {
    var _a;
    return column.uidt === UITypes_1.default.LongText &&
        ((_a = (0, helperFunctions_1.parseProp)(column === null || column === void 0 ? void 0 : column.meta)) === null || _a === void 0 ? void 0 : _a[globals_1.LongTextAiMetaProp]) === true;
};
exports.isAI = isAI;
const isAutoSaved = (column) => [
    UITypes_1.default.SingleLineText,
    UITypes_1.default.LongText,
    UITypes_1.default.PhoneNumber,
    UITypes_1.default.Email,
    UITypes_1.default.URL,
    UITypes_1.default.Number,
    UITypes_1.default.Decimal,
    UITypes_1.default.Percent,
    UITypes_1.default.Count,
    UITypes_1.default.AutoNumber,
    UITypes_1.default.SpecificDBType,
    UITypes_1.default.Geometry,
    UITypes_1.default.GeoData,
    UITypes_1.default.Duration,
].includes(column.uidt) && !(0, UITypes_1.isAIPromptCol)(column);
exports.isAutoSaved = isAutoSaved;
const isManualSaved = (column) => [UITypes_1.default.Currency].includes(column.uidt) || (0, UITypes_1.isAIPromptCol)(column);
exports.isManualSaved = isManualSaved;
const isPrimary = (column) => !!column.pv;
exports.isPrimary = isPrimary;
const isPrimaryKey = (column) => !!column.pk;
exports.isPrimaryKey = isPrimaryKey;
// used for LTAR and Formula
const renderValue = (result) => {
    if (!result || typeof result !== 'string') {
        return result;
    }
    // convert ISO string (e.g. in MSSQL) to YYYY-MM-DD hh:mm:ssZ
    // e.g. 2023-05-18T05:30:00.000Z -> 2023-05-18 11:00:00+05:30
    result = result.replace(/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/g, (d) => {
        return (0, dayjs_1.default)(d).isValid() ? (0, dayjs_1.default)(d).format('YYYY-MM-DD HH:mm:ssZ') : d;
    });
    // convert all date time values to local time
    // the datetime is either YYYY-MM-DD hh:mm:ss (xcdb)
    // or YYYY-MM-DD hh:mm:ss+/-xx:yy (ext)
    return result.replace(/\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}(?:[+-]\d{2}:\d{2})?/g, (d) => {
        // TODO(timezone): retrieve the format from the corresponding column meta
        // assume HH:mm at this moment
        return (0, dayjs_1.default)(d).isValid() ? (0, dayjs_1.default)(d).format('YYYY-MM-DD HH:mm') : d;
    });
};
exports.renderValue = renderValue;
const isNumericFieldType = (column, abstractType) => {
    return ((0, exports.isInt)(column, abstractType) ||
        (0, exports.isFloat)(column, abstractType) ||
        (0, exports.isDecimal)(column) ||
        (0, exports.isCurrency)(column) ||
        (0, exports.isPercent)(column) ||
        (0, exports.isDuration)(column));
};
exports.isNumericFieldType = isNumericFieldType;
//# sourceMappingURL=data:application/json;base64,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