"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClipboardConfigForColumn = void 0;
const commonUtils_1 = require("../../../lib/commonUtils");
const helperFunctions_1 = require("../../../lib/helperFunctions");
const getClipboardConfigForColumn = ({ col, extractMetaProps = [], }) => {
    const columnMeta = extractMetaProps.length
        ? (0, commonUtils_1.extractProps)((0, helperFunctions_1.parseProp)(col.meta), extractMetaProps)
        : (0, helperFunctions_1.parseProp)(col.meta);
    return {
        column: col
            ? {
                id: col.id,
                title: col.title,
                column_name: col.column_name,
                meta: columnMeta,
                colOptions: col.colOptions,
                uidt: col.uidt,
                cdf: col.cdf,
                description: col.description,
                source_id: col.source_id,
                fk_model_id: col.fk_model_id,
                system: col.system,
            }
            : {},
    };
};
exports.getClipboardConfigForColumn = getClipboardConfigForColumn;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xpcGJvYXJkLWNvbmZpZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL3V0aWxzL2NsaXBib2FyZC1jb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsbURBQWlEO0FBQ2pELDJEQUFrRDtBQUUzQyxNQUFNLDJCQUEyQixHQUFHLENBQUMsRUFDMUMsR0FBRyxFQUVILGdCQUFnQixHQUFHLEVBQUUsR0FJdEIsRUFFQyxFQUFFO0lBQ0YsTUFBTSxVQUFVLEdBQUcsZ0JBQWdCLENBQUMsTUFBTTtRQUN4QyxDQUFDLENBQUMsSUFBQSwwQkFBWSxFQUFDLElBQUEsMkJBQVMsRUFBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsZ0JBQWdCLENBQUM7UUFDckQsQ0FBQyxDQUFDLElBQUEsMkJBQVMsRUFBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUM7SUFFeEIsT0FBTztRQUNMLE1BQU0sRUFBRSxHQUFHO1lBQ1QsQ0FBQyxDQUFDO2dCQUNFLEVBQUUsRUFBRSxHQUFHLENBQUMsRUFBRTtnQkFDVixLQUFLLEVBQUUsR0FBRyxDQUFDLEtBQUs7Z0JBQ2hCLFdBQVcsRUFBRSxHQUFHLENBQUMsV0FBVztnQkFDNUIsSUFBSSxFQUFFLFVBQVU7Z0JBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVTtnQkFDMUIsSUFBSSxFQUFFLEdBQUcsQ0FBQyxJQUFJO2dCQUNkLEdBQUcsRUFBRSxHQUFHLENBQUMsR0FBRztnQkFDWixXQUFXLEVBQUUsR0FBRyxDQUFDLFdBQVc7Z0JBQzVCLFNBQVMsRUFBRSxHQUFHLENBQUMsU0FBUztnQkFDeEIsV0FBVyxFQUFFLEdBQUcsQ0FBQyxXQUFXO2dCQUM1QixNQUFNLEVBQUUsR0FBRyxDQUFDLE1BQU07YUFDbkI7WUFDSCxDQUFDLENBQUMsRUFBRTtLQUNQLENBQUM7QUFDSixDQUFDLENBQUM7QUEvQlcsUUFBQSwyQkFBMkIsK0JBK0J0QyJ9