"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.serializeDateOrDateTimeValue = exports.parseDateTimeValue = exports.parseDateValue = exports.DATE_DIFF_TO_SCALE_LABEL_MAP = exports.DATE_SCALE_LABEL_TO_DIFF_MAP = void 0;
const dayjs_1 = __importDefault(require("dayjs"));
const dateTimeHelper_1 = require("../../../lib/dateTimeHelper");
const helperFunctions_1 = require("../../../lib/helperFunctions");
const UITypes_1 = __importDefault(require("../../../lib/UITypes"));
exports.DATE_SCALE_LABEL_TO_DIFF_MAP = {
    Y: 'year',
    M: 'month',
    D: 'day',
    H: 'hour',
    m: 'minute',
    s: 'second',
};
exports.DATE_DIFF_TO_SCALE_LABEL_MAP = {
    year: 'Y',
    month: 'M',
    day: 'D',
    hour: 'H',
    minute: 'm',
    second: 's',
};
const parseDateValue = (value, col, isSystemCol) => {
    var _a, _b;
    value = value === null || value === void 0 ? void 0 : value.toString().trim();
    const dateFormat = !isSystemCol
        ? (_b = (_a = (0, helperFunctions_1.parseProp)(col.meta)) === null || _a === void 0 ? void 0 : _a.date_format) !== null && _b !== void 0 ? _b : 'YYYY-MM-DD'
        : 'YYYY-MM-DD HH:mm:ss';
    if (!value || !(0, dayjs_1.default)(value).isValid()) {
        return null;
    }
    else {
        value = value === null || value === void 0 ? void 0 : value.toString().trim();
        return (0, dayjs_1.default)(/^\d+$/.test(value) ? +value : value).format(dateFormat);
    }
};
exports.parseDateValue = parseDateValue;
const parseDateTimeValue = (value, params) => {
    var _a;
    // remove `"`
    // e.g. "2023-05-12T08:03:53.000Z" -> 2023-05-12T08:03:53.000Z
    value = value === null || value === void 0 ? void 0 : value.replace(/["']/g, '');
    if (!value) {
        return;
    }
    const isMySQL = (_a = params.isMysql) === null || _a === void 0 ? void 0 : _a.call(params, params.col.source_id);
    let d = (0, dayjs_1.default)(value);
    if (!d.isValid()) {
        // insert a datetime value, copy the value without refreshing
        // e.g. value = 2023-05-12T03:49:25.000Z
        // feed custom parse format
        d = (0, dayjs_1.default)(value, isMySQL ? 'YYYY-MM-DD HH:mm:ss' : 'YYYY-MM-DD HH:mm:ssZ');
    }
    // users can change the datetime format in UI
    // `value` would be always in YYYY-MM-DD HH:mm:ss(Z / +xx:yy) format
    // therefore, here we reformat to the correct datetime format based on the meta
    value = d.format((0, dateTimeHelper_1.constructDateTimeFormat)(params.col));
    if (!d.isValid()) {
        // return empty string for invalid datetime
        return null;
    }
    return value;
};
exports.parseDateTimeValue = parseDateTimeValue;
const serializeDateOrDateTimeValue = (value, params) => {
    var _a, _b, _c, _d;
    if (!value)
        return null;
    value = value === null || value === void 0 ? void 0 : value.toString().trim();
    let isDateOnly = false;
    if (typeof value === 'string' && value.length < 11) {
        isDateOnly = true;
    }
    let parsedDateOrDateTime;
    // If clipboardItem column is date or datetime, then use the dbCellValue from clipboardItem
    if ([UITypes_1.default.Date, UITypes_1.default.DateTime].includes((_b = (_a = params.clipboardItem) === null || _a === void 0 ? void 0 : _a.column) === null || _b === void 0 ? void 0 : _b.uidt) &&
        params.clipboardItem.dbCellValue) {
        const formatting = ((_c = params.clipboardItem) === null || _c === void 0 ? void 0 : _c.column.uidt) === UITypes_1.default.Date
            ? 'YYYY-MM-DD'
            : 'YYYY-MM-DD HH:mm:ssZ';
        parsedDateOrDateTime = (0, dayjs_1.default)(params.clipboardItem.dbCellValue, formatting);
    }
    // If clipboardItem not present or invalid, then use default method to parse the value
    if (!parsedDateOrDateTime || !parsedDateOrDateTime.isValid()) {
        const formatting = isDateOnly
            ? (_d = (0, helperFunctions_1.parseProp)(params.col.meta).date_format) !== null && _d !== void 0 ? _d : 'YYYY-MM-DD'
            : (0, dateTimeHelper_1.constructDateTimeFormat)(params.col);
        parsedDateOrDateTime = (0, dayjs_1.default)(value, formatting);
    }
    if (!parsedDateOrDateTime.isValid()) {
        parsedDateOrDateTime = (0, dayjs_1.default)(value, (0, dateTimeHelper_1.getDateTimeFormat)(value));
        if (!parsedDateOrDateTime.isValid()) {
            parsedDateOrDateTime = (0, dayjs_1.default)(value, (0, dateTimeHelper_1.getDateFormat)(value));
        }
    }
    if (!parsedDateOrDateTime.isValid()) {
        return null;
    }
    return params.col.uidt === UITypes_1.default.Date
        ? parsedDateOrDateTime.format('YYYY-MM-DD')
        : parsedDateOrDateTime.utc().format('YYYY-MM-DD HH:mm:ssZ');
};
exports.serializeDateOrDateTimeValue = serializeDateOrDateTimeValue;
//# sourceMappingURL=data:application/json;base64,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