"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.populateFillHandleStringNumber = populateFillHandleStringNumber;
exports.populateFillHandleStrictCopy = populateFillHandleStrictCopy;
const is_1 = require("../../../lib/is");
const decimal_1 = require("./decimal");
const fillHandlerSuffixRegex = /(.*)(\d+)$/;
const getModifierForNumber = ({ group, nullPrefix, }) => {
    var _a, _b;
    let sumOfModifier = 0;
    let lastData = Number(group[nullPrefix].data[1]);
    sumOfModifier = (0, decimal_1.floatSubDumb)(lastData, Number(group[nullPrefix].data[0]));
    for (const current of group[nullPrefix].data.slice(2)) {
        sumOfModifier += (0, decimal_1.floatSubDumb)(Number(current), lastData);
        lastData = Number(current);
    }
    return {
        modifier: (0, decimal_1.floatDivDumb)(sumOfModifier, ((_b = (_a = group[nullPrefix]) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.length) - 1),
        lastData,
    };
};
// follow google sheet behavior
function populateFillHandleStringNumber({ highlightedData, numberOfRows, }) {
    var _a, _b;
    const nullPrefix = Symbol('nullPrefix');
    const emptyCell = Symbol('empty');
    const group = {};
    const groupIndex = {};
    const rowToFill = numberOfRows - highlightedData.length;
    if (rowToFill <= 0) {
        return [];
    }
    let highLightIndex = 0;
    // group row values by prefix / suffix
    for (const highlightedRow of highlightedData) {
        let index;
        let groupKey;
        if (typeof highlightedRow === 'string') {
            // check if number
            if (!(0, is_1.ncIsNullOrUndefined)(highlightedRow) &&
                highlightedRow !== '' &&
                (0, is_1.ncIsNumber)(Number(highlightedRow))) {
                groupKey = nullPrefix;
                index = highlightedRow;
            }
            else {
                const regexResult = highlightedRow.match(fillHandlerSuffixRegex);
                if (!regexResult) {
                    if (highlightedRow !== '') {
                        groupKey = highlightedRow;
                    }
                }
                else {
                    const [_match, ...rest] = regexResult;
                    groupKey = rest[0];
                    index = rest[1];
                    if (groupKey === '') {
                        groupKey = nullPrefix;
                    }
                }
            }
        }
        else if (typeof highlightedRow === 'number') {
            groupKey = nullPrefix;
            index = highlightedRow;
        }
        if ((0, is_1.ncIsNullOrUndefined)(groupKey) && (0, is_1.ncIsNullOrUndefined)(index)) {
            groupIndex[highLightIndex++] = {
                group: {
                    data: [],
                    modifier: 0,
                    prefix: emptyCell,
                    lastIndex: undefined,
                },
                row: undefined,
            };
            continue;
        }
        if (!group[groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix]) {
            group[groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix] = {
                prefix: groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix,
                data: [],
                modifier: 0,
                lastIndex: index,
            };
        }
        const groupData = group[groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix].data;
        groupData.push(index);
        groupIndex[highLightIndex++] = {
            group: group[groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix],
            row: index,
        };
    }
    // loop once per group to calculate / set modifier
    for (const [_prefix, groupRecord] of Object.entries(group)) {
        if (groupRecord.data.length > 1) {
            let lastData = Number(groupRecord.data[1]);
            let modifier = lastData - Number(groupRecord.data[0]);
            for (const current of groupRecord.data.slice(2)) {
                if (Number(current) - lastData !== modifier) {
                    modifier = 0;
                    break;
                }
                lastData = Number(current);
            }
            groupRecord.modifier = modifier;
            groupRecord.lastIndex = lastData;
        }
    }
    // for pure number, the logic is different following google sheet
    if (((_b = (_a = group[nullPrefix]) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.length) > 1) {
        const { lastData, modifier } = getModifierForNumber({
            group,
            nullPrefix,
        });
        group[nullPrefix].modifier = modifier;
        group[nullPrefix].lastIndex = lastData;
    }
    const result = [];
    for (let fillingIndex = 0; fillingIndex < rowToFill; fillingIndex++) {
        const groupOfIndex = groupIndex[fillingIndex % highlightedData.length];
        if (emptyCell === groupOfIndex.group.prefix) {
            result.push(null);
        }
        else if (typeof groupOfIndex.group.prefix === 'string' &&
            groupOfIndex.group.modifier === 0) {
            const rowStr = (0, is_1.ncIsUndefined)(groupOfIndex.row) ? '' : groupOfIndex.row;
            result.push(`${groupOfIndex.group.prefix}${rowStr}`);
        }
        else {
            // if the modifier has decimal, round to nearest decimal
            if (groupOfIndex.group.modifier - Math.floor(groupOfIndex.group.modifier) >
                0) {
                groupOfIndex.group.lastIndex = (0, decimal_1.floatAddDumb)(groupOfIndex.group.lastIndex, groupOfIndex.group.modifier);
            }
            else {
                groupOfIndex.group.lastIndex += groupOfIndex.group.modifier;
            }
            result.push(`${groupOfIndex.group.prefix === nullPrefix
                ? ''
                : groupOfIndex.group.prefix}${Math.abs(groupOfIndex.group.lastIndex)}`);
        }
    }
    return result;
}
// simply copy the value repeatedly
function populateFillHandleStrictCopy({ highlightedData, numberOfRows, }) {
    const result = [];
    for (let i = 0; i < numberOfRows - highlightedData.length; i++) {
        result.push(highlightedData[i % highlightedData.length]);
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsbC1oYW5kbGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvdXRpbHMvZmlsbC1oYW5kbGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBa0NBLHdFQTZKQztBQUdELG9FQWNDO0FBL01ELGlDQUEwRTtBQUMxRSx1Q0FBcUU7QUFDckUsTUFBTSxzQkFBc0IsR0FBRyxZQUFZLENBQUM7QUFFNUMsTUFBTSxvQkFBb0IsR0FBRyxDQUFDLEVBQzVCLEtBQUssRUFDTCxVQUFVLEdBWVgsRUFBRSxFQUFFOztJQUNILElBQUksYUFBYSxHQUFHLENBQUMsQ0FBQztJQUN0QixJQUFJLFFBQVEsR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2pELGFBQWEsR0FBRyxJQUFBLHNCQUFZLEVBQUMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUMxRSxLQUFLLE1BQU0sT0FBTyxJQUFJLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7UUFDdEQsYUFBYSxJQUFJLElBQUEsc0JBQVksRUFBQyxNQUFNLENBQUMsT0FBTyxDQUFDLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFDekQsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUM3QixDQUFDO0lBQ0QsT0FBTztRQUNMLFFBQVEsRUFBRSxJQUFBLHNCQUFZLEVBQUMsYUFBYSxFQUFFLENBQUEsTUFBQSxNQUFBLEtBQUssQ0FBQyxVQUFVLENBQUMsMENBQUUsSUFBSSwwQ0FBRSxNQUFNLElBQUcsQ0FBQyxDQUFDO1FBQzFFLFFBQVE7S0FDVCxDQUFDO0FBQ0osQ0FBQyxDQUFDO0FBRUYsK0JBQStCO0FBQy9CLFNBQWdCLDhCQUE4QixDQUFDLEVBQzdDLGVBQWUsRUFDZixZQUFZLEdBS2I7O0lBQ0MsTUFBTSxVQUFVLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQ3hDLE1BQU0sU0FBUyxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUNsQyxNQUFNLEtBQUssR0FRUCxFQUFFLENBQUM7SUFDUCxNQUFNLFVBQVUsR0FXWixFQUFFLENBQUM7SUFDUCxNQUFNLFNBQVMsR0FBRyxZQUFZLEdBQUcsZUFBZSxDQUFDLE1BQU0sQ0FBQztJQUN4RCxJQUFJLFNBQVMsSUFBSSxDQUFDLEVBQUUsQ0FBQztRQUNuQixPQUFPLEVBQUUsQ0FBQztJQUNaLENBQUM7SUFDRCxJQUFJLGNBQWMsR0FBRyxDQUFDLENBQUM7SUFDdkIsc0NBQXNDO0lBQ3RDLEtBQUssTUFBTSxjQUFjLElBQUksZUFBZSxFQUFFLENBQUM7UUFDN0MsSUFBSSxLQUFLLENBQUM7UUFDVixJQUFJLFFBQVEsQ0FBQztRQUNiLElBQUksT0FBTyxjQUFjLEtBQUssUUFBUSxFQUFFLENBQUM7WUFDdkMsa0JBQWtCO1lBQ2xCLElBQ0UsQ0FBQyxJQUFBLHdCQUFtQixFQUFDLGNBQWMsQ0FBQztnQkFDcEMsY0FBYyxLQUFLLEVBQUU7Z0JBQ3JCLElBQUEsZUFBVSxFQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsQ0FBQyxFQUNsQyxDQUFDO2dCQUNELFFBQVEsR0FBRyxVQUFVLENBQUM7Z0JBQ3RCLEtBQUssR0FBRyxjQUFjLENBQUM7WUFDekIsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE1BQU0sV0FBVyxHQUFHLGNBQWMsQ0FBQyxLQUFLLENBQUMsc0JBQXNCLENBQUMsQ0FBQztnQkFDakUsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO29CQUNqQixJQUFJLGNBQWMsS0FBSyxFQUFFLEVBQUUsQ0FBQzt3QkFDMUIsUUFBUSxHQUFHLGNBQWMsQ0FBQztvQkFDNUIsQ0FBQztnQkFDSCxDQUFDO3FCQUFNLENBQUM7b0JBQ04sTUFBTSxDQUFDLE1BQU0sRUFBRSxHQUFHLElBQUksQ0FBQyxHQUFHLFdBQVcsQ0FBQztvQkFDdEMsUUFBUSxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztvQkFDbkIsS0FBSyxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztvQkFDaEIsSUFBSSxRQUFRLEtBQUssRUFBRSxFQUFFLENBQUM7d0JBQ3BCLFFBQVEsR0FBRyxVQUFVLENBQUM7b0JBQ3hCLENBQUM7Z0JBQ0gsQ0FBQztZQUNILENBQUM7UUFDSCxDQUFDO2FBQU0sSUFBSSxPQUFPLGNBQWMsS0FBSyxRQUFRLEVBQUUsQ0FBQztZQUM5QyxRQUFRLEdBQUcsVUFBVSxDQUFDO1lBQ3RCLEtBQUssR0FBRyxjQUFjLENBQUM7UUFDekIsQ0FBQztRQUNELElBQUksSUFBQSx3QkFBbUIsRUFBQyxRQUFRLENBQUMsSUFBSSxJQUFBLHdCQUFtQixFQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7WUFDaEUsVUFBVSxDQUFDLGNBQWMsRUFBRSxDQUFDLEdBQUc7Z0JBQzdCLEtBQUssRUFBRTtvQkFDTCxJQUFJLEVBQUUsRUFBRTtvQkFDUixRQUFRLEVBQUUsQ0FBQztvQkFDWCxNQUFNLEVBQUUsU0FBUztvQkFDakIsU0FBUyxFQUFFLFNBQVM7aUJBQ3JCO2dCQUNELEdBQUcsRUFBRSxTQUFTO2FBQ2YsQ0FBQztZQUNGLFNBQVM7UUFDWCxDQUFDO1FBQ0QsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLGFBQVIsUUFBUSxjQUFSLFFBQVEsR0FBSSxVQUFVLENBQUMsRUFBRSxDQUFDO1lBQ25DLEtBQUssQ0FBQyxRQUFRLGFBQVIsUUFBUSxjQUFSLFFBQVEsR0FBSSxVQUFVLENBQUMsR0FBRztnQkFDOUIsTUFBTSxFQUFFLFFBQVEsYUFBUixRQUFRLGNBQVIsUUFBUSxHQUFJLFVBQVU7Z0JBQzlCLElBQUksRUFBRSxFQUFFO2dCQUNSLFFBQVEsRUFBRSxDQUFDO2dCQUNYLFNBQVMsRUFBRSxLQUFLO2FBQ2pCLENBQUM7UUFDSixDQUFDO1FBQ0QsTUFBTSxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsYUFBUixRQUFRLGNBQVIsUUFBUSxHQUFJLFVBQVUsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUVyRCxTQUFTLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3RCLFVBQVUsQ0FBQyxjQUFjLEVBQUUsQ0FBQyxHQUFHO1lBQzdCLEtBQUssRUFBRSxLQUFLLENBQUMsUUFBUSxhQUFSLFFBQVEsY0FBUixRQUFRLEdBQUksVUFBVSxDQUFDO1lBQ3BDLEdBQUcsRUFBRSxLQUFLO1NBQ1gsQ0FBQztJQUNKLENBQUM7SUFFRCxrREFBa0Q7SUFDbEQsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLFdBQVcsQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQztRQUMzRCxJQUFJLFdBQVcsQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQ2hDLElBQUksUUFBUSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDM0MsSUFBSSxRQUFRLEdBQUcsUUFBUSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDdEQsS0FBSyxNQUFNLE9BQU8sSUFBSSxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO2dCQUNoRCxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxRQUFRLEtBQUssUUFBUSxFQUFFLENBQUM7b0JBQzVDLFFBQVEsR0FBRyxDQUFDLENBQUM7b0JBQ2IsTUFBTTtnQkFDUixDQUFDO2dCQUNELFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7WUFDN0IsQ0FBQztZQUNELFdBQVcsQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO1lBQ2hDLFdBQVcsQ0FBQyxTQUFTLEdBQUcsUUFBUSxDQUFDO1FBQ25DLENBQUM7SUFDSCxDQUFDO0lBRUQsaUVBQWlFO0lBQ2pFLElBQUksQ0FBQSxNQUFBLE1BQUEsS0FBSyxDQUFDLFVBQVUsQ0FBQywwQ0FBRSxJQUFJLDBDQUFFLE1BQU0sSUFBRyxDQUFDLEVBQUUsQ0FBQztRQUN4QyxNQUFNLEVBQUUsUUFBUSxFQUFFLFFBQVEsRUFBRSxHQUFHLG9CQUFvQixDQUFDO1lBQ2xELEtBQUs7WUFDTCxVQUFVO1NBQ1gsQ0FBQyxDQUFDO1FBQ0gsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7UUFDdEMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDLFNBQVMsR0FBRyxRQUFRLENBQUM7SUFDekMsQ0FBQztJQUNELE1BQU0sTUFBTSxHQUFVLEVBQUUsQ0FBQztJQUN6QixLQUFLLElBQUksWUFBWSxHQUFHLENBQUMsRUFBRSxZQUFZLEdBQUcsU0FBUyxFQUFFLFlBQVksRUFBRSxFQUFFLENBQUM7UUFDcEUsTUFBTSxZQUFZLEdBQUcsVUFBVSxDQUFDLFlBQVksR0FBRyxlQUFlLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDdkUsSUFBSSxTQUFTLEtBQUssWUFBWSxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUM1QyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3BCLENBQUM7YUFBTSxJQUNMLE9BQU8sWUFBWSxDQUFDLEtBQUssQ0FBQyxNQUFNLEtBQUssUUFBUTtZQUM3QyxZQUFZLENBQUMsS0FBSyxDQUFDLFFBQVEsS0FBSyxDQUFDLEVBQ2pDLENBQUM7WUFDRCxNQUFNLE1BQU0sR0FBRyxJQUFBLGtCQUFhLEVBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUM7WUFDdkUsTUFBTSxDQUFDLElBQUksQ0FBQyxHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLE1BQU0sRUFBRSxDQUFDLENBQUM7UUFDdkQsQ0FBQzthQUFNLENBQUM7WUFDTix3REFBd0Q7WUFDeEQsSUFDRSxZQUFZLENBQUMsS0FBSyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDO2dCQUNyRSxDQUFDLEVBQ0QsQ0FBQztnQkFDRCxZQUFZLENBQUMsS0FBSyxDQUFDLFNBQVMsR0FBRyxJQUFBLHNCQUFZLEVBQ3pDLFlBQVksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUM1QixZQUFZLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FDNUIsQ0FBQztZQUNKLENBQUM7aUJBQU0sQ0FBQztnQkFDTixZQUFZLENBQUMsS0FBSyxDQUFDLFNBQVMsSUFBSSxZQUFZLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQztZQUM5RCxDQUFDO1lBQ0QsTUFBTSxDQUFDLElBQUksQ0FDVCxHQUNFLFlBQVksQ0FBQyxLQUFLLENBQUMsTUFBTSxLQUFLLFVBQVU7Z0JBQ3RDLENBQUMsQ0FBQyxFQUFFO2dCQUNKLENBQUMsQ0FBRSxZQUFZLENBQUMsS0FBSyxDQUFDLE1BQzFCLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQzVDLENBQUM7UUFDSixDQUFDO0lBQ0gsQ0FBQztJQUNELE9BQU8sTUFBTSxDQUFDO0FBQ2hCLENBQUM7QUFFRCxtQ0FBbUM7QUFDbkMsU0FBZ0IsNEJBQTRCLENBQUMsRUFDM0MsZUFBZSxFQUNmLFlBQVksR0FLYjtJQUNDLE1BQU0sTUFBTSxHQUFVLEVBQUUsQ0FBQztJQUV6QixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsWUFBWSxHQUFHLGVBQWUsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQztRQUMvRCxNQUFNLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDLEdBQUcsZUFBZSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUNELE9BQU8sTUFBTSxDQUFDO0FBQ2hCLENBQUMifQ==