"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fill_handler_1 = require("./fill-handler");
describe('fill-handler.utils', () => {
    describe('populateFillHandleStringNumber', () => {
        it('will populate single number value', () => {
            const data = [33];
            const result = (0, fill_handler_1.populateFillHandleStringNumber)({
                highlightedData: data,
                column: {},
                numberOfRows: 3,
            });
            expect(result).toEqual(['33', '33']);
        });
        it('will populate number value', () => {
            const data = ['2', '4', '6', 8];
            const result = (0, fill_handler_1.populateFillHandleStringNumber)({
                highlightedData: data,
                column: {},
                numberOfRows: 8,
            });
            expect(result).toEqual(['10', '12', '14', '16']);
        });
        it('will populate combined string value', () => {
            const data = ['1A1', '2', '4', '1A2', '6', 8, '1A3'];
            const result = (0, fill_handler_1.populateFillHandleStringNumber)({
                highlightedData: data,
                column: {},
                numberOfRows: 16,
            });
            expect(result).toEqual([
                '1A4',
                '10',
                '12',
                '1A5',
                '14',
                '16',
                '1A6',
                '1A7',
                '18',
            ]);
        });
        it('will populate combined string value without suffix', () => {
            const data = ['1A1', '1A2', '1A3', '1A', '1A4'];
            const result = (0, fill_handler_1.populateFillHandleStringNumber)({
                highlightedData: data,
                column: {},
                numberOfRows: 16,
            });
            expect(result).toEqual([
                '1A1',
                '1A2',
                '1A3',
                '1A',
                '1A4',
                '1A1',
                '1A2',
                '1A3',
                '1A',
                '1A4',
                '1A1',
            ]);
        });
        it('will populate combined value with empty cell', () => {
            const data = ['1A1', '1A2', '', null, undefined, '1A3'];
            const result = (0, fill_handler_1.populateFillHandleStringNumber)({
                highlightedData: data,
                column: {},
                numberOfRows: 16,
            });
            expect(result).toEqual([
                '1A4',
                '1A5',
                null,
                null,
                null,
                '1A6',
                '1A7',
                '1A8',
                null,
                null,
            ]);
        });
        it('will populate descending combined string value', () => {
            const data = ['1A4', '4', '3', '1A3', '2', 1, '1A2'];
            const result = (0, fill_handler_1.populateFillHandleStringNumber)({
                highlightedData: data,
                column: {},
                numberOfRows: 16,
            });
            expect(result).toEqual([
                '1A1',
                '0',
                '1',
                '1A0',
                '2',
                '3',
                '1A1',
                '1A2',
                '4',
            ]);
        });
        it('will populate decimal value', () => {
            const data = ['33.11', '33.12', '33.13'];
            const result = (0, fill_handler_1.populateFillHandleStringNumber)({
                highlightedData: data,
                column: {},
                numberOfRows: 14,
            });
            expect(result).toEqual([
                '33.14',
                '33.15',
                '33.16',
                '33.17',
                '33.18',
                '33.19',
                '33.2',
                '33.21',
                '33.22',
                '33.23',
                '33.24',
            ]);
        });
    });
    describe('populateFillHandleStrictCopy', () => {
        it('will populate number value by strict copy', () => {
            const data = ['2', '4', '6', 8];
            const result = (0, fill_handler_1.populateFillHandleStrictCopy)({
                highlightedData: data,
                column: {},
                numberOfRows: 8,
            });
            expect(result).toEqual(['2', '4', '6', 8]);
        });
        it('will populate number value by strict copy with combination and null values', () => {
            const data = ['2', '4', '6', 8, '1A', '1B', null, undefined, ''];
            const result = (0, fill_handler_1.populateFillHandleStrictCopy)({
                highlightedData: data,
                column: {},
                numberOfRows: 20,
            });
            expect(result).toEqual([
                '2',
                '4',
                '6',
                8,
                '1A',
                '1B',
                null,
                undefined,
                '',
                '2',
                '4',
            ]);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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