"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.traverseNested = exports.arrayToNested = void 0;
const arrayToNested = ({ data, getIdHandler, getFkHandler, childAssignHandler, parentFkId, level = 0, maxLevel = 5, }) => {
    let recordsOnLevel;
    if (level === 0) {
        recordsOnLevel = data.filter((row) => !getFkHandler(row));
    }
    else {
        recordsOnLevel = data.filter((row) => getFkHandler(row) === parentFkId);
    }
    if (level < maxLevel) {
        for (const row of recordsOnLevel) {
            childAssignHandler(row, (0, exports.arrayToNested)({
                data,
                getIdHandler,
                parentFkId: getIdHandler(row),
                childAssignHandler,
                getFkHandler,
                level: level + 1,
                maxLevel,
            }));
        }
    }
    return recordsOnLevel;
};
exports.arrayToNested = arrayToNested;
const traverseNested = (params) => {
    for (const each of params.nestedData) {
        params.onEach(each);
        (0, exports.traverseNested)({
            nestedData: params.getChildField(each),
            getChildField: params.getChildField,
            onEach: params.onEach,
        });
    }
};
exports.traverseNested = traverseNested;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVjdXJzaXZlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvdXRpbHMvcmVjdXJzaXZlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFPLE1BQU0sYUFBYSxHQUFHLENBQUMsRUFDNUIsSUFBSSxFQUNKLFlBQVksRUFDWixZQUFZLEVBQ1osa0JBQWtCLEVBQ2xCLFVBQVUsRUFDVixLQUFLLEdBQUcsQ0FBQyxFQUNULFFBQVEsR0FBRyxDQUFDLEdBU2IsRUFBRSxFQUFFO0lBQ0gsSUFBSSxjQUFjLENBQUM7SUFDbkIsSUFBSSxLQUFLLEtBQUssQ0FBQyxFQUFFLENBQUM7UUFDaEIsY0FBYyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDNUQsQ0FBQztTQUFNLENBQUM7UUFDTixjQUFjLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxLQUFLLFVBQVUsQ0FBQyxDQUFDO0lBQzFFLENBQUM7SUFDRCxJQUFJLEtBQUssR0FBRyxRQUFRLEVBQUUsQ0FBQztRQUNyQixLQUFLLE1BQU0sR0FBRyxJQUFJLGNBQWMsRUFBRSxDQUFDO1lBQ2pDLGtCQUFrQixDQUNoQixHQUFHLEVBQ0gsSUFBQSxxQkFBYSxFQUFDO2dCQUNaLElBQUk7Z0JBQ0osWUFBWTtnQkFDWixVQUFVLEVBQUUsWUFBWSxDQUFDLEdBQUcsQ0FBQztnQkFDN0Isa0JBQWtCO2dCQUNsQixZQUFZO2dCQUNaLEtBQUssRUFBRSxLQUFLLEdBQUcsQ0FBQztnQkFDaEIsUUFBUTthQUNULENBQUMsQ0FDSCxDQUFDO1FBQ0osQ0FBQztJQUNILENBQUM7SUFDRCxPQUFPLGNBQWMsQ0FBQztBQUN4QixDQUFDLENBQUM7QUF4Q1csUUFBQSxhQUFhLGlCQXdDeEI7QUFFSyxNQUFNLGNBQWMsR0FBRyxDQUFJLE1BSWpDLEVBQUUsRUFBRTtJQUNILEtBQUssTUFBTSxJQUFJLElBQUksTUFBTSxDQUFDLFVBQVUsRUFBRSxDQUFDO1FBQ3JDLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDcEIsSUFBQSxzQkFBYyxFQUFDO1lBQ2IsVUFBVSxFQUFFLE1BQU0sQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO1lBQ3RDLGFBQWEsRUFBRSxNQUFNLENBQUMsYUFBYTtZQUNuQyxNQUFNLEVBQUUsTUFBTSxDQUFDLE1BQU07U0FDdEIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztBQUNILENBQUMsQ0FBQztBQWJXLFFBQUEsY0FBYyxrQkFhekIifQ==