"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.isReadonlyVirtualColumn = exports.isLink = exports.isCount = exports.isBarcode = exports.isQrCode = exports.isFormula = exports.isRollup = exports.isLookup = exports.isOo = exports.isBt = exports.isMm = exports.isHm = exports.isLTAR = void 0;
exports.isReadOnlyVirtualCell = isReadOnlyVirtualCell;
const globals_1 = require("../../../lib/globals");
const helperFunctions_1 = require("../../../lib/helperFunctions");
const UITypes_1 = __importStar(require("../../../lib/UITypes"));
const cell_1 = require("./cell");
const isLTAR = (uidt, _colOptions) => {
    if (!uidt)
        return false;
    return (0, UITypes_1.isLinksOrLTAR)(uidt);
};
exports.isLTAR = isLTAR;
const isHm = (column) => {
    var _a;
    return (0, exports.isLTAR)(column.uidt, column.colOptions) &&
        ((_a = column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === globals_1.RelationTypes.HAS_MANY;
};
exports.isHm = isHm;
const isMm = (column) => {
    var _a;
    return (0, exports.isLTAR)(column.uidt, column.colOptions) &&
        ((_a = column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === globals_1.RelationTypes.MANY_TO_MANY;
};
exports.isMm = isMm;
const isBt = (column) => {
    var _a;
    return (0, exports.isLTAR)(column.uidt, column.colOptions) &&
        ((_a = column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === globals_1.RelationTypes.BELONGS_TO;
};
exports.isBt = isBt;
const isOo = (column) => {
    var _a;
    return (0, exports.isLTAR)(column.uidt, column.colOptions) &&
        ((_a = column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === globals_1.RelationTypes.ONE_TO_ONE;
};
exports.isOo = isOo;
const isLookup = (column) => column.uidt === UITypes_1.default.Lookup;
exports.isLookup = isLookup;
const isRollup = (column) => column.uidt === UITypes_1.default.Rollup;
exports.isRollup = isRollup;
const isFormula = (column) => column.uidt === UITypes_1.default.Formula;
exports.isFormula = isFormula;
const isQrCode = (column) => column.uidt === UITypes_1.default.QrCode;
exports.isQrCode = isQrCode;
const isBarcode = (column) => column.uidt === UITypes_1.default.Barcode;
exports.isBarcode = isBarcode;
const isCount = (column) => column.uidt === UITypes_1.default.Count;
exports.isCount = isCount;
const isLink = (column) => column.uidt === UITypes_1.default.Links;
exports.isLink = isLink;
function isReadOnlyVirtualCell(col) {
    return ((0, exports.isRollup)(col) ||
        (0, exports.isFormula)(col) ||
        (0, exports.isBarcode)(col) ||
        (0, exports.isLookup)(col) ||
        (0, exports.isQrCode)(col) ||
        (0, helperFunctions_1.isSystemColumn)(col) ||
        (0, UITypes_1.isCreatedOrLastModifiedTimeCol)(col) ||
        (0, UITypes_1.isCreatedOrLastModifiedByCol)(col));
}
const isReadonlyVirtualColumn = (col) => {
    return ((0, helperFunctions_1.isSystemColumn)(col) ||
        (0, exports.isLookup)(col) ||
        (0, exports.isRollup)(col) ||
        (0, exports.isFormula)(col) ||
        (0, cell_1.isButton)(col) ||
        (0, UITypes_1.isVirtualCol)(col) ||
        (0, UITypes_1.isCreatedOrLastModifiedTimeCol)(col) ||
        (0, UITypes_1.isCreatedOrLastModifiedByCol)(col));
};
exports.isReadonlyVirtualColumn = isReadonlyVirtualColumn;
//# sourceMappingURL=data:application/json;base64,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