/**
 * Extracts properties from an object.
 * @param body - The object to extract properties from.
 * @param props - The properties to extract.
 * @param _throwError - Whether to throw an error if no properties are found.
 * @returns - The extracted properties.
 */
export declare function extractProps<T extends Record<string, any>>(body: T, props: string[], _throwError?: boolean): Partial<T>;
/**
 * Removes all `undefined` values and empty objects (`{}`) from an object.
 * Can optionally run recursively with the `deep` flag.
 *
 * - Works only on plain objects (`ncIsObject`).
 * - Arrays are preserved as-is (including `undefined` entries).
 * - Empty objects are always removed if they occur as object values.
 *
 * @typeParam T - Type of the input value.
 * @param obj - The object or value to clean.
 * @param deep - If `true`, cleans recursively. If `false`, cleans only top-level. Defaults to `true`.
 * @returns A cleaned copy of `obj`.
 *
 * @example
 * ```ts
 * const data = {
 *   a: 1,
 *   b: undefined,
 *   c: { d: 2, e: undefined, f: { g: undefined } },
 *   arr: [1, undefined, { x: undefined, y: 5 }]
 * }
 *
 * removeUndefinedFromObj(data)
 * // → { a: 1, c: { d: 2 }, arr: [1, undefined, { y: 5 }] }
 *
 * removeUndefinedFromObj(data, false)
 * // → { a: 1, c: { d: 2, f: { g: undefined } }, arr: [1, undefined, { x: undefined, y: 5 }] }
 * ```
 */
export declare const removeUndefinedFromObj: <T>(obj: T, deep?: boolean) => T;
