"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNumericValue = exports.getGroupDecimalSymbolFromLocale = void 0;
const is_1 = require("./is");
const getGroupDecimalSymbolFromLocale = (locale) => {
    var _a, _b;
    let group = ',';
    let decimal = '.';
    if (!locale) {
        return {
            group,
            decimal,
        };
    }
    const formatter = new Intl.NumberFormat(locale || 'en-US');
    if (!formatter.formatToParts) {
        return {
            group,
            decimal,
        };
    }
    // Use formatToParts to extract the characters used for grouping (thousands) and decimal
    const parts = formatter.formatToParts(12345.6);
    // Extract group separator (e.g., '.' in 'de-DE', ',' in 'en-US')
    group = ((_a = parts.find((p) => p.type === 'group')) === null || _a === void 0 ? void 0 : _a.value) || group;
    // Extract decimal separator (e.g., ',' in 'de-DE', '.' in 'en-US')
    decimal = ((_b = parts.find((p) => p.type === 'decimal')) === null || _b === void 0 ? void 0 : _b.value) || decimal;
    return {
        group,
        decimal,
    };
};
exports.getGroupDecimalSymbolFromLocale = getGroupDecimalSymbolFromLocale;
const getNumericValue = (value, locale) => {
    // accept valid decimal string as well, like '9.123', '9.1234', '9.123456789'
    if (/^(?:\d+(?:\.\d+)?|\.\d+)$/.test(value)) {
        return {
            value: value,
            pointDecimalValue: value,
            numericValue: parseFloat(value),
            isValid: true,
        };
    }
    const { group, decimal } = (0, exports.getGroupDecimalSymbolFromLocale)(locale);
    const [integerString, decimalString] = value.split(decimal);
    // check if there's group after decimal symbol
    if (decimalString &&
        decimalString.length > 0 &&
        decimalString.indexOf(group) >= 0) {
        return {
            value: value,
            pointDecimalValue: undefined,
            numericValue: undefined,
            isValid: false,
        };
    }
    const integerParts = integerString.split(group);
    // check if there's group that doesn't have 3 digit
    if (integerParts.slice(1).some((p) => p.length !== 3)) {
        return {
            value: value,
            pointDecimalValue: undefined,
            numericValue: undefined,
            isValid: false,
        };
    }
    const valueToParse = value
        .replace(new RegExp(`\\${group}`, 'g'), '')
        .replace(new RegExp(`\\${decimal}`, 'g'), '.')
        .replace(/[^\d.-]/g, '') // 3. Remove any non-digit, non-dot, non-minus characters (e.g., currency symbols, spaces)
        .trim();
    const numericValue = parseFloat(valueToParse);
    const isValid = (0, is_1.ncIsNumber)(numericValue);
    return {
        value: value,
        pointDecimalValue: isValid ? valueToParse : undefined,
        numericValue: isValid ? numericValue : undefined,
        isValid,
    };
};
exports.getNumericValue = getNumericValue;
//# sourceMappingURL=data:application/json;base64,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