import { ChartTypes, TextWidgetTypes, WidgetDataSourceTypes, WidgetType, WidgetTypes } from '.';
import { ColumnType } from '../../lib';
export declare const calculateNextPosition: (existingWidgets: WidgetType[], newWidgetDimensions: {
    w: number;
    h: number;
}, gridColumns?: number) => {
    x: number;
    y: number;
};
declare const defaultGaugeWidgetRange: {
    color: string;
    min: number;
    max: number;
    label: string;
}[];
declare const getDefaultConfig: (widgetType: WidgetTypes, chartType?: ChartTypes, columns?: Array<ColumnType>) => {
    chartType: ChartTypes;
    data: {
        category: {
            column_id: string;
            orderBy: "default";
            includeEmptyRecords: boolean;
            includeOthers: boolean;
            categoryLimit: number;
        };
        value: {
            type: "count";
        };
        xAxis?: undefined;
        yAxis?: undefined;
    };
    appearance: {
        size: "medium";
        showCountInLegend: boolean;
        showPercentageOnChart: boolean;
        legendPosition: "right";
        colorSchema: "default";
        customColorSchema: any[];
    };
    permissions: {
        allowUserToPrint: boolean;
        allowUsersToViewRecords: boolean;
    };
    dataSource: WidgetDataSourceTypes;
} | {
    chartType: ChartTypes.BAR | ChartTypes.LINE;
    appearance: {
        showCountInLegend: boolean;
        legendPosition: string;
        showPercentageOnChart: boolean;
        size?: undefined;
        colorSchema?: undefined;
        customColorSchema?: undefined;
    };
    data: {
        xAxis: {
            column_id: string;
            sortBy: "xAxis";
            orderBy: "default";
            includeEmptyRecords: boolean;
            includeOthers: boolean;
            categoryLimit: number;
        };
        yAxis: {
            startAtZero: boolean;
            fields: {
                column_id: string;
                aggregation: import("../../lib").CommonAggregations;
            }[];
            groupBy: any;
        };
        category?: undefined;
        value?: undefined;
    };
    permissions: {
        allowUserToPrint: boolean;
        allowUsersToViewRecords: boolean;
    };
    dataSource: WidgetDataSourceTypes;
} | {
    chartType: ChartTypes.SCATTER;
    dataSource: WidgetDataSourceTypes;
} | {
    dataSource: WidgetDataSourceTypes;
    metric: {
        type: "count";
        aggregation: "count";
    };
    appearance: {
        type: "filled";
        theme: "purple";
        showValue?: undefined;
        ranges?: undefined;
        font?: undefined;
        color?: undefined;
    };
    url?: undefined;
    allowFullScreen?: undefined;
    content?: undefined;
    type?: undefined;
    formatting?: undefined;
} | {
    dataSource: WidgetDataSourceTypes;
    metric: {
        type: "count";
        aggregation: "count";
    };
    appearance: {
        showValue: boolean;
        ranges: {
            color: string;
            min: number;
            max: number;
            label: string;
        }[];
        type?: undefined;
        theme?: undefined;
        font?: undefined;
        color?: undefined;
    };
    url?: undefined;
    allowFullScreen?: undefined;
    content?: undefined;
    type?: undefined;
    formatting?: undefined;
} | {
    url: string;
    allowFullScreen: boolean;
    dataSource?: undefined;
    metric?: undefined;
    appearance?: undefined;
    content?: undefined;
    type?: undefined;
    formatting?: undefined;
} | {
    content: string;
    type: TextWidgetTypes;
    formatting: {
        horizontalAlign: string;
        verticalAlign: string;
        bold: boolean;
        italic: boolean;
        underline: boolean;
        strikethrough: boolean;
    };
    appearance: {
        font: {
            family: string;
            weight: number;
            size: number;
            lineHeight: number;
        };
        color: string;
        type?: undefined;
        theme?: undefined;
        showValue?: undefined;
        ranges?: undefined;
    };
    dataSource?: undefined;
    metric?: undefined;
    url?: undefined;
    allowFullScreen?: undefined;
} | {
    dataSource?: undefined;
    metric?: undefined;
    appearance?: undefined;
    url?: undefined;
    allowFullScreen?: undefined;
    content?: undefined;
    type?: undefined;
    formatting?: undefined;
};
export { getDefaultConfig, defaultGaugeWidgetRange };
