import { BaseType, SourceType } from '../Api';
import { NcErrorArgs } from '../error/nc-base.error';
import { PlanLimitExceededDetailsType } from '../globals';
import { PlanFeatureTypes } from '../payment';
import UITypes from '../UITypes';
import { NcErrorCodexManager } from './nc-error-codex-manager';
export declare class NcErrorBase {
    constructor();
    protected _errorCodex: NcErrorCodexManager;
    get errorCodex(): NcErrorCodexManager;
    authenticationRequired(args?: NcErrorArgs): never;
    apiTokenNotAllowed(args?: NcErrorArgs): never;
    workspaceNotFound(id: string, args?: NcErrorArgs): never;
    columnAssociatedWithLink(_id: string, args: NcErrorArgs): never;
    tableAssociatedWithLink(_id: string, args: NcErrorArgs): never;
    viewColumnNotFound(id: string, args?: NcErrorArgs): never;
    baseNotFound(id: string, args?: NcErrorArgs): never;
    dashboardNotFound(id: string, args?: NcErrorArgs): never;
    workflowNotFound(id: string, args?: NcErrorArgs): never;
    widgetNotFound(id: string, args?: NcErrorArgs): never;
    apiClientNotFound(id: string, args?: NcErrorArgs): never;
    sourceNotFound(id: string, args?: NcErrorArgs): never;
    noSourcesFound(args?: NcErrorArgs): never;
    tableNotFound(id: string, args?: NcErrorArgs): never;
    userNotFound(id: string, args?: NcErrorArgs): never;
    teamNotFound(id: string, args?: NcErrorArgs): never;
    viewNotFound(id: string, args?: NcErrorArgs): never;
    hookNotFound(id: string, args?: NcErrorArgs): never;
    genericNotFound(resource: string, id: string, args?: NcErrorArgs): never;
    requiredFieldMissing(field: string, args?: NcErrorArgs): never;
    duplicateRecord(id: string | string[], args?: NcErrorArgs): never;
    fieldNotFound(param: string | {
        field: string;
        onSection?: string;
    }, args?: NcErrorArgs): never;
    extensionNotFound(id: string, args?: NcErrorArgs): never;
    invalidOffsetValue(offset: string | number, args?: NcErrorArgs): never;
    invalidPageValue(page: string | number, args?: NcErrorArgs): never;
    invalidPrimaryKey(value: any, pkColumn: string, args?: NcErrorArgs): never;
    invalidLimitValue(args?: NcErrorArgs): never;
    invalidFilter(filter: string, args?: NcErrorArgs): never;
    invalidValueForField(payload: string | {
        value: string;
        column: string;
        type: UITypes;
        reason?: string;
    }, args?: NcErrorArgs): never;
    unsupportedFilterOperation(operation: string, args?: NcErrorArgs): never;
    valueLengthExceedLimit(payload: {
        column: string;
        type: UITypes;
        length: number;
        maxLength: number;
    }, args?: NcErrorArgs): never;
    invalidSharedViewPassword(args?: NcErrorArgs): never;
    invalidSharedDashboardPassword(args?: NcErrorArgs): never;
    invalidAttachmentJson(payload: string, args?: NcErrorArgs): never;
    notImplemented(feature?: string, args?: NcErrorArgs): never;
    internalServerError(message: string, args?: NcErrorArgs): never;
    formulaError(message: string, args?: NcErrorArgs): never;
    formulaCircularRefError(message?: string, args?: NcErrorArgs): never;
    unauthorized(message: string, args?: NcErrorArgs): never;
    forbidden(message: string, args?: NcErrorArgs): never;
    sourceDataReadOnly(name: string): void;
    sourceMetaReadOnly(name: string): void;
    integrationNotFound(id: string, args?: NcErrorArgs): never;
    cannotCalculateIntermediateOrderError(): never;
    reorderFailed(): never;
    integrationLinkedWithMultiple(bases: BaseType[], sources: SourceType[], args?: NcErrorArgs): never;
    invalidAttachmentUploadScope(args?: NcErrorArgs): never;
    webhookError(message?: string, args?: NcErrorArgs): never;
    invalidWebhookUrl(url: string, args?: NcErrorArgs): never;
    planLimitExceeded(message: string, details: Omit<PlanLimitExceededDetailsType, 'higherPlan'>, args?: NcErrorArgs): never;
    duplicateAlias(param: {
        type: 'table' | 'column' | 'view';
        alias: string;
        base: string;
        label?: string;
        additionalTrace?: Record<string, string>;
    }, args?: NcErrorArgs): never;
    allowedOnlySSOAccess(ncWorkspaceId: string): never;
    allowedOnlySSOGeneratedToken(ncWorkspaceId: string): never;
    maxPayloadLimitExceeded(limit: number, args?: NcErrorArgs): never;
    baseUserError(message: string, args?: NcErrorArgs): never;
    orgUserError(message: string, args?: NcErrorArgs): never;
    tableError(message: string, args?: NcErrorArgs): never;
    columnError(message: string, args?: NcErrorArgs): never;
    baseError(message: string, args?: NcErrorArgs): never;
    maxWorkspaceLimitReached(args?: NcErrorArgs): never;
    pluginTestError(message: string, args?: NcErrorArgs): never;
    relationFieldNotFound(id: string, args?: NcErrorArgs): never;
    unSupportedRelation(relation: string, args?: NcErrorArgs): never;
    externalError(error: string | Error, args?: NcErrorArgs): never;
    externalTimeOut(message?: string, args?: NcErrorArgs): never;
    prohibitedSyncTableOperation(param: {
        modelName: string;
        operation: 'insert' | 'update' | 'delete' | 'create_form_view';
    }, args?: NcErrorArgs): never;
    featureNotSupported(props: {
        feature: PlanFeatureTypes;
        isOnPrem?: boolean;
    }, args?: NcErrorArgs): void;
    invalidRequestBody(message: string): never;
    unprocessableEntity(message?: string): never;
    testConnectionError(message?: string, code?: string): never;
    notAllowed(message?: string): never;
    emailDomainNotAllowed(domain: string): never;
    metaError(param: {
        message: string;
        sql: string;
    }): never;
    notFound(message?: string): never;
    badRequest(message: any): never;
    optionsNotExists(props: {
        columnTitle: string;
        options: string[];
        validOptions: string[];
    }): never;
    outOfSync(message: string): never;
    filterVerificationFailed(errors: string[]): never;
    storageFileCreateError(message: string, args?: NcErrorArgs): never;
    storageFileReadError(message: string, args?: NcErrorArgs): never;
    storageFileDeleteError(message: string, args?: NcErrorArgs): never;
    storageFileStreamError(message: string, args?: NcErrorArgs): never;
    subscriptionAlreadyExists(workspaceOrOrgId: string, args?: NcErrorArgs): never;
    subscriptionNotFound(workspaceOrOrgId: string, args?: NcErrorArgs): never;
    planNotAvailable(args?: NcErrorArgs): never;
    seatCountMismatch(args?: NcErrorArgs): never;
    invalidPaymentPayload(args?: NcErrorArgs): never;
    stripeCustomerNotFound(customerId: string, args?: NcErrorArgs): never;
    stripeSubscriptionNotFound(subscriptionId: string, args?: NcErrorArgs): never;
    subscriptionOwnershipMismatch(entity: 'workspace' | 'org', args?: NcErrorArgs): never;
    internalCustomerNotSupported(args?: NcErrorArgs): never;
    subscriptionCreateFailed(message: string, args?: NcErrorArgs): never;
    stripeWebhookVerificationFailed(args?: NcErrorArgs): never;
    planAlreadyExists(id: string, args?: NcErrorArgs): never;
    workflowEmptyNode(args?: NcErrorArgs): never;
    workflowTriggerNodeNotFound(args?: NcErrorArgs): never;
    workflowNodeExecutionFailed(nodeTitle: string, error: string, args?: NcErrorArgs): never;
    workflowWaitingExecutions(count: number, args?: NcErrorArgs): never;
    workflowMaxIterationsExceeded(args?: NcErrorArgs): never;
    workflowNodeNotFound(nodeTitle: string, args?: NcErrorArgs): never;
    scriptNotFound(id: string, args?: NcErrorArgs): never;
    methodNotAllowed(method: string, args?: NcErrorArgs): never;
}
