"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NcErrorCodexManager = void 0;
const nc_base_error_1 = require("../../lib/error/nc-base.error");
const preset_error_codex_map_1 = require("../../lib/error-handler/preset-error-codex-map");
class NcErrorCodexManager {
    constructor() {
        this.errorCodexMap = {};
        this.setErrorCodexes(preset_error_codex_map_1.presetErrorCodexMap);
    }
    setErrorCodex(errorType, handler) {
        this.errorCodexMap[errorType] = handler;
    }
    setErrorCodexes(handlers) {
        this.errorCodexMap = Object.assign(Object.assign({}, this.errorCodexMap), handlers);
    }
    generateError(error, args) {
        const errorHelper = this.errorCodexMap[error];
        const { params, customMessage, details } = args || {};
        if (!errorHelper) {
            return {
                message: 'An error occurred',
                code: 500,
                details: details,
            };
        }
        let message;
        const messageHelper = customMessage || errorHelper.message;
        if (typeof messageHelper === 'function') {
            message = messageHelper(...(Array.isArray(params) ? params : [params]));
        }
        else {
            message = messageHelper;
        }
        return new nc_base_error_1.NcBaseErrorv2(message, errorHelper.code, error, {
            details: details,
        });
    }
}
exports.NcErrorCodexManager = NcErrorCodexManager;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmMtZXJyb3ItY29kZXgtbWFuYWdlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9saWIvZXJyb3ItaGFuZGxlci9uYy1lcnJvci1jb2RleC1tYW5hZ2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZEQUF1RTtBQUV2RSx1RkFBaUY7QUFFakYsTUFBYSxtQkFBbUI7SUFDOUI7UUFJQSxrQkFBYSxHQVNULEVBQUUsQ0FBQztRQVpMLElBQUksQ0FBQyxlQUFlLENBQUMsNENBQW1CLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBYUQsYUFBYSxDQUNYLFNBQXNCLEVBQ3RCLE9BSUM7UUFFRCxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxHQUFHLE9BQU8sQ0FBQztJQUMxQyxDQUFDO0lBRUQsZUFBZSxDQUNiLFFBU0M7UUFFRCxJQUFJLENBQUMsYUFBYSxtQ0FBUSxJQUFJLENBQUMsYUFBYSxHQUFLLFFBQVEsQ0FBRSxDQUFDO0lBQzlELENBQUM7SUFFRCxhQUFhLENBQUMsS0FBa0IsRUFBRSxJQUFrQjtRQUNsRCxNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzlDLE1BQU0sRUFBRSxNQUFNLEVBQUUsYUFBYSxFQUFFLE9BQU8sRUFBRSxHQUFHLElBQUksSUFBSSxFQUFFLENBQUM7UUFFdEQsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ2pCLE9BQU87Z0JBQ0wsT0FBTyxFQUFFLG1CQUFtQjtnQkFDNUIsSUFBSSxFQUFFLEdBQUc7Z0JBQ1QsT0FBTyxFQUFFLE9BQU87YUFDakIsQ0FBQztRQUNKLENBQUM7UUFFRCxJQUFJLE9BQWUsQ0FBQztRQUNwQixNQUFNLGFBQWEsR0FBRyxhQUFhLElBQUksV0FBVyxDQUFDLE9BQU8sQ0FBQztRQUUzRCxJQUFJLE9BQU8sYUFBYSxLQUFLLFVBQVUsRUFBRSxDQUFDO1lBQ3hDLE9BQU8sR0FBRyxhQUFhLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDMUUsQ0FBQzthQUFNLENBQUM7WUFDTixPQUFPLEdBQUcsYUFBYSxDQUFDO1FBQzFCLENBQUM7UUFFRCxPQUFPLElBQUksNkJBQWEsQ0FBQyxPQUFPLEVBQUUsV0FBVyxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUU7WUFDekQsT0FBTyxFQUFFLE9BQU87U0FDakIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBbkVELGtEQW1FQyJ9