"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidFilterError = void 0;
const errorUtils_1 = require("../errorUtils");
const globals_1 = require("../globals");
const error_message_parser_1 = require("../parser/queryFilter/error-message-parser");
class InvalidFilterError extends errorUtils_1.NcSDKErrorV2 {
    constructor(info) {
        var _a;
        let message = (_a = info.message) !== null && _a !== void 0 ? _a : 'Invalid filter';
        if (info.lexingError && info.lexingError.length > 0) {
            const lexingErrorMessage = info.lexingError
                .map((k) => (0, error_message_parser_1.parseLexingError)(k))
                .join(', ');
            message = lexingErrorMessage;
        }
        else if (info.parsingError && info.parsingError.length > 0) {
            const parsingErrorMessage = info.parsingError
                .map((k) => (0, error_message_parser_1.parseParsingError)(k))
                .join(', ');
            message = parsingErrorMessage;
        }
        super({
            message,
            error: globals_1.NcErrorType.ERR_INVALID_FILTER,
            getStatus: () => 422,
        });
        this.innerInfo = info;
    }
}
exports.InvalidFilterError = InvalidFilterError;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW52YWxpZC1maWx0ZXIuZXJyb3IuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL2Vycm9yL2ludmFsaWQtZmlsdGVyLmVycm9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLDhDQUE2QztBQUM3Qyx3Q0FBeUM7QUFDekMscUZBR29EO0FBT3BELE1BQWEsa0JBQW1CLFNBQVEseUJBQVk7SUFDbEQsWUFBWSxJQUE0Qjs7UUFDdEMsSUFBSSxPQUFPLEdBQUcsTUFBQSxJQUFJLENBQUMsT0FBTyxtQ0FBSSxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLElBQUksQ0FBQyxXQUFXLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDcEQsTUFBTSxrQkFBa0IsR0FBRyxJQUFJLENBQUMsV0FBVztpQkFDeEMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxJQUFBLHVDQUFnQixFQUFDLENBQUMsQ0FBQyxDQUFDO2lCQUMvQixJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDZCxPQUFPLEdBQUcsa0JBQWtCLENBQUM7UUFDL0IsQ0FBQzthQUFNLElBQUksSUFBSSxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUM3RCxNQUFNLG1CQUFtQixHQUFHLElBQUksQ0FBQyxZQUFZO2lCQUMxQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLElBQUEsd0NBQWlCLEVBQUMsQ0FBQyxDQUFDLENBQUM7aUJBQ2hDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNkLE9BQU8sR0FBRyxtQkFBbUIsQ0FBQztRQUNoQyxDQUFDO1FBQ0QsS0FBSyxDQUFDO1lBQ0osT0FBTztZQUNQLEtBQUssRUFBRSxxQkFBVyxDQUFDLGtCQUFrQjtZQUNyQyxTQUFTLEVBQUUsR0FBRyxFQUFFLENBQUMsR0FBRztTQUNyQixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQztJQUN4QixDQUFDO0NBRUY7QUF0QkQsZ0RBc0JDIn0=