"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NcBaseErrorv2 = exports.TestConnectionError = exports.UniqueConstraintViolationError = exports.OptionsNotExistsError = exports.UnprocessableEntity = exports.ExternalTimeout = exports.ExternalError = exports.MetaError = exports.SsoError = exports.NotFound = exports.Forbidden = exports.Unauthorized = exports.NotAllowed = exports.BadRequestV2 = exports.NcBaseError = void 0;
class NcBaseError extends Error {
    constructor(message) {
        super(message);
    }
}
exports.NcBaseError = NcBaseError;
class BadRequestV2 extends NcBaseError {
}
exports.BadRequestV2 = BadRequestV2;
class NotAllowed extends NcBaseError {
}
exports.NotAllowed = NotAllowed;
class Unauthorized extends NcBaseError {
}
exports.Unauthorized = Unauthorized;
class Forbidden extends NcBaseError {
}
exports.Forbidden = Forbidden;
class NotFound extends NcBaseError {
}
exports.NotFound = NotFound;
class SsoError extends NcBaseError {
}
exports.SsoError = SsoError;
class MetaError extends NcBaseError {
    constructor(param) {
        super(param.message);
        Object.assign(this, param);
    }
}
exports.MetaError = MetaError;
class ExternalError extends NcBaseError {
    constructor(error) {
        super(error.message);
        Object.assign(this, error);
    }
}
exports.ExternalError = ExternalError;
class ExternalTimeout extends ExternalError {
}
exports.ExternalTimeout = ExternalTimeout;
class UnprocessableEntity extends NcBaseError {
}
exports.UnprocessableEntity = UnprocessableEntity;
class OptionsNotExistsError extends BadRequestV2 {
    constructor({ columnTitle, options, validOptions, }) {
        super(`Invalid option(s) "${options.join(', ')}" provided for column "${columnTitle}". Valid options are "${validOptions.join(', ')}"`);
        this.columnTitle = columnTitle;
        this.options = options;
        this.validOptions = validOptions;
    }
}
exports.OptionsNotExistsError = OptionsNotExistsError;
class UniqueConstraintViolationError extends BadRequestV2 {
    constructor({ value, fieldName }) {
        let message = `${fieldName} field unique constraint violation. Value '${value}' already exists.`;
        if (value === 'unknown') {
            message = `${fieldName} field unique constraint violation.`;
        }
        super(message);
        this.value = value;
        this.fieldName = fieldName;
    }
}
exports.UniqueConstraintViolationError = UniqueConstraintViolationError;
class TestConnectionError extends NcBaseError {
    constructor(message, sql_code) {
        super(message);
        this.sql_code = sql_code;
    }
}
exports.TestConnectionError = TestConnectionError;
class NcBaseErrorv2 extends NcBaseError {
    constructor(message, code, error, args) {
        super(message);
        this.error = error;
        this.code = code;
        this.details = args === null || args === void 0 ? void 0 : args.details;
    }
}
exports.NcBaseErrorv2 = NcBaseErrorv2;
//# sourceMappingURL=data:application/json;base64,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