import UITypes from '../../lib/UITypes';
import type { Api, ColumnType, FilterType } from '../../lib/Api';
export interface ComparisonOpUiType {
    text: string;
    value: string;
    ignoreVal: boolean;
    includedTypes?: UITypes[];
    excludedTypes?: UITypes[];
    semanticType?: string;
    typeSpecificSemantic?: (fieldUiType: UITypes) => string;
}
export interface FilterGroupChangeEvent {
    filters: ColumnFilterType[];
    filter: ColumnFilterType | null;
    type: 'row_changed' | 'add' | 'delete';
    parentFilter?: ColumnFilterType;
    fk_parent_id?: string;
    prevValue?: any;
    value: any;
    index: number;
}
export interface FilterRowChangeEvent {
    filter: ColumnFilterType;
    type: 'logical_op' | 'fk_column_id' | 'fk_value_col_id' | 'comparison_op' | 'comparison_sub_op' | 'value' | 'dynamic' | 'child_add' | 'child_delete' | 'order';
    prevValue: any;
    value: any;
    index: number;
}
export type ColumnTypeForFilter = ColumnType & {
    btLookupColumn?: ColumnTypeForFilter;
    filterUidt?: UITypes;
};
export declare function isDateType(uidt: UITypes): boolean;
export declare const comparisonOpList: (fieldUiType: UITypes, _dateFormat?: string) => ComparisonOpUiType[];
export declare const comparisonSubOpList: (comparison_op: string, dateFormat?: string) => ComparisonOpUiType[];
export declare const getPlaceholderNewRow: (filters: Filter[], columns: ColumnType[], option?: {
    currentUser?: {
        email: string;
        id: string;
    };
}) => Record<string, any>;
export declare const isComparisonOpAllowed: (filter: ColumnFilterType, compOp: {
    text: string;
    value: string;
    ignoreVal?: boolean;
    includedTypes?: UITypes[];
    excludedTypes?: UITypes[];
}, uidt?: UITypes, showNullAndEmptyInFilter?: boolean) => boolean;
export declare const getFilterCount: (filters: FilterType[]) => number;
export declare const deleteFilterWithSub: ($api: Api<unknown>, filter: FilterType) => Promise<string[]>;
export type Filter = FilterType;
export type ColumnFilterType = FilterType & {
    tmp_id?: string;
};
