"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteFilterWithSub = exports.getFilterCount = exports.isComparisonOpAllowed = exports.getPlaceholderNewRow = exports.comparisonSubOpList = exports.comparisonOpList = void 0;
exports.isDateType = isDateType;
const UITypes_1 = __importStar(require("../../lib/UITypes"));
const dateTimeHelper_1 = require("../../lib/dateTimeHelper");
const helperFunctions_1 = require("../../lib/helperFunctions");
function isDateType(uidt) {
    return [
        UITypes_1.default.Date,
        UITypes_1.default.DateTime,
        UITypes_1.default.CreatedTime,
        UITypes_1.default.LastModifiedTime,
    ].includes(uidt);
}
const getEqText = (fieldUiType) => {
    if ((0, UITypes_1.isNumericCol)(fieldUiType) || fieldUiType === UITypes_1.default.Time) {
        return '=';
    }
    else if ([
        UITypes_1.default.SingleSelect,
        UITypes_1.default.Collaborator,
        UITypes_1.default.LinkToAnotherRecord,
        UITypes_1.default.Date,
        UITypes_1.default.CreatedTime,
        UITypes_1.default.LastModifiedTime,
        UITypes_1.default.DateTime,
    ].includes(fieldUiType)) {
        return 'is';
    }
    return 'is equal';
};
const getNeqText = (fieldUiType) => {
    if ((0, UITypes_1.isNumericCol)(fieldUiType) || fieldUiType === UITypes_1.default.Time) {
        return '!=';
    }
    else if ([
        UITypes_1.default.SingleSelect,
        UITypes_1.default.Collaborator,
        UITypes_1.default.LinkToAnotherRecord,
        UITypes_1.default.Date,
        UITypes_1.default.CreatedTime,
        UITypes_1.default.LastModifiedTime,
        UITypes_1.default.DateTime,
    ].includes(fieldUiType)) {
        return 'is not';
    }
    return 'is not equal';
};
const getLikeText = (fieldUiType) => {
    if (fieldUiType === UITypes_1.default.Attachment) {
        return 'filenames contain';
    }
    return 'is like';
};
const getNotLikeText = (fieldUiType) => {
    if (fieldUiType === UITypes_1.default.Attachment) {
        return "filenames don't contain";
    }
    return 'is not like';
};
const getGtText = (fieldUiType) => {
    if ([
        UITypes_1.default.Date,
        UITypes_1.default.DateTime,
        UITypes_1.default.CreatedTime,
        UITypes_1.default.LastModifiedTime,
    ].includes(fieldUiType)) {
        return 'is after';
    }
    return '>';
};
const getLtText = (fieldUiType) => {
    if ([
        UITypes_1.default.Date,
        UITypes_1.default.DateTime,
        UITypes_1.default.CreatedTime,
        UITypes_1.default.LastModifiedTime,
    ].includes(fieldUiType)) {
        return 'is before';
    }
    return '<';
};
const getGteText = (fieldUiType) => {
    if ([
        UITypes_1.default.Date,
        UITypes_1.default.DateTime,
        UITypes_1.default.CreatedTime,
        UITypes_1.default.LastModifiedTime,
    ].includes(fieldUiType)) {
        return 'is on or after';
    }
    return '>=';
};
const getLteText = (fieldUiType) => {
    if ([
        UITypes_1.default.Date,
        UITypes_1.default.DateTime,
        UITypes_1.default.CreatedTime,
        UITypes_1.default.LastModifiedTime,
    ].includes(fieldUiType)) {
        return 'is on or before';
    }
    return '<=';
};
// Helper functions for type-specific semantic types
const getTypeSpecificSemantic = (baseSemantic, fieldUiType) => {
    if ((0, UITypes_1.isNumericCol)(fieldUiType)) {
        return `${baseSemantic}_numeric`;
    }
    else if (isDateType(fieldUiType)) {
        return `${baseSemantic}_date`;
    }
    else if ([
        UITypes_1.default.SingleLineText,
        UITypes_1.default.LongText,
        UITypes_1.default.Email,
        UITypes_1.default.PhoneNumber,
        UITypes_1.default.URL,
    ].includes(fieldUiType)) {
        return `${baseSemantic}_text`;
    }
    else if ([UITypes_1.default.SingleSelect, UITypes_1.default.MultiSelect].includes(fieldUiType)) {
        return `${baseSemantic}_select`;
    }
    else if ([UITypes_1.default.Checkbox].includes(fieldUiType)) {
        return `${baseSemantic}_boolean`;
    }
    else if ([UITypes_1.default.User, UITypes_1.default.CreatedBy, UITypes_1.default.LastModifiedBy].includes(fieldUiType)) {
        return `${baseSemantic}_user`;
    }
    else if ([UITypes_1.default.Attachment].includes(fieldUiType)) {
        return `${baseSemantic}_attachment`;
    }
    else if ([UITypes_1.default.LinkToAnotherRecord, UITypes_1.default.Lookup].includes(fieldUiType)) {
        return `${baseSemantic}_link`;
    }
    return baseSemantic; // fallback to base semantic
};
const comparisonOpList = (fieldUiType, _dateFormat) => [
    {
        text: 'is checked',
        value: 'checked',
        ignoreVal: true,
        includedTypes: [UITypes_1.default.Checkbox],
        semanticType: 'boolean_equality',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('equality', fieldUiType),
    },
    {
        text: 'is not checked',
        value: 'notchecked',
        ignoreVal: true,
        includedTypes: [UITypes_1.default.Checkbox],
        semanticType: 'boolean_inequality',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('inequality', fieldUiType),
    },
    {
        text: getEqText(fieldUiType),
        value: 'eq',
        ignoreVal: false,
        excludedTypes: [
            UITypes_1.default.Checkbox,
            UITypes_1.default.MultiSelect,
            UITypes_1.default.Attachment,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
        ],
        semanticType: 'equality',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('equality', fieldUiType),
    },
    {
        text: getNeqText(fieldUiType),
        value: 'neq',
        ignoreVal: false,
        excludedTypes: [
            UITypes_1.default.Checkbox,
            UITypes_1.default.MultiSelect,
            UITypes_1.default.Attachment,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
        ],
        semanticType: 'inequality',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('inequality', fieldUiType),
    },
    {
        text: getLikeText(fieldUiType),
        value: 'like',
        ignoreVal: false,
        excludedTypes: [
            UITypes_1.default.Checkbox,
            UITypes_1.default.SingleSelect,
            UITypes_1.default.MultiSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
            UITypes_1.default.Collaborator,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.Time,
            ...UITypes_1.numericUITypes,
        ],
        semanticType: 'pattern_match',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('pattern_match', fieldUiType),
    },
    {
        text: getNotLikeText(fieldUiType),
        value: 'nlike',
        ignoreVal: false,
        excludedTypes: [
            UITypes_1.default.Checkbox,
            UITypes_1.default.SingleSelect,
            UITypes_1.default.MultiSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
            UITypes_1.default.Collaborator,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.Time,
            ...UITypes_1.numericUITypes,
        ],
        semanticType: 'pattern_not_match',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('pattern_not_match', fieldUiType),
    },
    {
        text: 'is empty',
        value: 'empty',
        ignoreVal: true,
        excludedTypes: [
            UITypes_1.default.Checkbox,
            UITypes_1.default.SingleSelect,
            UITypes_1.default.MultiSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
            UITypes_1.default.Collaborator,
            UITypes_1.default.Attachment,
            UITypes_1.default.LinkToAnotherRecord,
            UITypes_1.default.Lookup,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.Time,
            ...UITypes_1.numericUITypes,
        ],
        semanticType: 'empty_check',
    },
    {
        text: 'is not empty',
        value: 'notempty',
        ignoreVal: true,
        excludedTypes: [
            UITypes_1.default.Checkbox,
            UITypes_1.default.SingleSelect,
            UITypes_1.default.MultiSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
            UITypes_1.default.Collaborator,
            UITypes_1.default.Attachment,
            UITypes_1.default.LinkToAnotherRecord,
            UITypes_1.default.Lookup,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.Time,
            ...UITypes_1.numericUITypes,
        ],
        semanticType: 'not_empty_check',
    },
    {
        text: 'is null',
        value: 'null',
        ignoreVal: true,
        excludedTypes: [
            ...UITypes_1.numericUITypes,
            UITypes_1.default.Checkbox,
            UITypes_1.default.SingleSelect,
            UITypes_1.default.MultiSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
            UITypes_1.default.Collaborator,
            UITypes_1.default.Attachment,
            UITypes_1.default.LinkToAnotherRecord,
            UITypes_1.default.Lookup,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.Time,
        ],
        semanticType: 'null_check',
    },
    {
        text: 'is not null',
        value: 'notnull',
        ignoreVal: true,
        excludedTypes: [
            ...UITypes_1.numericUITypes,
            UITypes_1.default.Checkbox,
            UITypes_1.default.SingleSelect,
            UITypes_1.default.MultiSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
            UITypes_1.default.Collaborator,
            UITypes_1.default.Attachment,
            UITypes_1.default.LinkToAnotherRecord,
            UITypes_1.default.Lookup,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.Time,
        ],
        semanticType: 'not_null_check',
    },
    {
        text: 'contains all of',
        value: 'allof',
        ignoreVal: false,
        includedTypes: [
            UITypes_1.default.MultiSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
        ],
        semanticType: 'contains_all',
    },
    {
        text: 'contains any of',
        value: 'anyof',
        ignoreVal: false,
        includedTypes: [
            UITypes_1.default.MultiSelect,
            UITypes_1.default.SingleSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
        ],
        semanticType: 'contains_any',
    },
    {
        text: 'does not contain all of',
        value: 'nallof',
        ignoreVal: false,
        includedTypes: [
            UITypes_1.default.MultiSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
        ],
        semanticType: 'not_contains_all',
    },
    {
        text: 'does not contain any of',
        value: 'nanyof',
        ignoreVal: false,
        includedTypes: [
            UITypes_1.default.MultiSelect,
            UITypes_1.default.SingleSelect,
            UITypes_1.default.User,
            UITypes_1.default.CreatedBy,
            UITypes_1.default.LastModifiedBy,
        ],
        semanticType: 'not_contains_any',
    },
    {
        text: getGtText(fieldUiType),
        value: 'gt',
        ignoreVal: false,
        includedTypes: [
            ...UITypes_1.numericUITypes,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.Time,
        ],
        semanticType: 'greater_than',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('greater_than', fieldUiType),
    },
    {
        text: getLtText(fieldUiType),
        value: 'lt',
        ignoreVal: false,
        includedTypes: [
            ...UITypes_1.numericUITypes,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.Time,
        ],
        semanticType: 'less_than',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('less_than', fieldUiType),
    },
    {
        text: getGteText(fieldUiType),
        value: 'gte',
        ignoreVal: false,
        includedTypes: [
            ...UITypes_1.numericUITypes,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.Time,
        ],
        semanticType: 'greater_than_or_equal',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('greater_than_or_equal', fieldUiType),
    },
    {
        text: getLteText(fieldUiType),
        value: 'lte',
        ignoreVal: false,
        includedTypes: [
            ...UITypes_1.numericUITypes,
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.Time,
            UITypes_1.default.CreatedTime,
            UITypes_1.default.LastModifiedTime,
        ],
        semanticType: 'less_than_or_equal',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('less_than_or_equal', fieldUiType),
    },
    {
        text: 'is within',
        value: 'isWithin',
        ignoreVal: true,
        includedTypes: [
            UITypes_1.default.Date,
            UITypes_1.default.DateTime,
            UITypes_1.default.LastModifiedTime,
            UITypes_1.default.CreatedTime,
        ],
        semanticType: 'date_range',
    },
    {
        text: 'is blank',
        value: 'blank',
        ignoreVal: true,
        excludedTypes: [UITypes_1.default.Checkbox, UITypes_1.default.Links, UITypes_1.default.Rollup],
        semanticType: 'blank_check',
    },
    {
        text: 'is not blank',
        value: 'notblank',
        ignoreVal: true,
        excludedTypes: [UITypes_1.default.Checkbox, UITypes_1.default.Links, UITypes_1.default.Rollup],
        semanticType: 'not_blank_check',
    },
];
exports.comparisonOpList = comparisonOpList;
const comparisonSubOpList = (
// TODO: type
comparison_op, dateFormat) => {
    const isDateMonth = dateFormat && (0, dateTimeHelper_1.isDateMonthFormat)(dateFormat);
    if (comparison_op === 'isWithin') {
        return [
            {
                text: 'the past week',
                value: 'pastWeek',
                ignoreVal: true,
                includedTypes: [
                    UITypes_1.default.Date,
                    UITypes_1.default.DateTime,
                    UITypes_1.default.LastModifiedTime,
                    UITypes_1.default.CreatedTime,
                ],
            },
            {
                text: 'the past month',
                value: 'pastMonth',
                ignoreVal: true,
                includedTypes: [
                    UITypes_1.default.Date,
                    UITypes_1.default.DateTime,
                    UITypes_1.default.LastModifiedTime,
                    UITypes_1.default.CreatedTime,
                ],
            },
            {
                text: 'the past year',
                value: 'pastYear',
                ignoreVal: true,
                includedTypes: [
                    UITypes_1.default.Date,
                    UITypes_1.default.DateTime,
                    UITypes_1.default.LastModifiedTime,
                    UITypes_1.default.CreatedTime,
                ],
            },
            {
                text: 'the next week',
                value: 'nextWeek',
                ignoreVal: true,
                includedTypes: [
                    UITypes_1.default.Date,
                    UITypes_1.default.DateTime,
                    UITypes_1.default.LastModifiedTime,
                    UITypes_1.default.CreatedTime,
                ],
            },
            {
                text: 'the next month',
                value: 'nextMonth',
                ignoreVal: true,
                includedTypes: [
                    UITypes_1.default.Date,
                    UITypes_1.default.DateTime,
                    UITypes_1.default.LastModifiedTime,
                    UITypes_1.default.CreatedTime,
                ],
            },
            {
                text: 'the next year',
                value: 'nextYear',
                ignoreVal: true,
                includedTypes: [
                    UITypes_1.default.Date,
                    UITypes_1.default.DateTime,
                    UITypes_1.default.LastModifiedTime,
                    UITypes_1.default.CreatedTime,
                ],
            },
            {
                text: 'the next number of days',
                value: 'nextNumberOfDays',
                ignoreVal: false,
                includedTypes: [
                    UITypes_1.default.Date,
                    UITypes_1.default.DateTime,
                    UITypes_1.default.LastModifiedTime,
                    UITypes_1.default.CreatedTime,
                ],
            },
            {
                text: 'the past number of days',
                value: 'pastNumberOfDays',
                ignoreVal: false,
                includedTypes: [
                    UITypes_1.default.Date,
                    UITypes_1.default.DateTime,
                    UITypes_1.default.LastModifiedTime,
                    UITypes_1.default.CreatedTime,
                ],
            },
        ];
    }
    return [
        {
            text: 'today',
            value: 'today',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes_1.default.Date,
                        UITypes_1.default.DateTime,
                        UITypes_1.default.LastModifiedTime,
                        UITypes_1.default.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'tomorrow',
            value: 'tomorrow',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes_1.default.Date,
                        UITypes_1.default.DateTime,
                        UITypes_1.default.LastModifiedTime,
                        UITypes_1.default.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'yesterday',
            value: 'yesterday',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes_1.default.Date,
                        UITypes_1.default.DateTime,
                        UITypes_1.default.LastModifiedTime,
                        UITypes_1.default.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'one week ago',
            value: 'oneWeekAgo',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes_1.default.Date,
                        UITypes_1.default.DateTime,
                        UITypes_1.default.LastModifiedTime,
                        UITypes_1.default.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'one week from now',
            value: 'oneWeekFromNow',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes_1.default.Date,
                        UITypes_1.default.DateTime,
                        UITypes_1.default.LastModifiedTime,
                        UITypes_1.default.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'one month ago',
            value: 'oneMonthAgo',
            ignoreVal: true,
            includedTypes: [
                UITypes_1.default.Date,
                UITypes_1.default.DateTime,
                UITypes_1.default.LastModifiedTime,
                UITypes_1.default.CreatedTime,
            ],
        },
        {
            text: 'one month from now',
            value: 'oneMonthFromNow',
            ignoreVal: true,
            includedTypes: [
                UITypes_1.default.Date,
                UITypes_1.default.DateTime,
                UITypes_1.default.LastModifiedTime,
                UITypes_1.default.CreatedTime,
            ],
        },
        {
            text: 'number of days ago',
            value: 'daysAgo',
            ignoreVal: false,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes_1.default.Date,
                        UITypes_1.default.DateTime,
                        UITypes_1.default.LastModifiedTime,
                        UITypes_1.default.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'number of days from now',
            value: 'daysFromNow',
            ignoreVal: false,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes_1.default.Date,
                        UITypes_1.default.DateTime,
                        UITypes_1.default.LastModifiedTime,
                        UITypes_1.default.CreatedTime,
                    ]),
            ],
        },
        {
            text: isDateMonth ? 'exact month' : 'exact date',
            value: 'exactDate',
            ignoreVal: false,
            includedTypes: [
                UITypes_1.default.Date,
                UITypes_1.default.DateTime,
                UITypes_1.default.LastModifiedTime,
                UITypes_1.default.CreatedTime,
            ],
        },
    ];
};
exports.comparisonSubOpList = comparisonSubOpList;
const getPlaceholderNewRow = (filters, columns, option) => {
    var _a, _b, _c;
    if (filters.some((filter) => filter.logical_op === 'or')) {
        return {};
    }
    const placeholderNewRow = {};
    for (const eachFilter of filters) {
        if (['checked', 'notchecked', 'allof', 'eq'].includes(eachFilter.comparison_op)) {
            const column = columns.find((col) => col.id === eachFilter.fk_column_id);
            if (column) {
                if ([
                    UITypes_1.default.Number,
                    UITypes_1.default.Decimal,
                    UITypes_1.default.SingleLineText,
                    UITypes_1.default.LongText,
                    UITypes_1.default.SingleSelect,
                    UITypes_1.default.GeoData,
                    UITypes_1.default.Email,
                    UITypes_1.default.PhoneNumber,
                    UITypes_1.default.URL,
                    UITypes_1.default.Time,
                    UITypes_1.default.Year,
                    UITypes_1.default.Currency,
                    UITypes_1.default.Percent,
                    UITypes_1.default.Rating,
                    UITypes_1.default.Duration,
                    UITypes_1.default.JSON,
                    // User is using allOf and anyOf so we cannot include it here
                    // UITypes.User,
                ].includes(column.uidt) ||
                    ([UITypes_1.default.Date, UITypes_1.default.DateTime].includes(column.uidt) &&
                        eachFilter.comparison_sub_op === 'exactDate')) {
                    placeholderNewRow[column.title] = eachFilter.value;
                }
                else if ([UITypes_1.default.Checkbox].includes(column.uidt) &&
                    ['checked', 'notchecked'].includes(eachFilter.comparison_op)) {
                    placeholderNewRow[column.title] =
                        eachFilter.comparison_op === 'checked';
                }
                else if ([UITypes_1.default.MultiSelect].includes(column.uidt) &&
                    ['allof'].includes(eachFilter.comparison_op)) {
                    placeholderNewRow[column.title] = eachFilter.value;
                }
                else if ([UITypes_1.default.User].includes(column.uidt) &&
                    ['allof'].includes(eachFilter.comparison_op)) {
                    const isMulti = (_a = (0, helperFunctions_1.parseProp)(column.meta)) === null || _a === void 0 ? void 0 : _a.is_multi;
                    if (isMulti || ((_c = (_b = eachFilter.value) === null || _b === void 0 ? void 0 : _b.indexOf) === null || _c === void 0 ? void 0 : _c.call(_b, ',')) < 0) {
                        const assignedValue = eachFilter.value
                            .split(',')
                            .map((k) => { var _a; return (k === '@me' ? (_a = option === null || option === void 0 ? void 0 : option.currentUser) === null || _a === void 0 ? void 0 : _a.id : k); })
                            .filter((k) => k)
                            .join(',');
                        placeholderNewRow[column.title] = assignedValue;
                    }
                }
            }
        }
    }
    return placeholderNewRow;
};
exports.getPlaceholderNewRow = getPlaceholderNewRow;
const isComparisonOpAllowed = (filter, compOp, uidt, showNullAndEmptyInFilter) => {
    const isNullOrEmptyOp = ['empty', 'notempty', 'null', 'notnull'].includes(compOp.value);
    if (compOp.includedTypes) {
        // include allowed values only if selected column type matches
        if (filter.fk_column_id && compOp.includedTypes.includes(uidt)) {
            // for 'empty', 'notempty', 'null', 'notnull',
            // show them based on `showNullAndEmptyInFilter` in Base Settings
            return isNullOrEmptyOp ? showNullAndEmptyInFilter : true;
        }
        else {
            return false;
        }
    }
    else if (compOp.excludedTypes) {
        // include not allowed values only if selected column type not matches
        if (filter.fk_column_id && !compOp.excludedTypes.includes(uidt)) {
            // for 'empty', 'notempty', 'null', 'notnull',
            // show them based on `showNullAndEmptyInFilter` in Base Settings
            return isNullOrEmptyOp ? showNullAndEmptyInFilter : true;
        }
        else {
            return false;
        }
    }
    // explicitly include for non-null / non-empty ops
    return isNullOrEmptyOp ? showNullAndEmptyInFilter : true;
};
exports.isComparisonOpAllowed = isComparisonOpAllowed;
const getFilterCount = (filters) => {
    var _a;
    let result = 0;
    for (const filter of filters) {
        if (filter.is_group) {
            result += (0, exports.getFilterCount)((_a = filter.children) !== null && _a !== void 0 ? _a : []);
        }
        else {
            result += 1;
        }
    }
    return result;
};
exports.getFilterCount = getFilterCount;
const deleteFilterWithSub = async ($api, filter) => {
    var _a;
    let result = [];
    if (filter.is_group && ((_a = filter.children) === null || _a === void 0 ? void 0 : _a.length) > 0) {
        for (const child of filter.children) {
            result = [...result, ...(await (0, exports.deleteFilterWithSub)($api, child))];
        }
    }
    await $api.dbTableFilter.delete(filter.id);
    result.push(filter.id);
    return result;
};
exports.deleteFilterWithSub = deleteFilterWithSub;
//# sourceMappingURL=data:application/json;base64,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