"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateRowFilters = validateRowFilters;
const dayjs_1 = __importStar(require("dayjs"));
const customParseFormat_js_1 = __importDefault(require("dayjs/plugin/customParseFormat.js"));
const isBetween_1 = __importDefault(require("dayjs/plugin/isBetween"));
const isSameOrAfter_1 = __importDefault(require("dayjs/plugin/isSameOrAfter"));
const isSameOrBefore_1 = __importDefault(require("dayjs/plugin/isSameOrBefore"));
const relativeTime_js_1 = __importDefault(require("dayjs/plugin/relativeTime.js"));
const utc_js_1 = __importDefault(require("dayjs/plugin/utc.js"));
const timezone_js_1 = __importDefault(require("dayjs/plugin/timezone.js"));
const dateTimeHelper_1 = require("../../lib/dateTimeHelper");
const filterHelpers_1 = require("../../lib/filterHelpers");
const helperFunctions_1 = require("../../lib/helperFunctions");
const UITypes_1 = __importDefault(require("../../lib/UITypes"));
const get_lookup_column_type_1 = require("../../lib/columnHelper/utils/get-lookup-column-type");
const timezoneUtils_1 = require("../../lib/timezoneUtils");
const column_helper_1 = require("../../lib/columnHelper/column-helper");
const globals_1 = require("../../lib/globals");
const metaHelpers_1 = require("../../lib/helpers/metaHelpers");
(0, dayjs_1.extend)(utc_js_1.default);
(0, dayjs_1.extend)(timezone_js_1.default);
(0, dayjs_1.extend)(relativeTime_js_1.default);
(0, dayjs_1.extend)(customParseFormat_js_1.default);
(0, dayjs_1.extend)(isSameOrBefore_1.default);
(0, dayjs_1.extend)(isSameOrAfter_1.default);
(0, dayjs_1.extend)(isBetween_1.default);
const ncToString = (value) => {
    var _a;
    return ((_a = value === null || value === void 0 ? void 0 : value.toString) === null || _a === void 0 ? void 0 : _a.call(value)) || '';
};
function validateRowFilters(params) {
    var _a, _b, _c, _d, _e, _f, _g;
    const { filters: _filters, data = {}, columns = [], client, metas, baseId, } = params;
    if (!_filters.length) {
        return true;
    }
    const filters = (0, filterHelpers_1.buildFilterTree)(_filters);
    let isValid = null;
    for (const filter of filters) {
        let res;
        if (filter.is_group && ((_a = filter.children) === null || _a === void 0 ? void 0 : _a.length)) {
            res = validateRowFilters({
                filters: filter.children,
                data: data,
                columns: columns,
                client: client,
                metas: metas,
                baseId: baseId,
            });
        }
        else {
            const column = columns.find((c) => c.id === filter.fk_column_id);
            if (!column) {
                continue;
            }
            const field = column.title;
            let val = data[field];
            if ([
                UITypes_1.default.Date,
                UITypes_1.default.DateTime,
                UITypes_1.default.CreatedTime,
                UITypes_1.default.LastModifiedTime,
            ].includes(column.uidt) &&
                !['empty', 'blank', 'notempty', 'notblank'].includes(filter.comparison_op)) {
                const getTimezone = () => {
                    var _a;
                    return (0, timezoneUtils_1.getNodejsTimezone)((0, helperFunctions_1.parseProp)(filter.meta).timezone, (0, helperFunctions_1.parseProp)(column.meta).timezone, (_a = params.options) === null || _a === void 0 ? void 0 : _a.timezone);
                };
                const dateFormat = client === 'mysql2' ? 'YYYY-MM-DD HH:mm:ss' : 'YYYY-MM-DD HH:mm:ssZ';
                let now = dayjs_1.default.tz(new Date(), getTimezone());
                const dateFormatFromMeta = (_b = (0, helperFunctions_1.parseProp)(column.meta)) === null || _b === void 0 ? void 0 : _b.date_format;
                const dataVal = val;
                let filterVal = filter.value;
                if (dateFormatFromMeta && (0, dateTimeHelper_1.isDateMonthFormat)(dateFormatFromMeta)) {
                    // reset to 1st
                    now = now.date(1);
                    if (val)
                        val = dayjs_1.default.tz(val, getTimezone()).date(1);
                }
                if (filterVal)
                    res = dayjs_1.default.tz(filterVal, getTimezone()).isSame(dataVal, 'day');
                // handle sub operation
                switch (filter.comparison_sub_op) {
                    case 'today':
                        filterVal = now;
                        break;
                    case 'tomorrow':
                        filterVal = now.add(1, 'day');
                        break;
                    case 'yesterday':
                        filterVal = now.add(-1, 'day');
                        break;
                    case 'oneWeekAgo':
                        filterVal = now.add(-1, 'week');
                        break;
                    case 'oneWeekFromNow':
                        filterVal = now.add(1, 'week');
                        break;
                    case 'oneMonthAgo':
                        filterVal = now.add(-1, 'month');
                        break;
                    case 'oneMonthFromNow':
                        filterVal = now.add(1, 'month');
                        break;
                    case 'daysAgo':
                        if (!filterVal)
                            return null;
                        filterVal = now.add(-filterVal, 'day');
                        break;
                    case 'daysFromNow':
                        if (!filterVal)
                            return null;
                        filterVal = now.add(filterVal, 'day');
                        break;
                    case 'exactDate':
                        if (!filterVal)
                            return null;
                        break;
                    // sub-ops for `isWithin` comparison
                    case 'pastWeek':
                        filterVal = now.add(-1, 'week');
                        break;
                    case 'pastMonth':
                        filterVal = now.add(-1, 'month');
                        break;
                    case 'pastYear':
                        filterVal = now.add(-1, 'year');
                        break;
                    case 'nextWeek':
                        filterVal = now.add(1, 'week');
                        break;
                    case 'nextMonth':
                        filterVal = now.add(1, 'month');
                        break;
                    case 'nextYear':
                        filterVal = now.add(1, 'year');
                        break;
                    case 'pastNumberOfDays':
                        if (!filterVal)
                            return null;
                        filterVal = now.add(-filterVal, 'day');
                        break;
                    case 'nextNumberOfDays':
                        if (!filterVal)
                            return null;
                        filterVal = now.add(filterVal, 'day');
                        break;
                }
                if (dataVal) {
                    switch (filter.comparison_op) {
                        case 'eq':
                        case 'gb_eq':
                            res = dayjs_1.default
                                .utc(dataVal)
                                .tz(getTimezone())
                                .isSame(filterVal, 'day');
                            break;
                        case 'neq':
                            res = !dayjs_1.default
                                .utc(dataVal)
                                .tz(getTimezone())
                                .isSame(filterVal, 'day');
                            break;
                        case 'gt':
                            res = dayjs_1.default
                                .utc(dataVal)
                                .tz(getTimezone())
                                .isAfter(filterVal, 'day');
                            break;
                        case 'lt':
                            res = dayjs_1.default
                                .utc(dataVal)
                                .tz(getTimezone())
                                .isBefore(filterVal, 'day');
                            break;
                        case 'lte':
                        case 'le':
                            res = dayjs_1.default
                                .utc(dataVal)
                                .tz(getTimezone())
                                .isSameOrBefore(filterVal, 'day');
                            break;
                        case 'gte':
                        case 'ge':
                            res = dayjs_1.default
                                .utc(dataVal)
                                .tz(getTimezone())
                                .isSameOrAfter(filterVal, 'day');
                            break;
                        case 'empty':
                        case 'blank':
                            res = dataVal === '' || dataVal === null || dataVal === undefined;
                            break;
                        case 'notempty':
                        case 'notblank':
                            res = !(dataVal === '' ||
                                dataVal === null ||
                                dataVal === undefined);
                            break;
                        case 'isWithin': {
                            let now = dayjs_1.default
                                .tz(new Date(), getTimezone())
                                .format(dateFormat)
                                .toString();
                            now = column.uidt === UITypes_1.default.Date ? now.substring(0, 10) : now;
                            switch (filter.comparison_sub_op) {
                                case 'pastWeek':
                                case 'pastMonth':
                                case 'pastYear':
                                case 'pastNumberOfDays': {
                                    // the 'today' need to be included, hence we don't use isBetween
                                    const dataValDayjs = dayjs_1.default.utc(dataVal).tz(getTimezone());
                                    res =
                                        dataValDayjs.isSameOrAfter(filterVal, 'day') &&
                                            dataValDayjs.isSameOrBefore(now, 'day');
                                    break;
                                }
                                case 'nextWeek':
                                case 'nextMonth':
                                case 'nextYear':
                                case 'nextNumberOfDays': {
                                    // the 'today' need to be included, hence we don't use isBetween
                                    const dataValDayjs = dayjs_1.default.utc(dataVal).tz(getTimezone());
                                    res =
                                        dataValDayjs.isSameOrAfter(now, 'day') &&
                                            dataValDayjs.isSameOrBefore(filterVal, 'day');
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            else {
                switch (typeof filter.value) {
                    case 'boolean':
                        val = !!data[field];
                        break;
                    case 'number':
                        val = +data[field];
                        break;
                }
                if ([UITypes_1.default.User, UITypes_1.default.CreatedBy, UITypes_1.default.LastModifiedBy].includes(column.uidt) ||
                    (column.uidt === UITypes_1.default.Lookup &&
                        [UITypes_1.default.User, UITypes_1.default.CreatedBy, UITypes_1.default.LastModifiedBy].includes((0, get_lookup_column_type_1.getLookupColumnType)({
                            col: column,
                            meta: { columns, base_id: baseId },
                            metas: metas,
                            baseId: baseId,
                        })))) {
                    const userIds = Array.isArray(data[field])
                        ? data[field].map((user) => user.id)
                        : ((_c = data[field]) === null || _c === void 0 ? void 0 : _c.id)
                            ? [data[field].id]
                            : [];
                    const filterValues = (ncToString(filter.value).split(',') || []).map((v) => {
                        var _a, _b, _c;
                        let result = v.trim();
                        if (result === globals_1.CURRENT_USER_TOKEN) {
                            result = (_c = (_b = (_a = params.options) === null || _a === void 0 ? void 0 : _a.currentUser) === null || _b === void 0 ? void 0 : _b.id) !== null && _c !== void 0 ? _c : result;
                        }
                        return result;
                    });
                    switch (filter.comparison_op) {
                        case 'anyof':
                            res = userIds.some((id) => filterValues.includes(id));
                            break;
                        case 'nanyof':
                            res = !userIds.some((id) => filterValues.includes(id));
                            break;
                        case 'allof':
                            res = filterValues.every((id) => userIds.includes(id));
                            break;
                        case 'nallof':
                            res = !filterValues.every((id) => userIds.includes(id));
                            break;
                        case 'empty':
                        case 'blank':
                            res = userIds.length === 0;
                            break;
                        case 'notempty':
                        case 'notblank':
                            res = userIds.length > 0;
                            break;
                        default:
                            res = false; // Unsupported operation for User fields
                    }
                }
                else if (column.uidt === UITypes_1.default.LinkToAnotherRecord) {
                    let linkData = data[field];
                    linkData = Array.isArray(linkData) ? linkData : [linkData];
                    const colOptions = column.colOptions;
                    const relatedModelId = colOptions === null || colOptions === void 0 ? void 0 : colOptions.fk_related_model_id;
                    const relatedMeta = (0, metaHelpers_1.getMetaWithCompositeKey)(metas, baseId, relatedModelId);
                    if (!(relatedMeta === null || relatedMeta === void 0 ? void 0 : relatedMeta.columns)) {
                        res = false;
                    }
                    else {
                        // Find the child column in the related table
                        const childColumn = relatedMeta.columns.find((col) => col.pv);
                        if (!childColumn) {
                            res = false;
                        }
                        else {
                            const childFieldName = childColumn.title;
                            const childValues = linkData
                                .map((item) => {
                                return ncToString(item === null || item === void 0 ? void 0 : item[childFieldName]);
                            })
                                .filter((val) => val !== '');
                            switch (filter.comparison_op) {
                                case 'eq':
                                    res = childValues.includes(ncToString(filter.value));
                                    break;
                                case 'neq':
                                    res = !childValues.includes(ncToString(filter.value));
                                    break;
                                case 'like':
                                    res = childValues.some((val) => val
                                        .toLowerCase()
                                        .includes(ncToString(filter.value).toLowerCase()));
                                    break;
                                case 'nlike':
                                    res = !childValues.some((val) => val
                                        .toLowerCase()
                                        .includes(ncToString(filter.value).toLowerCase()));
                                    break;
                                case 'anyof': {
                                    const filterValues = ncToString(filter.value)
                                        .split(',')
                                        .map((v) => v.trim()) || [];
                                    res = childValues.some((val) => filterValues.includes(val));
                                    break;
                                }
                                case 'nanyof': {
                                    const filterValues2 = ncToString(filter.value)
                                        .split(',')
                                        .map((v) => v.trim()) || [];
                                    res = !childValues.some((val) => filterValues2.includes(val));
                                    break;
                                }
                                case 'allof': {
                                    const filterValues3 = ncToString(filter.value)
                                        .split(',')
                                        .map((v) => v.trim()) || [];
                                    res = filterValues3.every((filterVal) => childValues.includes(filterVal));
                                    break;
                                }
                                case 'nallof': {
                                    const filterValues4 = ncToString(filter.value)
                                        .split(',')
                                        .map((v) => v.trim()) || [];
                                    res = !filterValues4.every((filterVal) => childValues.includes(filterVal));
                                    break;
                                }
                                case 'empty':
                                case 'blank':
                                    res = linkData.length === 0;
                                    break;
                                case 'notempty':
                                case 'notblank':
                                    res = linkData.length > 0;
                                    break;
                                default:
                                    res = false;
                            }
                        }
                    }
                }
                else if ([UITypes_1.default.JSON, UITypes_1.default.Time].includes(column.uidt) &&
                    ['eq'].includes(filter.comparison_op)) {
                    res = column_helper_1.ColumnHelper.getColumn(column.uidt).equalityComparison(val, filter.value, {
                        col: column,
                    });
                }
                else {
                    switch (filter.comparison_op) {
                        case 'eq':
                        case 'gb_eq':
                            res = val == filter.value;
                            break;
                        case 'neq':
                            res = val != filter.value;
                            break;
                        case 'like':
                            res =
                                ncToString(data[field])
                                    .toLowerCase()
                                    .indexOf(ncToString(filter.value).toLowerCase()) > -1;
                            break;
                        case 'nlike':
                            res =
                                ncToString(data[field])
                                    .toLowerCase()
                                    .indexOf(ncToString(filter.value).toLowerCase()) === -1;
                            break;
                        case 'empty':
                        case 'blank':
                            res =
                                data[field] === '' ||
                                    data[field] === null ||
                                    data[field] === undefined;
                            break;
                        case 'notempty':
                        case 'notblank':
                            res = !(data[field] === '' ||
                                data[field] === null ||
                                data[field] === undefined);
                            break;
                        case 'checked':
                            res = !!data[field];
                            break;
                        case 'notchecked':
                            res = !data[field];
                            break;
                        case 'null':
                            res = data[field] === null;
                            break;
                        case 'notnull':
                            res = data[field] !== null;
                            break;
                        case 'allof':
                            res = ((_d = ncToString(filter.value)
                                .split(',')
                                .map((item) => item.trim())) !== null && _d !== void 0 ? _d : []).every((item) => { var _a; return ((_a = ncToString(data[field]).split(',')) !== null && _a !== void 0 ? _a : []).includes(item); });
                            break;
                        case 'anyof':
                            res = ((_e = ncToString(filter.value)
                                .split(',')
                                .map((item) => item.trim())) !== null && _e !== void 0 ? _e : []).some((item) => { var _a; return ((_a = ncToString(data[field]).split(',')) !== null && _a !== void 0 ? _a : []).includes(item); });
                            break;
                        case 'nallof':
                            res = !((_f = ncToString(filter.value)
                                .split(',')
                                .map((item) => item.trim())) !== null && _f !== void 0 ? _f : []).every((item) => { var _a; return ((_a = ncToString(data[field]).split(',')) !== null && _a !== void 0 ? _a : []).includes(item); });
                            break;
                        case 'nanyof':
                            res = !((_g = ncToString(filter.value)
                                .split(',')
                                .map((item) => item.trim())) !== null && _g !== void 0 ? _g : []).some((item) => { var _a; return ((_a = ncToString(data[field]).split(',')) !== null && _a !== void 0 ? _a : []).includes(item); });
                            break;
                        case 'lt':
                            res = +data[field] < +filter.value;
                            break;
                        case 'lte':
                        case 'le':
                            res = +data[field] <= +filter.value;
                            break;
                        case 'gt':
                            res = +data[field] > +filter.value;
                            break;
                        case 'gte':
                        case 'ge':
                            res = +data[field] >= +filter.value;
                            break;
                    }
                }
            }
        }
        switch (filter.logical_op) {
            case 'or':
                isValid = isValid || !!res;
                break;
            case 'not':
                isValid = isValid && !res;
                break;
            case 'and':
            default:
                isValid = (isValid !== null && isValid !== void 0 ? isValid : true) && res;
                break;
        }
    }
    return isValid;
}
//# sourceMappingURL=data:application/json;base64,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