"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IS_WITHIN_COMPARISON_SUB_OPS = exports.GROUPBY_COMPARISON_OPS = exports.COMPARISON_SUB_OPS = exports.COMPARISON_OPS = void 0;
exports.buildFilterTree = buildFilterTree;
exports.extractFilterFromXwhere = extractFilterFromXwhere;
var query_filter_lexer_1 = require("../lib/parser/queryFilter/query-filter-lexer");
Object.defineProperty(exports, "COMPARISON_OPS", { enumerable: true, get: function () { return query_filter_lexer_1.COMPARISON_OPS; } });
Object.defineProperty(exports, "COMPARISON_SUB_OPS", { enumerable: true, get: function () { return query_filter_lexer_1.COMPARISON_SUB_OPS; } });
Object.defineProperty(exports, "GROUPBY_COMPARISON_OPS", { enumerable: true, get: function () { return query_filter_lexer_1.GROUPBY_COMPARISON_OPS; } });
Object.defineProperty(exports, "IS_WITHIN_COMPARISON_SUB_OPS", { enumerable: true, get: function () { return query_filter_lexer_1.IS_WITHIN_COMPARISON_SUB_OPS; } });
const filterHelpers_withparser_1 = require("./filterHelpers_withparser");
const filterHelpers_old_1 = require("./filterHelpers_old");
const enums_1 = require("./enums");
/**
 * Converts a flat array of filter objects into a nested tree structure
 * @param {FilterType[]} items - Array of filter objects
 * @returns {FilterType[]} - Nested tree structure
 */
function buildFilterTree(items) {
    const itemMap = new Map();
    const rootItems = [];
    // Map items with IDs and handle items without IDs
    items.forEach((item) => {
        if (item.id) {
            itemMap.set(item.id, Object.assign(Object.assign({}, item), { children: [] }));
        }
        else {
            // Items without IDs go straight to root level
            rootItems.push(Object.assign(Object.assign({}, item), { children: [] }));
        }
    });
    // Build parent-child relationships for items with IDs
    items.forEach((item) => {
        // Skip items without IDs as they're already in rootItems
        if (!item.id)
            return;
        const mappedItem = itemMap.get(item.id);
        if (item.fk_parent_id === null) {
            rootItems.push(mappedItem);
        }
        else {
            const parent = itemMap.get(item.fk_parent_id);
            if (parent) {
                parent.children.push(mappedItem);
            }
            else {
                // If parent is not found, treat as root item
                rootItems.push(mappedItem);
            }
        }
    });
    return rootItems;
}
function extractFilterFromXwhere(context, str, aliasColObjMap, throwErrorIfInvalid = false, errors = []) {
    if (context.api_version === enums_1.NcApiVersion.V3) {
        return (0, filterHelpers_withparser_1.extractFilterFromXwhere)(context, {
            str,
            aliasColObjMap,
            throwErrorIfInvalid,
            errors,
        });
    }
    else if (typeof str === 'string' && str.startsWith('@')) {
        return (0, filterHelpers_withparser_1.extractFilterFromXwhere)(context, {
            str: str.substring(1),
            aliasColObjMap,
            throwErrorIfInvalid,
            errors,
        });
    }
    else {
        return (0, filterHelpers_old_1.extractFilterFromXwhere)(str, aliasColObjMap, throwErrorIfInvalid, errors);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsdGVySGVscGVycy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9saWIvZmlsdGVySGVscGVycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFzQkEsMENBbUNDO0FBRUQsMERBd0JDO0FBakZELGtGQUtxRDtBQUpuRCxvSEFBQSxjQUFjLE9BQUE7QUFDZCx3SEFBQSxrQkFBa0IsT0FBQTtBQUNsQiw0SEFBQSxzQkFBc0IsT0FBQTtBQUN0QixrSUFBQSw0QkFBNEIsT0FBQTtBQUU5Qix5RUFBc0Y7QUFDdEYsMkRBQTRFO0FBRTVFLG1DQUF1QztBQU12Qzs7OztHQUlHO0FBQ0gsU0FBZ0IsZUFBZSxDQUFDLEtBQW1CO0lBQ2pELE1BQU0sT0FBTyxHQUFHLElBQUksR0FBRyxFQUFFLENBQUM7SUFDMUIsTUFBTSxTQUFTLEdBQWlCLEVBQUUsQ0FBQztJQUVuQyxrREFBa0Q7SUFDbEQsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFO1FBQ3JCLElBQUksSUFBSSxDQUFDLEVBQUUsRUFBRSxDQUFDO1lBQ1osT0FBTyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsRUFBRSxrQ0FBTyxJQUFJLEtBQUUsUUFBUSxFQUFFLEVBQUUsSUFBRyxDQUFDO1FBQ2xELENBQUM7YUFBTSxDQUFDO1lBQ04sOENBQThDO1lBQzlDLFNBQVMsQ0FBQyxJQUFJLGlDQUFNLElBQUksS0FBRSxRQUFRLEVBQUUsRUFBRSxJQUFHLENBQUM7UUFDNUMsQ0FBQztJQUNILENBQUMsQ0FBQyxDQUFDO0lBRUgsc0RBQXNEO0lBQ3RELEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtRQUNyQix5REFBeUQ7UUFDekQsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFO1lBQUUsT0FBTztRQUVyQixNQUFNLFVBQVUsR0FBRyxPQUFPLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUV4QyxJQUFJLElBQUksQ0FBQyxZQUFZLEtBQUssSUFBSSxFQUFFLENBQUM7WUFDL0IsU0FBUyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUM3QixDQUFDO2FBQU0sQ0FBQztZQUNOLE1BQU0sTUFBTSxHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1lBQzlDLElBQUksTUFBTSxFQUFFLENBQUM7Z0JBQ1gsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7WUFDbkMsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLDZDQUE2QztnQkFDN0MsU0FBUyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztZQUM3QixDQUFDO1FBQ0gsQ0FBQztJQUNILENBQUMsQ0FBQyxDQUFDO0lBRUgsT0FBTyxTQUFTLENBQUM7QUFDbkIsQ0FBQztBQUVELFNBQWdCLHVCQUF1QixDQUNyQyxPQUFxRSxFQUNyRSxHQUFzQixFQUN0QixjQUFxRCxFQUNyRCxtQkFBbUIsR0FBRyxLQUFLLEVBQzNCLFNBQTZCLEVBQUU7SUFFL0IsSUFBSSxPQUFPLENBQUMsV0FBVyxLQUFLLG9CQUFZLENBQUMsRUFBRSxFQUFFLENBQUM7UUFDNUMsT0FBTyxJQUFBLGtEQUFhLEVBQUMsT0FBTyxFQUFFO1lBQzVCLEdBQUc7WUFDSCxjQUFjO1lBQ2QsbUJBQW1CO1lBQ25CLE1BQU07U0FDUCxDQUFDLENBQUM7SUFDTCxDQUFDO1NBQU0sSUFBSSxPQUFPLEdBQUcsS0FBSyxRQUFRLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDO1FBQzFELE9BQU8sSUFBQSxrREFBYSxFQUFDLE9BQU8sRUFBRTtZQUM1QixHQUFHLEVBQUUsR0FBRyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7WUFDckIsY0FBYztZQUNkLG1CQUFtQjtZQUNuQixNQUFNO1NBQ1AsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztTQUFNLENBQUM7UUFDTixPQUFPLElBQUEsMkNBQVUsRUFBQyxHQUFHLEVBQUUsY0FBYyxFQUFFLG1CQUFtQixFQUFFLE1BQU0sQ0FBQyxDQUFDO0lBQ3RFLENBQUM7QUFDSCxDQUFDIn0=