"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const filterHelpers_old_spec_1 = require("./filterHelpers_old.spec");
const filterHelpers_withparser_1 = require("./filterHelpers_withparser");
const UITypes_1 = __importDefault(require("./UITypes"));
const context = { timezone: 'Asia/Calcutta' };
(0, filterHelpers_old_spec_1.testExtractFilterFromXwhere)('filterHelpers_withparser', (str, aliasColObjMap, throwErrorIfInvalid) => {
    return (0, filterHelpers_withparser_1.extractFilterFromXwhere)(context, {
        str,
        aliasColObjMap,
        throwErrorIfInvalid,
    });
});
describe('filterHelpers_withparser_specific', () => {
    describe('extractFilterFromXwhere', () => {
        describe('logical', () => {
            it('will parse basic logical query', () => {
                var _a;
                // isWithin need to have specific suboperator :|
                const query = '(Date,isWithin,pastMonth)~and(Name,like,Hello)';
                const columnAlias = {
                    Date: {
                        id: 'field1',
                        column_name: 'col1',
                        title: 'Date',
                        uidt: UITypes_1.default.DateTime,
                    },
                    Name: {
                        id: 'field2',
                        column_name: 'col2',
                        title: 'Name',
                        uidt: UITypes_1.default.SingleLineText,
                    },
                };
                const result = (0, filterHelpers_withparser_1.extractFilterFromXwhere)(context, {
                    str: query,
                    aliasColObjMap: columnAlias,
                });
                expect(result).toBeDefined();
                expect(result.filters).toBeDefined();
                expect(result.filters.length).toBe(1);
                expect((_a = result.filters[0].children) === null || _a === void 0 ? void 0 : _a[1].logical_op).toBe('and');
            });
            it('will parse nested logical query', () => {
                var _a;
                // isWithin need to have specific suboperator :|
                const query = '(Date,isWithin,pastMonth)~or((Name,like,Hello)~and(Name,like,World))';
                const columnAlias = {
                    Date: {
                        id: 'field1',
                        column_name: 'col1',
                        title: 'Date',
                        uidt: UITypes_1.default.DateTime,
                    },
                    Name: {
                        id: 'field2',
                        column_name: 'col2',
                        title: 'Name',
                        uidt: UITypes_1.default.SingleLineText,
                    },
                };
                const result = (0, filterHelpers_withparser_1.extractFilterFromXwhere)(context, {
                    str: query,
                    aliasColObjMap: columnAlias,
                });
                expect(result).toBeDefined();
                expect(result.filters).toBeDefined();
                expect(result.filters.length).toBe(1);
                expect((_a = result.filters[0].children) === null || _a === void 0 ? void 0 : _a[1].logical_op).toBe('or');
            });
            it('will parse multiselect with ~or connection', () => {
                var _a;
                const query = '(fMultiSelect,allof,jun)~or(fMultiSelect,allof,may)';
                const columnAlias = {
                    fMultiSelect: {
                        id: 'field1',
                        column_name: 'fMultiSelect',
                        title: 'fMultiSelect',
                        uidt: UITypes_1.default.MultiSelect,
                    },
                };
                const result = (0, filterHelpers_withparser_1.extractFilterFromXwhere)(context, {
                    str: query,
                    aliasColObjMap: columnAlias,
                });
                expect(result).toBeDefined();
                expect(result.filters).toBeDefined();
                expect(result.filters.length).toBe(1);
                expect((_a = result.filters[0].children) === null || _a === void 0 ? void 0 : _a[1].logical_op).toBe('or');
            });
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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