"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hideExtraFieldsMetaKey = exports.oppositeValidationTypeMap = exports.AttachmentValidationType = exports.SelectValidationType = exports.YearValidationType = exports.TimeValidationType = exports.DateValidationType = exports.NumberValidationType = exports.StringValidationType = exports.GenericValidationType = void 0;
var GenericValidationType;
(function (GenericValidationType) {
    GenericValidationType["Required"] = "required";
})(GenericValidationType || (exports.GenericValidationType = GenericValidationType = {}));
var StringValidationType;
(function (StringValidationType) {
    StringValidationType["MinLength"] = "minLength";
    StringValidationType["MaxLength"] = "maxLength";
    StringValidationType["StartsWith"] = "startsWith";
    StringValidationType["EndsWith"] = "endsWith";
    StringValidationType["Includes"] = "includes";
    StringValidationType["NotIncludes"] = "notIncludes";
    StringValidationType["Regex"] = "regex";
    StringValidationType["Email"] = "email";
    StringValidationType["BusinessEmail"] = "businessEmail";
    StringValidationType["PhoneNumber"] = "phoneNumber";
    StringValidationType["Url"] = "url";
})(StringValidationType || (exports.StringValidationType = StringValidationType = {}));
var NumberValidationType;
(function (NumberValidationType) {
    NumberValidationType["Min"] = "min";
    NumberValidationType["Max"] = "max";
})(NumberValidationType || (exports.NumberValidationType = NumberValidationType = {}));
var DateValidationType;
(function (DateValidationType) {
    DateValidationType["MinDate"] = "minDate";
    DateValidationType["MaxDate"] = "maxDate";
})(DateValidationType || (exports.DateValidationType = DateValidationType = {}));
var TimeValidationType;
(function (TimeValidationType) {
    TimeValidationType["MinTime"] = "minTime";
    TimeValidationType["MaxTime"] = "maxTime";
})(TimeValidationType || (exports.TimeValidationType = TimeValidationType = {}));
var YearValidationType;
(function (YearValidationType) {
    YearValidationType["MinYear"] = "minYear";
    YearValidationType["MaxYear"] = "maxYear";
})(YearValidationType || (exports.YearValidationType = YearValidationType = {}));
var SelectValidationType;
(function (SelectValidationType) {
    SelectValidationType["MinSelected"] = "minSelected";
    SelectValidationType["MaxSelected"] = "maxSelected";
    SelectValidationType["LimitOptions"] = "limitOptions";
})(SelectValidationType || (exports.SelectValidationType = SelectValidationType = {}));
var AttachmentValidationType;
(function (AttachmentValidationType) {
    AttachmentValidationType["FileTypes"] = "fileTypes";
    AttachmentValidationType["FileSize"] = "fileSize";
    AttachmentValidationType["FileCount"] = "fileCount";
})(AttachmentValidationType || (exports.AttachmentValidationType = AttachmentValidationType = {}));
exports.oppositeValidationTypeMap = {
    [StringValidationType.MaxLength]: StringValidationType.MinLength,
    [StringValidationType.NotIncludes]: StringValidationType.Includes,
    [NumberValidationType.Max]: NumberValidationType.Min,
    [YearValidationType.MaxYear]: YearValidationType.MinYear,
    [DateValidationType.MaxDate]: DateValidationType.MinDate,
    [TimeValidationType.MaxTime]: TimeValidationType.MinTime,
    [SelectValidationType.MaxSelected]: SelectValidationType.MinSelected,
};
exports.hideExtraFieldsMetaKey = 'hideExtraFields';
//# sourceMappingURL=data:application/json;base64,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