"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleFormulaError = handleFormulaError;
const stringHelpers_1 = require("../../lib/stringHelpers");
const error_1 = require("./error");
const enums_1 = require("./enums");
const REGEX_ERROR_AT_CHARACTER = /\sat character (\d+)/;
function handleFormulaError({ formula, error, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    let position;
    let identifierLength;
    if ((_a = error.extra) === null || _a === void 0 ? void 0 : _a.position) {
        position = error.extra.position.index;
        identifierLength = error.extra.position.length;
    }
    else if ((_c = (_b = error.extra) === null || _b === void 0 ? void 0 : _b.columnName) !== null && _c !== void 0 ? _c : (_d = error.extra) === null || _d === void 0 ? void 0 : _d.calleeName) {
        const needle = (_f = (_e = error.extra) === null || _e === void 0 ? void 0 : _e.columnName) !== null && _f !== void 0 ? _f : (_g = error.extra) === null || _g === void 0 ? void 0 : _g.calleeName;
        const identifierMatch = formula.match(new RegExp(`\\b${(0, stringHelpers_1.escapeRegexString)(needle)}\\b`));
        if (typeof (identifierMatch === null || identifierMatch === void 0 ? void 0 : identifierMatch.index) === 'number') {
            position = identifierMatch.index;
            identifierLength = needle.length;
        }
    }
    else {
        const message = error.message;
        // check for error character at
        const errorAtRegex = message.match(REGEX_ERROR_AT_CHARACTER);
        if (errorAtRegex === null || errorAtRegex === void 0 ? void 0 : errorAtRegex[0]) {
            position = Number(errorAtRegex[1]);
            identifierLength = 1;
        }
    }
    if (typeof position === 'number') {
        const colRowPosition = (0, stringHelpers_1.getRowColPositionFromIndex)({
            stack: formula,
            position,
        });
        throw new error_1.FormulaError((_h = error.type) !== null && _h !== void 0 ? _h : enums_1.FormulaErrorType.INVALID_SYNTAX, Object.assign(Object.assign({}, ((_j = error.extra) !== null && _j !== void 0 ? _j : {})), { position: Object.assign(Object.assign({}, colRowPosition), { length: identifierLength }) }), error.message);
    }
    else {
        throw error;
    }
}
//# sourceMappingURL=data:application/json;base64,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