"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.jsepCurlyHook = exports.jsepIndexHook = void 0;
// opening and closing string code
const OCURLY_CODE = 123; // '{'
const CCURLY_CODE = 125; // '}'
exports.jsepIndexHook = {
    name: 'indexing',
    init(jsep) {
        // Match identifier in following pattern: {abc-cde}
        jsep.hooks.add('after-expression', function escapedIdentifier(env) {
            var _a, _b, _c;
            if (!env.node) {
                return;
            }
            // search needle, either the callee name, identifier raw, etc
            const needle = (_b = (_a = env.node.name) !== null && _a !== void 0 ? _a : env.node.raw) !== null && _b !== void 0 ? _b : (_c = env.node.callee) === null || _c === void 0 ? void 0 : _c.name;
            // current token index
            let lastIndex = this.index;
            if (env.node.arguments) {
                // because arguments are always at the right side, we start from earliest argument
                lastIndex = env.node.arguments
                    .map((k) => k.indexStart)
                    .filter((k) => k)
                    .reduce((acc, cur) => (acc < cur ? acc : cur), lastIndex);
            }
            // get the last index of needle
            const startIndex = env.context.expr.lastIndexOf(needle, lastIndex);
            env.node.indexStart = startIndex;
            env.node.nodeLength = lastIndex - startIndex;
            env.node.indexEnd = this.index;
            return env.node;
        });
    },
};
exports.jsepCurlyHook = {
    name: 'curly',
    init(jsep) {
        // Match identifier in following pattern: {abc-cde}
        jsep.hooks.add('gobble-token', function escapedIdentifier(env) {
            // check if the current token is an opening curly bracket
            if (this.code === OCURLY_CODE) {
                const patternIndex = this.index;
                // move to the next character until we find a closing curly bracket
                while (this.index < this.expr.length) {
                    ++this.index;
                    if (this.code === CCURLY_CODE) {
                        let identifier = this.expr.slice(patternIndex, ++this.index);
                        // if starting with double curley brace then check for ending double curley brace
                        // if found include with the identifier
                        if (identifier.startsWith('{{') &&
                            this.expr.slice(patternIndex, this.index + 1).endsWith('}')) {
                            identifier = this.expr.slice(patternIndex, ++this.index);
                        }
                        env.node = {
                            type: jsep.IDENTIFIER,
                            name: /^{{.*}}$/.test(identifier)
                                ? // start would be the position of the first curly bracket
                                    // add 2 to point to the first character for expressions like {{col1}}
                                    identifier.slice(2, -2)
                                : // start would be the position of the first curly bracket
                                    // add 1 to point to the first character for expressions like {col1}
                                    identifier.slice(1, -1),
                            raw: identifier,
                        };
                        // env.node = this.gobbleTokenProperty(env.node);
                        return env.node;
                    }
                }
                this.throwError('Unclosed }');
            }
        });
    },
};
//# sourceMappingURL=data:application/json;base64,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