"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.substituteColumnAliasWithIdInFormula = substituteColumnAliasWithIdInFormula;
exports.substituteColumnIdWithAliasInFormula = substituteColumnIdWithAliasInFormula;
exports.jsepTreeToFormula = jsepTreeToFormula;
const jsepInstances_1 = require("./formula/jsepInstances");
__exportStar(require("./formula/enums"), exports);
__exportStar(require("./formula/error"), exports);
__exportStar(require("./formula/formulas"), exports);
__exportStar(require("./formula/handle-formula-error"), exports);
__exportStar(require("./formula/hooks"), exports);
__exportStar(require("./formula/operators"), exports);
__exportStar(require("./formula/types"), exports);
__exportStar(require("./formula/validate-extract-tree"), exports);
__exportStar(require("./formula/jsepInstances"), exports);
async function substituteColumnAliasWithIdInFormula(formula, columns) {
    const substituteId = async (pt) => {
        if (pt.type === 'CallExpression') {
            for (const arg of pt.arguments || []) {
                await substituteId(arg);
            }
        }
        else if (pt.type === 'Literal') {
            return;
        }
        else if (pt.type === 'Identifier') {
            const colNameOrId = pt.name;
            const column = columns.find((c) => c.id === colNameOrId ||
                c.column_name === colNameOrId ||
                c.title === colNameOrId);
            pt.name = '{' + column.id + '}';
        }
        else if (pt.type === 'BinaryExpression') {
            await substituteId(pt.left);
            await substituteId(pt.right);
        }
    };
    const parsedFormula = (0, jsepInstances_1.formulaJsep)(formula);
    await substituteId(parsedFormula);
    return jsepTreeToFormula(parsedFormula);
}
function substituteColumnIdWithAliasInFormula(formula, columns, rawFormula) {
    const substituteId = (pt, ptRaw) => {
        var _a;
        if (pt.type === 'CallExpression') {
            let i = 0;
            for (const arg of pt.arguments || []) {
                substituteId(arg, (_a = ptRaw === null || ptRaw === void 0 ? void 0 : ptRaw.arguments) === null || _a === void 0 ? void 0 : _a[i++]);
            }
        }
        else if (pt.type === 'Literal') {
            return;
        }
        else if (pt.type === 'Identifier') {
            const colNameOrId = pt === null || pt === void 0 ? void 0 : pt.name;
            const column = columns.find((c) => c.id === colNameOrId ||
                c.column_name === colNameOrId ||
                c.title === colNameOrId);
            pt.name = (column === null || column === void 0 ? void 0 : column.title) || (ptRaw === null || ptRaw === void 0 ? void 0 : ptRaw.name) || (pt === null || pt === void 0 ? void 0 : pt.name);
        }
        else if (pt.type === 'BinaryExpression') {
            substituteId(pt.left, ptRaw === null || ptRaw === void 0 ? void 0 : ptRaw.left);
            substituteId(pt.right, ptRaw === null || ptRaw === void 0 ? void 0 : ptRaw.right);
        }
    };
    const parsedFormula = (0, jsepInstances_1.formulaJsep)(formula);
    const parsedRawFormula = rawFormula && (0, jsepInstances_1.formulaJsep)(rawFormula);
    substituteId(parsedFormula, parsedRawFormula);
    return jsepTreeToFormula(parsedFormula);
}
// isCallExpId - is the identifier part of a call expression
// in case of call expression, we don't want to wrap the identifier in curly brackets
function jsepTreeToFormula(node, isCallExpId = false) {
    if (node.type === 'BinaryExpression' || node.type === 'LogicalExpression') {
        return ('(' +
            jsepTreeToFormula(node.left) +
            ' ' +
            node.operator +
            ' ' +
            jsepTreeToFormula(node.right) +
            ')');
    }
    if (node.type === 'UnaryExpression') {
        return node.operator + jsepTreeToFormula(node.argument);
    }
    if (node.type === 'MemberExpression') {
        return (jsepTreeToFormula(node.object) +
            '[' +
            jsepTreeToFormula(node.property) +
            ']');
    }
    if (node.type === 'Identifier') {
        if (!isCallExpId)
            return '{' + node.name + '}';
        return node.name;
    }
    if (node.type === 'Literal') {
        if (typeof node.value === 'string') {
            return String.raw `"${escapeLiteral(node.raw.slice(1, -1))}"`;
        }
        return '' + node.value;
    }
    if (node.type === 'CallExpression') {
        return (jsepTreeToFormula(node.callee, true) +
            '(' +
            node.arguments.map((argPt) => jsepTreeToFormula(argPt)).join(', ') +
            ')');
    }
    if (node.type === 'ArrayExpression') {
        return ('[' +
            node.elements.map((elePt) => jsepTreeToFormula(elePt)).join(', ') +
            ']');
    }
    if (node.type === 'Compound') {
        return node.body.map((e) => jsepTreeToFormula(e)).join(' ');
    }
    if (node.type === 'ConditionalExpression') {
        return (jsepTreeToFormula(node.test) +
            ' ? ' +
            jsepTreeToFormula(node.consequent) +
            ' : ' +
            jsepTreeToFormula(node.alternate));
    }
    return '';
}
function escapeLiteral(v) {
    return (v
        // 1️⃣ Temporarily protect real newline
        .replace(/\\n/g, '__NC_NEWLINE__')
        // 2️⃣ Escape unescaped backslashes (replace \ to \\, escape only unescaped \)
        .replace(/([^\\]|^)\\(?!\\)/g, `$1\\\\`)
        // 3️⃣ Escape quotes (replace " to \" and ' to \')
        .replace(/([^\\]|^)"/g, `$1\\"`)
        .replace(/([^\\]|^)'/g, `$1\\'`)
        // 4️⃣ Restore protected newline and tab
        .replace(/__NC_NEWLINE__/g, '\\n'));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9ybXVsYUhlbHBlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL2Zvcm11bGFIZWxwZXJzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7QUFhQSxvRkE0QkM7QUFFRCxvRkFnQ0M7QUFJRCw4Q0FzRUM7QUFwSkQsMkRBQXNEO0FBRXRELGtEQUFnQztBQUNoQyxrREFBZ0M7QUFDaEMscURBQW1DO0FBQ25DLGlFQUErQztBQUMvQyxrREFBZ0M7QUFDaEMsc0RBQW9DO0FBQ3BDLGtEQUFnQztBQUNoQyxrRUFBZ0Q7QUFDaEQsMERBQXdDO0FBRWpDLEtBQUssVUFBVSxvQ0FBb0MsQ0FDeEQsT0FBTyxFQUNQLE9BQXFCO0lBRXJCLE1BQU0sWUFBWSxHQUFHLEtBQUssRUFBRSxFQUFPLEVBQUUsRUFBRTtRQUNyQyxJQUFJLEVBQUUsQ0FBQyxJQUFJLEtBQUssZ0JBQWdCLEVBQUUsQ0FBQztZQUNqQyxLQUFLLE1BQU0sR0FBRyxJQUFJLEVBQUUsQ0FBQyxTQUFTLElBQUksRUFBRSxFQUFFLENBQUM7Z0JBQ3JDLE1BQU0sWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQzFCLENBQUM7UUFDSCxDQUFDO2FBQU0sSUFBSSxFQUFFLENBQUMsSUFBSSxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQ2pDLE9BQU87UUFDVCxDQUFDO2FBQU0sSUFBSSxFQUFFLENBQUMsSUFBSSxLQUFLLFlBQVksRUFBRSxDQUFDO1lBQ3BDLE1BQU0sV0FBVyxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUM7WUFDNUIsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLElBQUksQ0FDekIsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUNKLENBQUMsQ0FBQyxFQUFFLEtBQUssV0FBVztnQkFDcEIsQ0FBQyxDQUFDLFdBQVcsS0FBSyxXQUFXO2dCQUM3QixDQUFDLENBQUMsS0FBSyxLQUFLLFdBQVcsQ0FDMUIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxJQUFJLEdBQUcsR0FBRyxHQUFHLE1BQU0sQ0FBQyxFQUFFLEdBQUcsR0FBRyxDQUFDO1FBQ2xDLENBQUM7YUFBTSxJQUFJLEVBQUUsQ0FBQyxJQUFJLEtBQUssa0JBQWtCLEVBQUUsQ0FBQztZQUMxQyxNQUFNLFlBQVksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDNUIsTUFBTSxZQUFZLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQy9CLENBQUM7SUFDSCxDQUFDLENBQUM7SUFDRixNQUFNLGFBQWEsR0FBRyxJQUFBLDJCQUFXLEVBQUMsT0FBTyxDQUFDLENBQUM7SUFDM0MsTUFBTSxZQUFZLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDbEMsT0FBTyxpQkFBaUIsQ0FBQyxhQUFhLENBQUMsQ0FBQztBQUMxQyxDQUFDO0FBRUQsU0FBZ0Isb0NBQW9DLENBQ2xELE9BQU8sRUFDUCxPQUFxQixFQUNyQixVQUFXO0lBRVgsTUFBTSxZQUFZLEdBQUcsQ0FBQyxFQUFPLEVBQUUsS0FBVyxFQUFFLEVBQUU7O1FBQzVDLElBQUksRUFBRSxDQUFDLElBQUksS0FBSyxnQkFBZ0IsRUFBRSxDQUFDO1lBQ2pDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUNWLEtBQUssTUFBTSxHQUFHLElBQUksRUFBRSxDQUFDLFNBQVMsSUFBSSxFQUFFLEVBQUUsQ0FBQztnQkFDckMsWUFBWSxDQUFDLEdBQUcsRUFBRSxNQUFBLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxTQUFTLDBDQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztZQUM3QyxDQUFDO1FBQ0gsQ0FBQzthQUFNLElBQUksRUFBRSxDQUFDLElBQUksS0FBSyxTQUFTLEVBQUUsQ0FBQztZQUNqQyxPQUFPO1FBQ1QsQ0FBQzthQUFNLElBQUksRUFBRSxDQUFDLElBQUksS0FBSyxZQUFZLEVBQUUsQ0FBQztZQUNwQyxNQUFNLFdBQVcsR0FBRyxFQUFFLGFBQUYsRUFBRSx1QkFBRixFQUFFLENBQUUsSUFBSSxDQUFDO1lBQzdCLE1BQU0sTUFBTSxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQ3pCLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FDSixDQUFDLENBQUMsRUFBRSxLQUFLLFdBQVc7Z0JBQ3BCLENBQUMsQ0FBQyxXQUFXLEtBQUssV0FBVztnQkFDN0IsQ0FBQyxDQUFDLEtBQUssS0FBSyxXQUFXLENBQzFCLENBQUM7WUFDRixFQUFFLENBQUMsSUFBSSxHQUFHLENBQUEsTUFBTSxhQUFOLE1BQU0sdUJBQU4sTUFBTSxDQUFFLEtBQUssTUFBSSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsSUFBSSxDQUFBLEtBQUksRUFBRSxhQUFGLEVBQUUsdUJBQUYsRUFBRSxDQUFFLElBQUksQ0FBQSxDQUFDO1FBQ3JELENBQUM7YUFBTSxJQUFJLEVBQUUsQ0FBQyxJQUFJLEtBQUssa0JBQWtCLEVBQUUsQ0FBQztZQUMxQyxZQUFZLENBQUMsRUFBRSxDQUFDLElBQUksRUFBRSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsSUFBSSxDQUFDLENBQUM7WUFDbkMsWUFBWSxDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3ZDLENBQUM7SUFDSCxDQUFDLENBQUM7SUFFRixNQUFNLGFBQWEsR0FBRyxJQUFBLDJCQUFXLEVBQUMsT0FBTyxDQUFDLENBQUM7SUFDM0MsTUFBTSxnQkFBZ0IsR0FBRyxVQUFVLElBQUksSUFBQSwyQkFBVyxFQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQy9ELFlBQVksQ0FBQyxhQUFhLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztJQUM5QyxPQUFPLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0FBQzFDLENBQUM7QUFFRCw0REFBNEQ7QUFDNUQscUZBQXFGO0FBQ3JGLFNBQWdCLGlCQUFpQixDQUFDLElBQUksRUFBRSxXQUFXLEdBQUcsS0FBSztJQUN6RCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssa0JBQWtCLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxtQkFBbUIsRUFBRSxDQUFDO1FBQzFFLE9BQU8sQ0FDTCxHQUFHO1lBQ0gsaUJBQWlCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztZQUM1QixHQUFHO1lBQ0gsSUFBSSxDQUFDLFFBQVE7WUFDYixHQUFHO1lBQ0gsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUM3QixHQUFHLENBQ0osQ0FBQztJQUNKLENBQUM7SUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssaUJBQWlCLEVBQUUsQ0FBQztRQUNwQyxPQUFPLElBQUksQ0FBQyxRQUFRLEdBQUcsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssa0JBQWtCLEVBQUUsQ0FBQztRQUNyQyxPQUFPLENBQ0wsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQztZQUM5QixHQUFHO1lBQ0gsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUNoQyxHQUFHLENBQ0osQ0FBQztJQUNKLENBQUM7SUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssWUFBWSxFQUFFLENBQUM7UUFDL0IsSUFBSSxDQUFDLFdBQVc7WUFBRSxPQUFPLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxHQUFHLEdBQUcsQ0FBQztRQUMvQyxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDbkIsQ0FBQztJQUVELElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxTQUFTLEVBQUUsQ0FBQztRQUM1QixJQUFJLE9BQU8sSUFBSSxDQUFDLEtBQUssS0FBSyxRQUFRLEVBQUUsQ0FBQztZQUNuQyxPQUFPLE1BQU0sQ0FBQyxHQUFHLENBQUEsSUFBSSxhQUFhLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDO1FBQy9ELENBQUM7UUFDRCxPQUFPLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssZ0JBQWdCLEVBQUUsQ0FBQztRQUNuQyxPQUFPLENBQ0wsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUM7WUFDcEMsR0FBRztZQUNILElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7WUFDbEUsR0FBRyxDQUNKLENBQUM7SUFDSixDQUFDO0lBRUQsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLGlCQUFpQixFQUFFLENBQUM7UUFDcEMsT0FBTyxDQUNMLEdBQUc7WUFDSCxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO1lBQ2pFLEdBQUcsQ0FDSixDQUFDO0lBQ0osQ0FBQztJQUVELElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxVQUFVLEVBQUUsQ0FBQztRQUM3QixPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBRUQsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLHVCQUF1QixFQUFFLENBQUM7UUFDMUMsT0FBTyxDQUNMLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7WUFDNUIsS0FBSztZQUNMLGlCQUFpQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7WUFDbEMsS0FBSztZQUNMLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FDbEMsQ0FBQztJQUNKLENBQUM7SUFFRCxPQUFPLEVBQUUsQ0FBQztBQUNaLENBQUM7QUFFRCxTQUFTLGFBQWEsQ0FBQyxDQUFTO0lBQzlCLE9BQU8sQ0FDTCxDQUFDO1FBQ0MsdUNBQXVDO1NBQ3RDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsZ0JBQWdCLENBQUM7UUFFbEMsOEVBQThFO1NBQzdFLE9BQU8sQ0FBQyxvQkFBb0IsRUFBRSxRQUFRLENBQUM7UUFFeEMsa0RBQWtEO1NBQ2pELE9BQU8sQ0FBQyxhQUFhLEVBQUUsT0FBTyxDQUFDO1NBQy9CLE9BQU8sQ0FBQyxhQUFhLEVBQUUsT0FBTyxDQUFDO1FBRWhDLHdDQUF3QztTQUN2QyxPQUFPLENBQUMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLENBQ3JDLENBQUM7QUFDSixDQUFDIn0=