"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeploymentType = exports.DeploymentStatus = exports.SandboxVisibility = exports.SandboxVersionStatus = exports.BaseVersion = exports.DependencyTableType = exports.RowHeightMap = exports.RowHeight = exports.CURRENT_USER_TOKEN = exports.DURATION_TYPE_MAP = exports.NON_SEAT_ROLES = exports.NO_SCOPE = exports.LongTextAiMetaProp = exports.ROW_COLORING_MODE = exports.NcErrorType = exports.NcDataErrorCodes = exports.TiptapMarksTypes = exports.TiptapNodesTypes = exports.ProjectStatus = exports.AutomationTypes = exports.ModelTypes = exports.PluginCategory = exports.ExportTypes = exports.ExpandedFormMode = exports.RelationTypes = exports.ProjectTypes = exports.VIEW_GRID_DEFAULT_WIDTH = exports.stringToViewTypeMap = exports.viewTypeToStringMap = exports.viewTypeAlias = exports.ViewTypes = exports.enumColors = void 0;
const enums_1 = require("./enums");
exports.enumColors = {
    light: [
        '#cfdffe',
        '#d0f1fd',
        '#c2f5e8',
        '#ffdaf6',
        '#ffdce5',
        '#fee2d5',
        '#ffeab6',
        '#d1f7c4',
        '#ede2fe',
        '#eeeeee',
    ],
    dark: [
        '#2d7ff999',
        '#18bfff99',
        '#20d9d299',
        '#ff08c299',
        '#f82b6099',
        '#ff6f2c99',
        '#fcb40099',
        '#20c93399',
        '#8b46ff99',
        '#666',
    ],
    get: (theme, index) => {
        index = Math.abs(index) % exports.enumColors[theme].length;
        return exports.enumColors[theme][index];
    },
};
var ViewTypes;
(function (ViewTypes) {
    ViewTypes[ViewTypes["FORM"] = 1] = "FORM";
    ViewTypes[ViewTypes["GALLERY"] = 2] = "GALLERY";
    ViewTypes[ViewTypes["GRID"] = 3] = "GRID";
    ViewTypes[ViewTypes["KANBAN"] = 4] = "KANBAN";
    ViewTypes[ViewTypes["MAP"] = 5] = "MAP";
    ViewTypes[ViewTypes["CALENDAR"] = 6] = "CALENDAR";
})(ViewTypes || (exports.ViewTypes = ViewTypes = {}));
exports.viewTypeAlias = {
    [ViewTypes.FORM]: 'form',
    [ViewTypes.GALLERY]: 'gallery',
    [ViewTypes.GRID]: 'grid',
    [ViewTypes.KANBAN]: 'kanban',
    [ViewTypes.MAP]: 'map',
    [ViewTypes.CALENDAR]: 'calendar',
};
exports.viewTypeToStringMap = Object.assign({}, exports.viewTypeAlias);
// Generate reverse mapping from the original viewTypeAlias
exports.stringToViewTypeMap = Object.entries(exports.viewTypeAlias).reduce((acc, [key, value]) => {
    acc[value] = Number(key);
    return acc;
}, {});
exports.VIEW_GRID_DEFAULT_WIDTH = 200;
var ProjectTypes;
(function (ProjectTypes) {
    ProjectTypes["DATABASE"] = "database";
    ProjectTypes["DOCUMENTATION"] = "documentation";
    ProjectTypes["COWRITER"] = "cowriter";
    ProjectTypes["DASHBOARD"] = "dashboard";
})(ProjectTypes || (exports.ProjectTypes = ProjectTypes = {}));
var RelationTypes;
(function (RelationTypes) {
    RelationTypes["HAS_MANY"] = "hm";
    RelationTypes["BELONGS_TO"] = "bt";
    RelationTypes["MANY_TO_MANY"] = "mm";
    RelationTypes["ONE_TO_ONE"] = "oo";
})(RelationTypes || (exports.RelationTypes = RelationTypes = {}));
exports.ExpandedFormMode = {
    FIELD: 'field',
    ATTACHMENT: 'attachment',
    DISCUSSION: 'discussion',
};
var ExportTypes;
(function (ExportTypes) {
    ExportTypes["EXCEL"] = "excel";
    ExportTypes["CSV"] = "csv";
})(ExportTypes || (exports.ExportTypes = ExportTypes = {}));
var PluginCategory;
(function (PluginCategory) {
    PluginCategory["STORAGE"] = "Storage";
    PluginCategory["EMAIL"] = "Email";
})(PluginCategory || (exports.PluginCategory = PluginCategory = {}));
var ModelTypes;
(function (ModelTypes) {
    ModelTypes["TABLE"] = "table";
    ModelTypes["VIEW"] = "view";
    ModelTypes["DASHBOARD"] = "dashboard";
})(ModelTypes || (exports.ModelTypes = ModelTypes = {}));
var AutomationTypes;
(function (AutomationTypes) {
    AutomationTypes["SCRIPT"] = "script";
    AutomationTypes["WORKFLOW"] = "workflow";
})(AutomationTypes || (exports.AutomationTypes = AutomationTypes = {}));
var ProjectStatus;
(function (ProjectStatus) {
    ProjectStatus["JOB"] = "job";
})(ProjectStatus || (exports.ProjectStatus = ProjectStatus = {}));
var TiptapNodesTypes;
(function (TiptapNodesTypes) {
    TiptapNodesTypes["doc"] = "doc";
    TiptapNodesTypes["sec"] = "sec";
    TiptapNodesTypes["paragraph"] = "paragraph";
    TiptapNodesTypes["text"] = "text";
    TiptapNodesTypes["heading"] = "heading";
    TiptapNodesTypes["bullet"] = "bullet";
    TiptapNodesTypes["ordered"] = "ordered";
    TiptapNodesTypes["task"] = "task";
    TiptapNodesTypes["quote"] = "quote";
    TiptapNodesTypes["divider"] = "divider";
    TiptapNodesTypes["codeBlock"] = "codeBlock";
    TiptapNodesTypes["image"] = "image";
    TiptapNodesTypes["callout"] = "callout";
    TiptapNodesTypes["tipCallout"] = "tipCallout";
    TiptapNodesTypes["table"] = "table";
    TiptapNodesTypes["tableRow"] = "tableRow";
    TiptapNodesTypes["tableCell"] = "tableCell";
    TiptapNodesTypes["embed"] = "embed";
    TiptapNodesTypes["collapsable"] = "collapsable";
    TiptapNodesTypes["collapsableContent"] = "collapsable_content";
    TiptapNodesTypes["collapsableHeader"] = "collapsable_header";
    TiptapNodesTypes["column"] = "column";
    TiptapNodesTypes["columnContent"] = "columnContent";
    TiptapNodesTypes["linkToPage"] = "linkToPage";
    TiptapNodesTypes["attachment"] = "attachment";
})(TiptapNodesTypes || (exports.TiptapNodesTypes = TiptapNodesTypes = {}));
var TiptapMarksTypes;
(function (TiptapMarksTypes) {
    TiptapMarksTypes["strike"] = "strike";
    TiptapMarksTypes["bold"] = "bold";
    TiptapMarksTypes["italic"] = "italic";
    TiptapMarksTypes["link"] = "link";
    TiptapMarksTypes["code"] = "code";
    TiptapMarksTypes["underline"] = "underline";
})(TiptapMarksTypes || (exports.TiptapMarksTypes = TiptapMarksTypes = {}));
var NcDataErrorCodes;
(function (NcDataErrorCodes) {
    NcDataErrorCodes["NC_ERR_MM_MODEL_NOT_FOUND"] = "NC_ERR_MM_MODEL_NOT_FOUND";
})(NcDataErrorCodes || (exports.NcDataErrorCodes = NcDataErrorCodes = {}));
var NcErrorType;
(function (NcErrorType) {
    NcErrorType["ERR_AUTHENTICATION_REQUIRED"] = "ERR_AUTHENTICATION_REQUIRED";
    NcErrorType["ERR_FORBIDDEN"] = "ERR_FORBIDDEN";
    NcErrorType["ERR_API_TOKEN_NOT_ALLOWED"] = "ERR_API_TOKEN_NOT_ALLOWED";
    NcErrorType["ERR_WORKSPACE_NOT_FOUND"] = "ERR_WORKSPACE_NOT_FOUND";
    NcErrorType["ERR_BASE_NOT_FOUND"] = "ERR_BASE_NOT_FOUND";
    NcErrorType["ERR_SOURCE_NOT_FOUND"] = "ERR_SOURCE_NOT_FOUND";
    NcErrorType["ERR_TABLE_NOT_FOUND"] = "ERR_TABLE_NOT_FOUND";
    NcErrorType["ERR_VIEW_NOT_FOUND"] = "ERR_VIEW_NOT_FOUND";
    NcErrorType["ERR_FIELD_NOT_FOUND"] = "ERR_FIELD_NOT_FOUND";
    NcErrorType["ERR_RECORD_NOT_FOUND"] = "ERR_RECORD_NOT_FOUND";
    NcErrorType["ERR_GENERIC_NOT_FOUND"] = "ERR_GENERIC_NOT_FOUND";
    NcErrorType["ERR_HOOK_NOT_FOUND"] = "ERR_HOOK_NOT_FOUND";
    NcErrorType["ERR_REQUIRED_FIELD_MISSING"] = "ERR_REQUIRED_FIELD_MISSING";
    NcErrorType["ERR_DUPLICATE_RECORD"] = "ERR_DUPLICATE_RECORD";
    NcErrorType["ERR_USER_NOT_FOUND"] = "ERR_USER_NOT_FOUND";
    NcErrorType["ERR_TEAM_NOT_FOUND"] = "ERR_TEAM_NOT_FOUND";
    NcErrorType["ERR_INVALID_OFFSET_VALUE"] = "ERR_INVALID_OFFSET_VALUE";
    NcErrorType["ERR_INVALID_PAGE_VALUE"] = "ERR_INVALID_PAGE_VALUE";
    NcErrorType["ERR_INVALID_LIMIT_VALUE"] = "ERR_INVALID_LIMIT_VALUE";
    NcErrorType["ERR_INVALID_FILTER"] = "ERR_INVALID_FILTER";
    NcErrorType["ERR_INVALID_SHARED_VIEW_PASSWORD"] = "ERR_INVALID_SHARED_VIEW_PASSWORD";
    NcErrorType["ERR_INVALID_ATTACHMENT_JSON"] = "ERR_INVALID_ATTACHMENT_JSON";
    NcErrorType["ERR_NOT_IMPLEMENTED"] = "ERR_NOT_IMPLEMENTED";
    NcErrorType["ERR_INTERNAL_SERVER"] = "ERR_INTERNAL_SERVER";
    NcErrorType["ERR_DATABASE_OP_FAILED"] = "ERR_DATABASE_OP_FAILED";
    NcErrorType["ERR_UNKNOWN"] = "ERR_UNKNOWN";
    NcErrorType["ERR_INVALID_JSON"] = "ERR_INVALID_JSON";
    NcErrorType["ERR_INVALID_PK_VALUE"] = "ERR_INVALID_PK_VALUE";
    NcErrorType["ERR_COLUMN_ASSOCIATED_WITH_LINK"] = "ERR_COLUMN_ASSOCIATED_WITH_LINK";
    NcErrorType["ERR_TABLE_ASSOCIATED_WITH_LINK"] = "ERR_TABLE_ASSOCIATED_WITH_LINK";
    NcErrorType["ERR_INTEGRATION_NOT_FOUND"] = "ERR_INTEGRATION_NOT_FOUND";
    NcErrorType["ERR_INTEGRATION_LINKED_WITH_BASES"] = "ERR_INTEGRATION_LINKED_WITH_BASES";
    NcErrorType["ERR_FORMULA"] = "ERR_FORMULA";
    NcErrorType["ERR_CIRCULAR_REF_IN_FORMULA"] = "ERR_CIRCULAR_REF_IN_FORMULA";
    NcErrorType["ERR_PERMISSION_DENIED"] = "ERR_PERMISSION_DENIED";
    NcErrorType["ERR_INVALID_ATTACHMENT_UPLOAD_SCOPE"] = "ERR_INVALID_ATTACHMENT_UPLOAD_SCOPE";
    NcErrorType["ERR_CANNOT_CALCULATE_INTERMEDIATE_ORDER"] = "ERR_CANNOT_CALCULATE_INTERMEDIATE_ORDER";
    NcErrorType["ERR_REORDER_FAILED"] = "ERR_REORDER_FAILED";
    NcErrorType["ERR_PLAN_LIMIT_EXCEEDED"] = "ERR_PLAN_LIMIT_EXCEEDED";
    NcErrorType["ERR_FEATURE_NOT_SUPPORTED"] = "ERR_FEATURE_NOT_SUPPORTED";
    NcErrorType["ERR_SSO_LOGIN_REQUIRED"] = "ERR_SSO_LOGIN_REQUIRED";
    NcErrorType["ERR_SSO_GENERATED_TOKEN_REQUIRED"] = "ERR_SSO_GENERATED_TOKEN_REQUIRED";
    NcErrorType["ERR_MAX_PAYLOAD_LIMIT_EXCEEDED"] = "ERR_MAX_PAYLOAD_LIMIT_EXCEEDED";
    NcErrorType["ERR_INVALID_VALUE_FOR_FIELD"] = "ERR_INVALID_VALUE_FOR_FIELD";
    NcErrorType["ERR_MAX_WORKSPACE_LIMIT_REACHED"] = "ERR_MAX_WORKSPACE_LIMIT_REACHED";
    NcErrorType["ERR_BASE_COLLABORATION"] = "ERR_BASE_COLLABORATION";
    NcErrorType["ERR_ORG_USER"] = "ERR_ORG_USER";
    NcErrorType["ERR_SYNC_TABLE_OPERATION_PROHIBITED"] = "ERR_SYNC_TABLE_OPERATION_PROHIBITED";
    NcErrorType["ERR_INVALID_REQUEST_BODY"] = "ERR_INVALID_REQUEST_BODY";
    NcErrorType["ERR_DASHBOARD_NOT_FOUND"] = "ERR_DASHBOARD_NOT_FOUND";
    NcErrorType["ERR_WORKFLOW_NOT_FOUND"] = "ERR_WORKFLOW_NOT_FOUND";
    NcErrorType["ERR_WIDGET_NOT_FOUND"] = "ERR_WIDGET_NOT_FOUND";
    NcErrorType["ERR_SHARED_DASHBOARD_PASSWORD_INVALID"] = "ERR_SHARED_DASHBOARD_PASSWORD_INVALID";
    NcErrorType["ERR_DUPLICATE_IN_ALIAS"] = "ERR_DUPLICATE_IN_ALIAS";
    NcErrorType["ERR_OUT_OF_SYNC"] = "ERR_OUT_OF_SYNC";
    NcErrorType["ERR_FILTER_VERIFICATION_FAILED"] = "ERR_FILTER_VERIFICATION_FAILED";
    NcErrorType["ERR_VIEW_COLUMN_NOT_FOUND"] = "ERR_VIEW_COLUMN_NOT_FOUND";
    NcErrorType["ERR_WEBHOOK_ERROR"] = "ERR_WEBHOOK_ERROR";
    NcErrorType["ERR_WEBHOOK_URL_INVALID"] = "ERR_WEBHOOK_URL_INVALID";
    NcErrorType["ERR_BASE_OP_FAILED"] = "ERR_BASE_OP_FAILED";
    NcErrorType["ERR_TABLE_OP_FAILED"] = "ERR_TABLE_OP_FAILED";
    NcErrorType["ERR_COLUMN_OP_FAILED"] = "ERR_COLUMN_OP_FAILED";
    NcErrorType["ERR_DATA_SOURCES_NOT_FOUND"] = "ERR_DATA_SOURCES_NOT_FOUND";
    NcErrorType["ERR_TEST_PLUGIN_FAILED"] = "ERR_TEST_PLUGIN_FAILED";
    NcErrorType["ERR_UNSUPPORTED_RELATION"] = "ERR_UNSUPPORTED_RELATION";
    NcErrorType["ERR_IN_EXTERNAL_DATA_SOURCE"] = "ERR_IN_EXTERNAL_DATA_SOURCE";
    NcErrorType["ERR_EXTERNAL_DATA_SOURCE_TIMEOUT"] = "ERR_EXTERNAL_DATA_SOURCE_TIMEOUT";
    NcErrorType["ERR_RELATION_FIELD_NOT_FOUND"] = "ERR_RELATION_FIELD_NOT_FOUND";
    NcErrorType["ERR_UNSUPPORTED_FILTER_OPERATION"] = "ERR_UNSUPPORTED_FILTER_OPERATION";
    NcErrorType["ERR_STORAGE_FILE_CREATE"] = "ERR_STORAGE_FILE_CREATE";
    NcErrorType["ERR_STORAGE_FILE_READ"] = "ERR_STORAGE_FILE_READ";
    NcErrorType["ERR_STORAGE_FILE_DELETE"] = "ERR_STORAGE_FILE_DELETE";
    NcErrorType["ERR_STORAGE_FILE_STREAM"] = "ERR_STORAGE_FILE_STREAM";
    NcErrorType["ERR_PLAN_ALREADY_EXISTS"] = "ERR_PLAN_ALREADY_EXISTS";
    NcErrorType["ERR_SUBSCRIPTION_ALREADY_EXISTS"] = "ERR_SUBSCRIPTION_ALREADY_EXISTS";
    NcErrorType["ERR_SUBSCRIPTION_NOT_FOUND"] = "ERR_SUBSCRIPTION_NOT_FOUND";
    NcErrorType["ERR_PLAN_NOT_AVAILABLE"] = "ERR_PLAN_NOT_AVAILABLE";
    NcErrorType["ERR_SEAT_COUNT_MISMATCH"] = "ERR_SEAT_COUNT_MISMATCH";
    NcErrorType["ERR_INVALID_PAYMENT_PAYLOAD"] = "ERR_INVALID_PAYMENT_PAYLOAD";
    NcErrorType["ERR_STRIPE_CUSTOMER_NOT_FOUND"] = "ERR_STRIPE_CUSTOMER_NOT_FOUND";
    NcErrorType["ERR_STRIPE_SUBSCRIPTION_NOT_FOUND"] = "ERR_STRIPE_SUBSCRIPTION_NOT_FOUND";
    NcErrorType["ERR_SUBSCRIPTION_OWNERSHIP_MISMATCH"] = "ERR_SUBSCRIPTION_OWNERSHIP_MISMATCH";
    NcErrorType["ERR_INTERNAL_CUSTOMER_NOT_SUPPORTED"] = "ERR_INTERNAL_CUSTOMER_NOT_SUPPORTED";
    NcErrorType["ERR_SUBSCRIPTION_CREATE_FAILED"] = "ERR_SUBSCRIPTION_CREATE_FAILED";
    NcErrorType["ERR_STRIPE_WEBHOOK_VERIFICATION_FAILED"] = "ERR_STRIPE_WEBHOOK_VERIFICATION_FAILED";
    NcErrorType["ERR_API_CLIENT_NOT_FOUND"] = "ERR_API_CLIENT_NOT_FOUND";
    NcErrorType["ERR_EXTENSION_NOT_FOUND"] = "ERR_EXTENSION_NOT_FOUND";
    NcErrorType["ERR_SCRIPT_NOT_FOUND"] = "ERR_SCRIPT_NOT_FOUND";
    NcErrorType["FIELD_UNIQUE_CONSTRAINT_VIOLATION"] = "FIELD_UNIQUE_CONSTRAINT_VIOLATION";
    NcErrorType["ERR_METHOD_NOT_ALLOWED"] = "ERR_METHOD_NOT_ALLOWED";
    // Workflow Errors
    NcErrorType["ERR_WORKFLOW_EMPTY_NODE"] = "ERR_WORKFLOW_EMPTY_NODE";
    NcErrorType["ERR_WORKFLOW_TRIGGER_NODE_NOT_FOUND"] = "ERR_WORKFLOW_TRIGGER_NODE_NOT_FOUND";
    NcErrorType["ERR_WORKFLOW_NODE_EXECUTION_FAILED"] = "ERR_WORKFLOW_NODE_EXECUTION_FAILED";
    NcErrorType["ERR_WORKFLOW_MAX_ITERATIONS_EXCEEDED"] = "ERR_WORKFLOW_MAX_ITERATIONS_EXCEEDED";
    NcErrorType["ERR_WORKFLOW_NODE_NOT_FOUND"] = "ERR_WORKFLOW_NODE_NOT_FOUND";
    NcErrorType["ERR_WORKFLOW_WAITING_EXECUTIONS"] = "ERR_WORKFLOW_WAITING_EXECUTIONS";
})(NcErrorType || (exports.NcErrorType = NcErrorType = {}));
var ROW_COLORING_MODE;
(function (ROW_COLORING_MODE) {
    ROW_COLORING_MODE["FILTER"] = "filter";
    ROW_COLORING_MODE["SELECT"] = "select";
})(ROW_COLORING_MODE || (exports.ROW_COLORING_MODE = ROW_COLORING_MODE = {}));
exports.LongTextAiMetaProp = 'ai';
exports.NO_SCOPE = 'nc';
exports.NON_SEAT_ROLES = [
    enums_1.WorkspaceUserRoles.NO_ACCESS,
    enums_1.WorkspaceUserRoles.VIEWER,
    enums_1.WorkspaceUserRoles.INHERIT,
    enums_1.WorkspaceUserRoles.COMMENTER,
    enums_1.ProjectRoles.NO_ACCESS,
    enums_1.ProjectRoles.VIEWER,
    enums_1.ProjectRoles.INHERIT,
    enums_1.ProjectRoles.COMMENTER,
];
exports.DURATION_TYPE_MAP = {
    0: 'h:mm',
    1: 'h:mm:ss',
    2: 'h:mm:ss.s',
    3: 'h:mm:ss.ss',
    4: 'h:mm:ss.sss',
    'h:mm': 0,
    'h:mm:ss': 1,
    'h:mm:ss.s': 2,
    'h:mm:ss.ss': 3,
    'h:mm:ss.sss': 4,
};
exports.CURRENT_USER_TOKEN = '@me';
var RowHeight;
(function (RowHeight) {
    RowHeight[RowHeight["SHORT"] = 0] = "SHORT";
    RowHeight[RowHeight["MEDIUM"] = 1] = "MEDIUM";
    RowHeight[RowHeight["TALL"] = 2] = "TALL";
    RowHeight[RowHeight["EXTRA"] = 3] = "EXTRA";
})(RowHeight || (exports.RowHeight = RowHeight = {}));
exports.RowHeightMap = {
    short: RowHeight.SHORT,
    medium: RowHeight.MEDIUM,
    tall: RowHeight.TALL,
    extra: RowHeight.EXTRA,
    [RowHeight.SHORT]: 'short',
    [RowHeight.MEDIUM]: 'medium',
    [RowHeight.TALL]: 'tall',
    [RowHeight.EXTRA]: 'extra',
};
var DependencyTableType;
(function (DependencyTableType) {
    DependencyTableType["Column"] = "column";
    DependencyTableType["Model"] = "table";
    DependencyTableType["View"] = "view";
    DependencyTableType["Widget"] = "widget";
    DependencyTableType["Workflow"] = "workflow";
})(DependencyTableType || (exports.DependencyTableType = DependencyTableType = {}));
var BaseVersion;
(function (BaseVersion) {
    BaseVersion[BaseVersion["V2"] = 2] = "V2";
    BaseVersion[BaseVersion["V3"] = 3] = "V3";
})(BaseVersion || (exports.BaseVersion = BaseVersion = {}));
var SandboxVersionStatus;
(function (SandboxVersionStatus) {
    SandboxVersionStatus["DRAFT"] = "draft";
    SandboxVersionStatus["PUBLISHED"] = "published";
})(SandboxVersionStatus || (exports.SandboxVersionStatus = SandboxVersionStatus = {}));
var SandboxVisibility;
(function (SandboxVisibility) {
    SandboxVisibility["PUBLIC"] = "public";
    SandboxVisibility["PRIVATE"] = "private";
    SandboxVisibility["UNLISTED"] = "unlisted";
})(SandboxVisibility || (exports.SandboxVisibility = SandboxVisibility = {}));
var DeploymentStatus;
(function (DeploymentStatus) {
    DeploymentStatus["PENDING"] = "pending";
    DeploymentStatus["IN_PROGRESS"] = "in_progress";
    DeploymentStatus["SUCCESS"] = "success";
    DeploymentStatus["FAILED"] = "failed";
})(DeploymentStatus || (exports.DeploymentStatus = DeploymentStatus = {}));
var DeploymentType;
(function (DeploymentType) {
    DeploymentType["INSTALL"] = "install";
    DeploymentType["UPDATE"] = "update";
})(DeploymentType || (exports.DeploymentType = DeploymentType = {}));
//# sourceMappingURL=data:application/json;base64,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